/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web.config;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.geo.GeoJacksonModule;
import org.springframework.data.web.PagedModel;
import org.springframework.data.web.config.EnableSpringDataWebSupport;
import org.springframework.data.web.config.SpringDataJackson3Modules;
import org.springframework.data.web.config.SpringDataWebSettings;
import org.springframework.util.ClassUtils;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JsonSerialize;
import tools.jackson.databind.module.SimpleModule;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.ValueSerializerModifier;
import tools.jackson.databind.ser.std.ToStringSerializerBase;
import tools.jackson.databind.util.StdConverter;

public class SpringDataJackson3Configuration
implements SpringDataJackson3Modules {
    @Autowired(required=false)
    @Nullable SpringDataWebSettings settings;

    @Bean
    public GeoJacksonModule jackson3GeoModule() {
        return new GeoJacksonModule();
    }

    @Bean
    public PageModule jackson3pageModule() {
        return new PageModule(this.settings);
    }

    public static class PageModule
    extends SimpleModule {
        private static final long serialVersionUID = 275254460581626332L;
        private static final String UNPAGED_TYPE_NAME = "org.springframework.data.domain.Unpaged";
        private static final Class<?> UNPAGED_TYPE = ClassUtils.resolveClassName((String)"org.springframework.data.domain.Unpaged", (ClassLoader)PageModule.class.getClassLoader());

        public PageModule(@Nullable SpringDataWebSettings settings) {
            this.addSerializer(UNPAGED_TYPE, (ValueSerializer)new UnpagedAsInstanceSerializer());
            if (settings == null || settings.pageSerializationMode() == EnableSpringDataWebSupport.PageSerializationMode.DIRECT) {
                this.setSerializerModifier(new WarningLoggingModifier());
            } else {
                this.setMixInAnnotation(PageImpl.class, WrappingMixing.class);
            }
        }

        static class UnpagedAsInstanceSerializer
        extends ToStringSerializerBase {
            public UnpagedAsInstanceSerializer() {
                super(Object.class);
            }

            public String valueToString(@Nullable Object value) {
                return "INSTANCE";
            }
        }

        static class WarningLoggingModifier
        extends ValueSerializerModifier {
            private static final Logger LOGGER = LoggerFactory.getLogger(WarningLoggingModifier.class);
            private static final String MESSAGE = "Serializing PageImpl instances as-is is not supported, meaning that there is no guarantee about the stability of the resulting JSON structure!\n\tFor a stable JSON structure, please use Spring Data's PagedModel (globally via @EnableSpringDataWebSupport(pageSerializationMode = VIA_DTO))\n\tor Spring HATEOAS and Spring Data's PagedResourcesAssembler as documented in https://docs.spring.io/spring-data/commons/reference/repositories/core-extensions.html#core.web.pageables.\n";
            private static final long serialVersionUID = 954857444010009875L;
            private boolean warningRendered = false;

            WarningLoggingModifier() {
            }

            public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription.Supplier beanDesc, List<BeanPropertyWriter> beanProperties) {
                if (Page.class.isAssignableFrom(beanDesc.getBeanClass()) && !this.warningRendered) {
                    this.warningRendered = true;
                    LOGGER.warn(MESSAGE);
                }
                return super.changeProperties(config, beanDesc, beanProperties);
            }
        }

        @JsonSerialize(converter=PageModelConverter.class)
        static abstract class WrappingMixing {
            WrappingMixing() {
            }
        }

        static class PageModelConverter
        extends StdConverter<Page<?>, PagedModel<?>> {
            PageModelConverter() {
            }

            public @Nullable PagedModel<?> convert(@Nullable Page<?> value) {
                return value == null ? null : new PagedModel(value);
            }
        }
    }
}

