-- Removes the enum name constraint from context, allowing us to add new entries.

-- 1. Rename the existing table
ALTER TABLE download_model RENAME TO download_model_temp;

-- 2. Create new table without the check constraint
CREATE TABLE download_model (
                                id integer,
                                context varchar(255),
                                download_url varchar(255),
                                fix integer NOT NULL,
                                is_downloaded boolean NOT NULL,
                                major integer NOT NULL,
                                minor integer NOT NULL,
                                path varchar(255),
                                prerelease integer NOT NULL,
                                release_notes varchar(255),
                                sha256 varchar(255),
                                PRIMARY KEY (id)
);

-- 3. Copy data into new table
INSERT INTO download_model (
    id, context, download_url, fix, is_downloaded, major, minor,
    path, prerelease, release_notes, sha256
)
SELECT
    id, context, download_url, fix, is_downloaded, major, minor,
    path, prerelease, release_notes, sha256
FROM download_model_temp;

-- 4. Drop the temporary table
DROP TABLE download_model_temp;
