/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.device.detection.device;

import com.revrobotics.device.detection.device.FRCCanDevice;
import java.util.List;
import java.util.UUID;

public record DeviceTree(FRCCanDevice root, String descriptor, List<FRCCanDevice> children) {
    public boolean busMatches(List<FRCCanDevice> devices) {
        if (devices.size() != this.children.size() + 1) {
            return false;
        }
        for (FRCCanDevice device : devices) {
            if (this.root.frcEquals(device)) continue;
            if (!this.children.stream().noneMatch(device::frcEquals)) continue;
            return false;
        }
        return true;
    }

    public boolean hasUUID(UUID uuid) {
        return this.root.uuid().equals(uuid) || this.children.stream().anyMatch(device -> device.uuid().equals(uuid));
    }
}

