/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.device.detection.device;

import com.revrobotics.device.detection.device.DeviceType;
import com.revrobotics.device.detection.device.Manufacturer;

public enum RecognizedDevice {
    UNKNOWN_SPARK(CommunicationType.CAN),
    SPARK_FLEX(CommunicationType.CAN),
    SPARK_MAX(CommunicationType.CAN),
    PDH(CommunicationType.CAN),
    PH(CommunicationType.CAN),
    SERVO_HUB(CommunicationType.CAN),
    CTRE_DEVICE(CommunicationType.CAN),
    FUSION_DEVICE(CommunicationType.CAN),
    THRIFTY_DEVICE(CommunicationType.CAN),
    STUDICA_DEVICE(CommunicationType.CAN),
    REDUX_DEVICE(CommunicationType.CAN),
    SWYFT_DEVICE(CommunicationType.CAN),
    ROBORIO(CommunicationType.CAN),
    CONTROL_HUB(CommunicationType.RS485),
    EXPANSION_HUB(CommunicationType.RS485),
    DFU(CommunicationType.DFU),
    GS_USB(CommunicationType.GS_USB),
    REV_FIRMWARE_INTERFACE(CommunicationType.CAN),
    UNKNOWN_ENCODER(CommunicationType.CAN),
    MAXSPLINE_ENCODER(CommunicationType.CAN);

    private final CommunicationType communicationType;

    private RecognizedDevice(CommunicationType communicationType) {
        this.communicationType = communicationType;
    }

    public CommunicationType getCommunicationType() {
        return this.communicationType;
    }

    public static RecognizedDevice fromCanInfo(Manufacturer manufacturer, DeviceType type) {
        return switch (manufacturer) {
            case Manufacturer.REV -> {
                switch (type) {
                    case POWER_DISTRIBUTION: {
                        yield PDH;
                    }
                    case PNEUMATICS: {
                        yield PH;
                    }
                    case SERVO_CONTROLLER: {
                        yield SERVO_HUB;
                    }
                    case MOTOR_CONTROLLER: {
                        yield UNKNOWN_SPARK;
                    }
                    case FIRMWARE_UPDATE: {
                        yield REV_FIRMWARE_INTERFACE;
                    }
                    case ENCODER: {
                        yield UNKNOWN_ENCODER;
                    }
                }
                yield null;
            }
            case Manufacturer.NI -> {
                if (type == DeviceType.ROBOT_CONTROLLER) {
                    yield ROBORIO;
                }
                yield null;
            }
            case Manufacturer.CTRE -> CTRE_DEVICE;
            case Manufacturer.THRIFTY -> THRIFTY_DEVICE;
            case Manufacturer.PLAYING_WITH_FUSION -> FUSION_DEVICE;
            case Manufacturer.STUDICA -> STUDICA_DEVICE;
            case Manufacturer.REDUX -> REDUX_DEVICE;
            case Manufacturer.SWYFT -> SWYFT_DEVICE;
            default -> null;
        };
    }

    public static boolean isCan(RecognizedDevice device) {
        if (device == null) {
            return false;
        }
        return device.communicationType == CommunicationType.CAN;
    }

    public static boolean isGsUsb(RecognizedDevice device) {
        if (device == null) {
            return false;
        }
        return device.communicationType == CommunicationType.GS_USB;
    }

    public boolean isSPARK() {
        return this == UNKNOWN_SPARK || this == SPARK_FLEX || this == SPARK_MAX;
    }

    public static RecognizedDevice getSparkTypeFromProductId(int versionParameter) {
        if (versionParameter == 8537) {
            return SPARK_FLEX;
        }
        if (versionParameter == 8536) {
            return SPARK_MAX;
        }
        return UNKNOWN_SPARK;
    }

    public static enum CommunicationType {
        CAN,
        DFU,
        GS_USB,
        RS485;

    }
}

