/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.device.detection.gsusb;

import com.revrobotics.device.detection.gsusb.GSUsbManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.usb4java.Context;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;
import org.usb4java.Loader;

public class LibUsbGSUsbManager
implements GSUsbManager {
    private final Context context;
    private static final short VENDOR_ID = 1155;
    private static final short SPARK_PRODUCT_ID = -23794;
    private static final short HUB_PID = -23631;
    private List<GSUsbManager.GsUsbDevice> cachedList = List.of();
    private long lastDetectionTime = 0L;
    private static final int DETECTION_INTERVAL_MS = 4000;

    public LibUsbGSUsbManager() {
        LibUsbGSUsbManager.fixLibUsb();
        this.context = new Context();
        int result = LibUsb.init((Context)this.context);
        if (result != 0) {
            System.err.println("LibUsb.init() failed: " + LibUsb.strError((int)result));
        } else {
            System.out.println("LibUsb initialized successfully!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GSUsbManager.GsUsbDevice> listGsUsbDevices() {
        if (System.currentTimeMillis() - this.lastDetectionTime < 4000L) {
            return this.cachedList;
        }
        this.lastDetectionTime = System.currentTimeMillis();
        ArrayList<GSUsbManager.GsUsbDevice> devices = new ArrayList<GSUsbManager.GsUsbDevice>();
        DeviceList list = new DeviceList();
        int result = LibUsb.getDeviceList((Context)this.context, (DeviceList)list);
        if (result < 0) {
            return Collections.emptyList();
        }
        try {
            for (Device device : list) {
                DeviceDescriptor descriptor;
                result = LibUsb.getDeviceDescriptor((Device)device, (DeviceDescriptor)(descriptor = new DeviceDescriptor()));
                if (result != 0) continue;
                if (this.isSpark(descriptor)) {
                    devices.add(new GSUsbManager.GsUsbDevice(LibUsbGSUsbManager.getSparkDescriptor(descriptor)));
                    continue;
                }
                if (!this.isHub(descriptor)) continue;
                devices.add(new GSUsbManager.GsUsbDevice(LibUsbGSUsbManager.getHubDescriptor(descriptor)));
            }
        }
        finally {
            LibUsb.freeDeviceList((DeviceList)list, (boolean)true);
        }
        this.cachedList = devices;
        return devices;
    }

    private boolean isSpark(DeviceDescriptor descriptor) {
        return descriptor.bDeviceClass() == 0 && descriptor.idVendor() == 1155 && descriptor.idProduct() == -23794;
    }

    private boolean isHub(DeviceDescriptor descriptor) {
        return descriptor.bDeviceClass() == 0 && descriptor.idVendor() == 1155 && descriptor.idProduct() == -23631;
    }

    public static String getSparkDescriptor(DeviceDescriptor descriptor) {
        return String.format("SPARK %04X:%04X:%04X", descriptor.idVendor(), descriptor.idProduct(), descriptor.iSerialNumber());
    }

    public static String getHubDescriptor(DeviceDescriptor descriptor) {
        return String.format("HUB %04X:%04X:%04X", descriptor.idVendor(), descriptor.idProduct(), descriptor.iSerialNumber());
    }

    private static void fixLibUsb() {
        if (System.getProperty("app.dir") == null) {
            return;
        }
        try {
            Field field = Loader.class.getDeclaredField("loaded");
            field.setAccessible(true);
            field.set(null, true);
            try {
                System.loadLibrary("usb4java");
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.loadLibrary("libusb4java");
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

