/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.servohub.config;

import com.revrobotics.config.BaseConfig;
import com.revrobotics.servohub.ServoChannel;
import com.revrobotics.servohub.config.ServoHubParameter;

public class ServoChannelConfig
extends BaseConfig {
    private ServoChannel.ChannelId channelId;
    private static final int[] minPulseParams = new int[]{ServoHubParameter.kChannel0_MinPulseWidth.value, ServoHubParameter.kChannel1_MinPulseWidth.value, ServoHubParameter.kChannel2_MinPulseWidth.value, ServoHubParameter.kChannel3_MinPulseWidth.value, ServoHubParameter.kChannel4_MinPulseWidth.value, ServoHubParameter.kChannel5_MinPulseWidth.value};
    private static final int[] centerPulseParams = new int[]{ServoHubParameter.kChannel0_CenterPulseWidth.value, ServoHubParameter.kChannel1_CenterPulseWidth.value, ServoHubParameter.kChannel2_CenterPulseWidth.value, ServoHubParameter.kChannel3_CenterPulseWidth.value, ServoHubParameter.kChannel4_CenterPulseWidth.value, ServoHubParameter.kChannel5_CenterPulseWidth.value};
    private static final int[] maxPulseParams = new int[]{ServoHubParameter.kChannel0_MaxPulseWidth.value, ServoHubParameter.kChannel1_MaxPulseWidth.value, ServoHubParameter.kChannel2_MaxPulseWidth.value, ServoHubParameter.kChannel3_MaxPulseWidth.value, ServoHubParameter.kChannel4_MaxPulseWidth.value, ServoHubParameter.kChannel5_MaxPulseWidth.value};
    private static final int[] disableBehaviorParams = new int[]{ServoHubParameter.kChannel0_DisableBehavior.value, ServoHubParameter.kChannel1_DisableBehavior.value, ServoHubParameter.kChannel2_DisableBehavior.value, ServoHubParameter.kChannel3_DisableBehavior.value, ServoHubParameter.kChannel4_DisableBehavior.value, ServoHubParameter.kChannel5_DisableBehavior.value};

    public ServoChannelConfig(ServoChannel.ChannelId channelId) {
        super(BaseConfig.CANType.kServoHub);
        this.channelId = channelId;
    }

    public ServoChannelConfig apply(ServoChannelConfig config) {
        Object disableBehavior;
        Object maxPulse;
        Object centerPulse;
        int srcChanIdx = config.channelId.value;
        int destChanIdx = this.channelId.value;
        Object minPulse = config.getParameter(minPulseParams[srcChanIdx]);
        if (minPulse != null) {
            this.putParameter(minPulseParams[destChanIdx], (Integer)minPulse);
        }
        if ((centerPulse = config.getParameter(centerPulseParams[srcChanIdx])) != null) {
            this.putParameter(centerPulseParams[destChanIdx], (Integer)centerPulse);
        }
        if ((maxPulse = config.getParameter(maxPulseParams[srcChanIdx])) != null) {
            this.putParameter(maxPulseParams[destChanIdx], (Integer)maxPulse);
        }
        if ((disableBehavior = config.getParameter(disableBehaviorParams[srcChanIdx])) != null) {
            this.putParameter(disableBehaviorParams[destChanIdx], (Boolean)disableBehavior);
        }
        return this;
    }

    public ServoChannelConfig pulseRange(int minPulse_us, int centerPulse_us, int maxPulse_us) {
        int chanIdx = this.channelId.value;
        this.putParameter(minPulseParams[chanIdx], minPulse_us);
        this.putParameter(centerPulseParams[chanIdx], centerPulse_us);
        this.putParameter(maxPulseParams[chanIdx], maxPulse_us);
        return this;
    }

    public ServoChannelConfig pulseRange(PulseRange pulseRange_us) {
        return this.pulseRange(pulseRange_us.minPulse_us, pulseRange_us.centerPulse_us, pulseRange_us.maxPulse_us);
    }

    public ServoChannelConfig disableBehavior(BehaviorWhenDisabled behavior) {
        boolean disableBehavior = behavior == BehaviorWhenDisabled.kSupplyPower;
        this.putParameter(disableBehaviorParams[this.channelId.value], disableBehavior);
        return this;
    }

    public static class PulseRange {
        public int minPulse_us;
        public int centerPulse_us;
        public int maxPulse_us;

        public PulseRange(int minPulse, int centerPulse, int maxPulse) {
            this.minPulse_us = minPulse;
            this.centerPulse_us = centerPulse;
            this.maxPulse_us = maxPulse;
        }
    }

    public static enum BehaviorWhenDisabled {
        kDoNotSupplyPower(0),
        kSupplyPower(1);

        public final int value;

        private BehaviorWhenDisabled(int value) {
            this.value = value;
        }
    }
}

