/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.sim;

import com.revrobotics.spark.SparkBase;
import com.revrobotics.spark.SparkFlex;
import com.revrobotics.spark.SparkMax;
import edu.wpi.first.hal.SimBoolean;
import edu.wpi.first.hal.SimDouble;
import edu.wpi.first.wpilibj.simulation.SimDeviceSim;

public class SparkAnalogSensorSim {
    private SimDouble m_voltage;
    private SimDouble m_position;
    private SimDouble m_velocity;
    private SimBoolean m_isInverted;
    private SimDouble m_positionConversionFactor;
    private SimDouble m_velocityConversionFactor;
    private final SparkBase m_spark;
    private String simDeviceName;

    public SparkAnalogSensorSim(SparkMax motor) {
        this.simDeviceName = "SPARK MAX [" + motor.getDeviceId() + "] ANALOG SENSOR";
        this.setupSimDevice();
        this.m_spark = motor;
    }

    public SparkAnalogSensorSim(SparkFlex motor) {
        this.simDeviceName = "SPARK Flex [" + motor.getDeviceId() + "] ANALOG SENSOR";
        this.setupSimDevice();
        this.m_spark = motor;
    }

    private boolean setupSimDevice() {
        SimDeviceSim analogSensorSim = new SimDeviceSim(this.simDeviceName);
        this.m_voltage = analogSensorSim.getDouble("Voltage");
        this.m_position = analogSensorSim.getDouble("Position");
        this.m_velocity = analogSensorSim.getDouble("Velocity");
        this.m_isInverted = analogSensorSim.getBoolean("Is Inverted");
        this.m_positionConversionFactor = analogSensorSim.getDouble("Position Conversion Factor");
        this.m_velocityConversionFactor = analogSensorSim.getDouble("Velocity Conversion Factor");
        return this.m_position == null;
    }

    private boolean checkAndSetupSimDevice() {
        if (this.m_position == null) {
            return this.setupSimDevice();
        }
        return false;
    }

    public void setVoltage(double voltage) {
        if (this.checkAndSetupSimDevice()) {
            return;
        }
        this.m_voltage.set(voltage);
    }

    public double getVoltage() {
        if (this.checkAndSetupSimDevice()) {
            return 0.0;
        }
        return this.m_voltage.get();
    }

    public void setPosition(double position) {
        if (this.checkAndSetupSimDevice()) {
            return;
        }
        this.m_position.set(position);
    }

    public double getPosition() {
        if (this.checkAndSetupSimDevice()) {
            return 0.0;
        }
        return this.m_position.get();
    }

    public void setVelocity(double velocity) {
        if (this.checkAndSetupSimDevice()) {
            return;
        }
        this.m_velocity.set(velocity);
    }

    public double getVelocity() {
        if (this.checkAndSetupSimDevice()) {
            return 0.0;
        }
        return this.m_velocity.get();
    }

    public void setInverted(boolean inverted) {
        if (this.checkAndSetupSimDevice()) {
            return;
        }
        this.m_isInverted.set(inverted);
    }

    public boolean getInverted() {
        if (this.checkAndSetupSimDevice()) {
            return false;
        }
        return this.m_isInverted.get();
    }

    public double getPositionConversionFactor() {
        if (this.checkAndSetupSimDevice()) {
            return 0.0;
        }
        return this.m_positionConversionFactor.get();
    }

    public double getVelocityConversionFactor() {
        if (this.checkAndSetupSimDevice()) {
            return 0.0;
        }
        return this.m_velocityConversionFactor.get();
    }

    public void iterate(double velocity, double dt) {
        if (this.checkAndSetupSimDevice()) {
            return;
        }
        double velocityRPM = velocity / this.getVelocityConversionFactor();
        this.m_position.set(this.m_position.get() + velocityRPM / 60.0 * dt * this.getPositionConversionFactor());
    }
}

