/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.sim;

import com.revrobotics.spark.SparkBase;
import com.revrobotics.spark.SparkFlex;
import com.revrobotics.spark.SparkMax;
import edu.wpi.first.hal.SimBoolean;
import edu.wpi.first.wpilibj.simulation.SimDeviceSim;

public class SparkLimitSwitchSim {
    private SimBoolean m_isPressed;
    private SimBoolean m_isEnabled;
    private SparkBase m_spark;
    private String simDeviceName;
    private final boolean isForward;

    public SparkLimitSwitchSim(SparkMax motor, boolean forward) {
        this.simDeviceName = "SPARK MAX [" + motor.getDeviceId() + "] LIMIT SWITCH (" + (forward ? "FORWARD" : "REVERSE") + ")";
        this.setupSimDevice();
        this.m_spark = motor;
        this.isForward = forward;
    }

    public SparkLimitSwitchSim(SparkFlex motor, boolean forward) {
        this.simDeviceName = "SPARK Flex [" + motor.getDeviceId() + "] LIMIT SWITCH (" + (forward ? "FORWARD" : "REVERSE") + ")";
        this.setupSimDevice();
        this.m_spark = motor;
        this.isForward = forward;
    }

    private boolean setupSimDevice() {
        SimDeviceSim limitSwitchSim = new SimDeviceSim(this.simDeviceName);
        this.m_isPressed = limitSwitchSim.getBoolean("Is Pressed");
        this.m_isEnabled = limitSwitchSim.getBoolean("Is Enabled");
        return this.m_isPressed == null;
    }

    private boolean checkAndSetupSimDevice() {
        if (this.m_isPressed == null) {
            return this.setupSimDevice();
        }
        return false;
    }

    public void setPressed(boolean state) {
        if (this.checkAndSetupSimDevice()) {
            return;
        }
        this.m_isPressed.set(state);
    }

    public boolean getPressed() {
        if (this.checkAndSetupSimDevice()) {
            return false;
        }
        return this.m_isPressed.get();
    }

    public boolean getEnabled() {
        if (this.checkAndSetupSimDevice()) {
            return false;
        }
        return this.m_isEnabled.get();
    }
}

