/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark.config;

import com.revrobotics.config.BaseConfig;
import com.revrobotics.spark.ClosedLoopSlot;
import com.revrobotics.spark.config.SparkParameters;

public class MAXMotionConfig
extends BaseConfig {
    public MAXMotionConfig() {
        super(BaseConfig.CANType.kSpark);
    }

    public MAXMotionConfig apply(MAXMotionConfig config) {
        super.apply(config);
        return this;
    }

    @Deprecated(forRemoval=true)
    public MAXMotionConfig maxVelocity(double maxVelocity) {
        return this.maxVelocity(maxVelocity, ClosedLoopSlot.kSlot0);
    }

    public MAXMotionConfig cruiseVelocity(double cruiseVelocity) {
        return this.cruiseVelocity(cruiseVelocity, ClosedLoopSlot.kSlot0);
    }

    @Deprecated(forRemoval=true)
    public MAXMotionConfig maxVelocity(double maxVelocity, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kMAXMotionCruiseVelocity_0.value + slot.value * 5, (float)maxVelocity);
        return this;
    }

    public MAXMotionConfig cruiseVelocity(double cruiseVelocity, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kMAXMotionCruiseVelocity_0.value + slot.value * 5, (float)cruiseVelocity);
        return this;
    }

    public MAXMotionConfig maxAcceleration(double maxAcceleration) {
        return this.maxAcceleration(maxAcceleration, ClosedLoopSlot.kSlot0);
    }

    public MAXMotionConfig maxAcceleration(double maxAcceleration, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kMAXMotionMaxAccel_0.value + slot.value * 5, (float)maxAcceleration);
        return this;
    }

    @Deprecated(forRemoval=true)
    public MAXMotionConfig allowedClosedLoopError(double allowedError) {
        return this.allowedClosedLoopError(allowedError, ClosedLoopSlot.kSlot0);
    }

    public MAXMotionConfig allowedProfileError(double allowedError) {
        return this.allowedProfileError(allowedError, ClosedLoopSlot.kSlot0);
    }

    @Deprecated(forRemoval=true)
    public MAXMotionConfig allowedClosedLoopError(double allowedError, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kMAXMotionAllowedProfileError_0.value + slot.value * 5, (float)allowedError);
        return this;
    }

    public MAXMotionConfig allowedProfileError(double allowedError, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kMAXMotionAllowedProfileError_0.value + slot.value * 5, (float)allowedError);
        return this;
    }

    public MAXMotionConfig positionMode(MAXMotionPositionMode mode) {
        return this.positionMode(mode, ClosedLoopSlot.kSlot0);
    }

    public MAXMotionConfig positionMode(MAXMotionPositionMode mode, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kMAXMotionPositionMode_0.value + slot.value * 5, mode.value);
        return this;
    }

    public static enum MAXMotionPositionMode {
        kMAXMotionTrapezoidal(0);

        public final int value;

        private MAXMotionPositionMode(int value) {
            this.value = value;
        }

        public static MAXMotionPositionMode fromInt(int value) {
            switch (value) {
                case 0: {
                    return kMAXMotionTrapezoidal;
                }
            }
            return kMAXMotionTrapezoidal;
        }
    }
}

