/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.index;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class CandidateComponentsIndex {
    private static final AntPathMatcher pathMatcher = new AntPathMatcher(".");
    private final Set<String> registeredScans = new LinkedHashSet<String>();
    private final MultiValueMap<String, Entry> index = new LinkedMultiValueMap();
    private final boolean complete;

    CandidateComponentsIndex(List<Properties> content) {
        for (Properties entry : content) {
            entry.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(type, values) -> {
                String[] stereotypes;
                for (String stereotype : stereotypes = ((String)values).split(",")) {
                    this.index.add((Object)stereotype, (Object)new Entry((String)type));
                }
            }));
        }
        this.complete = true;
    }

    public CandidateComponentsIndex() {
        this.complete = false;
    }

    public void registerScan(String ... basePackages) {
        Collections.addAll(this.registeredScans, basePackages);
    }

    public Set<String> getRegisteredScans() {
        return this.registeredScans;
    }

    public boolean hasScannedPackage(String packageName) {
        return this.complete || this.registeredScans.stream().anyMatch(basePackage -> CandidateComponentsIndex.matchPackage(basePackage, packageName));
    }

    public void registerCandidateType(String type, String ... stereotypes) {
        for (String stereotype : stereotypes) {
            this.index.add((Object)stereotype, (Object)new Entry(type));
        }
    }

    public Set<String> getRegisteredStereotypes() {
        return this.index.keySet();
    }

    public Set<String> getCandidateTypes(String basePackage, String stereotype) {
        List candidates = (List)this.index.get((Object)stereotype);
        if (candidates != null) {
            return candidates.stream().filter(entry -> entry.match(basePackage)).map(entry -> entry.type).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static boolean matchPackage(String basePackage, String packageName) {
        if (pathMatcher.isPattern(basePackage)) {
            return pathMatcher.match(basePackage, packageName);
        }
        return packageName.equals(basePackage) || packageName.startsWith(basePackage + ".");
    }

    private static class Entry {
        final String type;
        private final String packageName;

        Entry(String type) {
            this.type = type;
            this.packageName = ClassUtils.getPackageName((String)type);
        }

        public boolean match(String basePackage) {
            return CandidateComponentsIndex.matchPackage(basePackage, this.packageName);
        }
    }
}

