/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.AbstractMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;

public class CachingMetadataReaderFactory
extends AbstractMetadataReaderFactory {
    public static final int DEFAULT_CACHE_LIMIT = 256;
    private final MetadataReaderFactory delegate;
    private @Nullable Map<Resource, MetadataReader> metadataReaderCache;

    public CachingMetadataReaderFactory() {
        this(MetadataReaderFactory.create((ClassLoader)null));
    }

    public CachingMetadataReaderFactory(@Nullable ClassLoader classLoader) {
        this(MetadataReaderFactory.create(classLoader));
    }

    public CachingMetadataReaderFactory(@Nullable ResourceLoader resourceLoader) {
        this(MetadataReaderFactory.create(resourceLoader));
    }

    CachingMetadataReaderFactory(MetadataReaderFactory delegate) {
        super(delegate.getResourceLoader());
        this.delegate = delegate;
        ResourceLoader resourceLoader = this.getResourceLoader();
        if (resourceLoader instanceof DefaultResourceLoader) {
            DefaultResourceLoader defaultResourceLoader = (DefaultResourceLoader)resourceLoader;
            this.metadataReaderCache = defaultResourceLoader.getResourceCache(MetadataReader.class);
        } else {
            this.setCacheLimit(256);
        }
    }

    public void setCacheLimit(int cacheLimit) {
        if (cacheLimit <= 0) {
            this.metadataReaderCache = null;
        } else {
            Map<Resource, MetadataReader> map = this.metadataReaderCache;
            if (map instanceof LocalResourceCache) {
                LocalResourceCache localResourceCache = (LocalResourceCache)map;
                localResourceCache.setCacheLimit(cacheLimit);
            } else {
                this.metadataReaderCache = new LocalResourceCache(cacheLimit);
            }
        }
    }

    public int getCacheLimit() {
        Map<Resource, MetadataReader> map = this.metadataReaderCache;
        if (map instanceof LocalResourceCache) {
            LocalResourceCache localResourceCache = (LocalResourceCache)map;
            return localResourceCache.getCacheLimit();
        }
        return this.metadataReaderCache != null ? Integer.MAX_VALUE : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetadataReader getMetadataReader(Resource resource) throws IOException {
        if (this.metadataReaderCache instanceof ConcurrentMap) {
            MetadataReader metadataReader = this.metadataReaderCache.get(resource);
            if (metadataReader == null) {
                metadataReader = this.delegate.getMetadataReader(resource);
                this.metadataReaderCache.put(resource, metadataReader);
            }
            return metadataReader;
        }
        if (this.metadataReaderCache != null) {
            Map<Resource, MetadataReader> map = this.metadataReaderCache;
            synchronized (map) {
                MetadataReader metadataReader = this.metadataReaderCache.get(resource);
                if (metadataReader == null) {
                    metadataReader = this.delegate.getMetadataReader(resource);
                    this.metadataReaderCache.put(resource, metadataReader);
                }
                return metadataReader;
            }
        }
        return this.delegate.getMetadataReader(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.metadataReaderCache instanceof LocalResourceCache) {
            Map<Resource, MetadataReader> map = this.metadataReaderCache;
            synchronized (map) {
                this.metadataReaderCache.clear();
            }
        } else if (this.metadataReaderCache != null) {
            this.setCacheLimit(256);
        }
    }

    private static class LocalResourceCache
    extends LinkedHashMap<Resource, MetadataReader> {
        private volatile int cacheLimit;

        public LocalResourceCache(int cacheLimit) {
            super(cacheLimit, 0.75f, true);
            this.cacheLimit = cacheLimit;
        }

        public void setCacheLimit(int cacheLimit) {
            this.cacheLimit = cacheLimit;
        }

        public int getCacheLimit() {
            return this.cacheLimit;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Resource, MetadataReader> eldest) {
            return this.size() > this.cacheLimit;
        }
    }
}

