/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics;

public class ServoHubCanSpec {
    public static final int BOOTLOADER_0_FRAME_ID = 201699328;
    public static final int STATUS_0_FRAME_ID = 201701376;
    public static final int STATUS_1_FRAME_ID = 201701440;
    public static final int STATUS_2_FRAME_ID = 201701504;
    public static final int STATUS_3_FRAME_ID = 201701568;
    public static final int STATUS_4_FRAME_ID = 201701632;
    public static final int SET_SERVO_0_TO_2_PULSE_WIDTHS_FRAME_ID = 0xC050000;
    public static final int SET_SERVO_3_TO_5_PULSE_WIDTHS_FRAME_ID = 201654336;
    public static final int SET_BANKS_PULSE_PERIOD_FRAME_ID = 201654400;
    public static final int RESET_CONFIGURATION_FRAME_ID = 201654528;
    public static final int SET_SERVO_MIN_PULSE_WIDTH_FRAME_ID = 201654592;
    public static final int SET_SERVO_CENTER_PULSE_WIDTH_FRAME_ID = 201654656;
    public static final int SET_SERVO_MAX_PULSE_WIDTH_FRAME_ID = 201654720;
    public static final int GET_PULSE_RANGE_FRAME_ID = 201654784;
    public static final int SET_DISABLE_BEHAVIOR_FRAME_ID = 201654848;
    public static final int GET_DISABLE_BEHAVIOR_FRAME_ID = 201654912;
    public static final int CLEAR_FAULTS_FRAME_ID = 201661312;
    public static final int IDENTIFY_FRAME_ID = 201661824;
    public static final int GET_VERSION_FRAME_ID = 201664000;
    public static final int USB_CHECK_FRAME_ID = 201665728;
    public static final int GET_HARDWARE_FAULTS_FRAME_ID = 201671232;
    public static final int SET_BANKS_PULSE_PERIOD_RESPONSE_FRAME_ID = 201674880;
    public static final int RESET_CONFIGURATION_RESPONSE_FRAME_ID = 201675008;
    public static final int SET_SERVO_MIN_PULSE_RESPONSE_FRAME_ID = 201675072;
    public static final int SET_SERVO_CENTER_PULSE_RESPONSE_FRAME_ID = 201675136;
    public static final int SET_SERVO_MAX_PULSE_RESPONSE_FRAME_ID = 201675200;
    public static final int GET_PULSE_RANGE_RESPONSE_FRAME_ID = 201675264;
    public static final int SET_DISABLE_BEHAVIOR_RESPONSE_FRAME_ID = 201675328;
    public static final int SRS_ENABLE_PROGRAMMING_MODE_FRAME_ID = 201677952;
    public static final int SRS_SET_SERVO_LIMITS_FRAME_ID = 0xC055CC0;
    public static final int SRS_SET_SERVO_DRIVE_MODE_FRAME_ID = 201678080;
    public static final int SRS_PROGRAMMING_MODE_RESPONSE_FRAME_ID = 201680000;
    public static final int SRS_SET_LIMITS_RESPONSE_FRAME_ID = 201680064;
    public static final int SRS_SET_DRIVE_MODE_RESPONSE_FRAME_ID = 201680128;
    public static final int CLEAR_FAULTS_RESPONSE_FRAME_ID = 201681792;
    public static final int SET_CAN_ID_FRAME_ID = 201686912;
    public static final int BOOTLOADER_0_LENGTH = 8;
    public static final int STATUS_0_LENGTH = 5;
    public static final int STATUS_1_LENGTH = 8;
    public static final int STATUS_2_LENGTH = 7;
    public static final int STATUS_3_LENGTH = 7;
    public static final int STATUS_4_LENGTH = 8;
    public static final int SET_SERVO_0_TO_2_PULSE_WIDTHS_LENGTH = 7;
    public static final int SET_SERVO_3_TO_5_PULSE_WIDTHS_LENGTH = 7;
    public static final int SET_BANKS_PULSE_PERIOD_LENGTH = 3;
    public static final int RESET_CONFIGURATION_LENGTH = 2;
    public static final int SET_SERVO_MIN_PULSE_WIDTH_LENGTH = 3;
    public static final int SET_SERVO_CENTER_PULSE_WIDTH_LENGTH = 3;
    public static final int SET_SERVO_MAX_PULSE_WIDTH_LENGTH = 3;
    public static final int GET_PULSE_RANGE_LENGTH = 1;
    public static final int SET_DISABLE_BEHAVIOR_LENGTH = 2;
    public static final int GET_DISABLE_BEHAVIOR_LENGTH = 8;
    public static final int CLEAR_FAULTS_LENGTH = 0;
    public static final int IDENTIFY_LENGTH = 0;
    public static final int GET_VERSION_LENGTH = 8;
    public static final int USB_CHECK_LENGTH = 0;
    public static final int GET_HARDWARE_FAULTS_LENGTH = 8;
    public static final int SET_BANKS_PULSE_PERIOD_RESPONSE_LENGTH = 4;
    public static final int RESET_CONFIGURATION_RESPONSE_LENGTH = 2;
    public static final int SET_SERVO_MIN_PULSE_RESPONSE_LENGTH = 4;
    public static final int SET_SERVO_CENTER_PULSE_RESPONSE_LENGTH = 4;
    public static final int SET_SERVO_MAX_PULSE_RESPONSE_LENGTH = 4;
    public static final int GET_PULSE_RANGE_RESPONSE_LENGTH = 6;
    public static final int SET_DISABLE_BEHAVIOR_RESPONSE_LENGTH = 3;
    public static final int SRS_ENABLE_PROGRAMMING_MODE_LENGTH = 1;
    public static final int SRS_SET_SERVO_LIMITS_LENGTH = 5;
    public static final int SRS_SET_SERVO_DRIVE_MODE_LENGTH = 2;
    public static final int SRS_PROGRAMMING_MODE_RESPONSE_LENGTH = 1;
    public static final int SRS_SET_LIMITS_RESPONSE_LENGTH = 2;
    public static final int SRS_SET_DRIVE_MODE_RESPONSE_LENGTH = 2;
    public static final int CLEAR_FAULTS_RESPONSE_LENGTH = 0;
    public static final int SET_CAN_ID_LENGTH = 1;

    private static int packLeftShift(int value, int shift, int mask) {
        return value << shift & mask & 0xFF;
    }

    private static int packRightShift(int value, int shift, int mask) {
        return value >> shift & mask & 0xFF;
    }

    private static int unpackLeftShift8(int value, int shift, int mask) {
        return (value & mask) << shift & 0xFF;
    }

    private static int unpackLeftShift16(int value, int shift, int mask) {
        return (value & mask) << shift & 0xFFFF;
    }

    private static int unpackLeftShift32(int value, int shift, int mask) {
        return (value & mask) << shift & 0xFFFFFFFF;
    }

    private static int unpackRightShift8(int value, int shift, int mask) {
        return (value & mask) >> shift & 0xFF;
    }

    private static int unpackRightShift16(int value, int shift, int mask) {
        return (value & mask) >> shift & 0xFFFF;
    }

    private static int unpackRightShift32(int value, int shift, int mask) {
        return (value & mask) >> shift & 0xFFFFFFFF;
    }

    public static Bootloader0 bootloader0Unpack(byte[] data) {
        int bLMajor = ServoHubCanSpec.unpackIntBits(data, 0, 8);
        int bLMinor = ServoHubCanSpec.unpackIntBits(data, 8, 8);
        int productID = ServoHubCanSpec.unpackIntBits(data, 16, 16);
        int rsvd = ServoHubCanSpec.unpackIntBits(data, 32, 32);
        return new Bootloader0(bLMajor, bLMinor, productID, rsvd);
    }

    public static Status0 status0Unpack(byte[] data) {
        int voltage = ServoHubCanSpec.unpackIntBits(data, 0, 10);
        int servoVoltage = ServoHubCanSpec.unpackIntBits(data, 10, 10);
        int deviceCurrent = ServoHubCanSpec.unpackIntBits(data, 20, 10);
        boolean primaryHeartbeatLock = (data[3] & 0x40) != 0;
        boolean systemEnabled = (data[3] & 0x80) != 0;
        int communicationMode = ServoHubCanSpec.unpackIntBits(data, 32, 3);
        boolean programmingModeEnabled = (data[4] & 8) != 0;
        boolean servoProgrammingActive = (data[4] & 0x10) != 0;
        int reserved = ServoHubCanSpec.unpackIntBits(data, 37, 3);
        return new Status0(voltage, servoVoltage, deviceCurrent, primaryHeartbeatLock, systemEnabled, communicationMode, programmingModeEnabled, servoProgrammingActive, reserved);
    }

    public static Status1 status1Unpack(byte[] data) {
        boolean regulatorPGoodFault = (data[0] & 1) != 0;
        boolean brownout = (data[0] & 2) != 0;
        boolean cANWarning = (data[0] & 4) != 0;
        boolean cANBusOff = (data[0] & 8) != 0;
        boolean hardwareFault = (data[0] & 0x10) != 0;
        boolean firmwareFault = (data[0] & 0x20) != 0;
        boolean hasReset = (data[0] & 0x40) != 0;
        boolean channel0Overcurrent = (data[0] & 0x80) != 0;
        boolean channel1Overcurrent = (data[1] & 1) != 0;
        boolean channel2Overcurrent = (data[1] & 2) != 0;
        boolean channel3Overcurrent = (data[1] & 4) != 0;
        boolean channel4Overcurrent = (data[1] & 8) != 0;
        boolean channel5Overcurrent = (data[1] & 0x10) != 0;
        boolean lowBatteryFault = (data[1] & 0x20) != 0;
        int reserved = ServoHubCanSpec.unpackIntBits(data, 14, 18);
        boolean stickyRegulatorPGoodFault = (data[4] & 1) != 0;
        boolean stickyBrownout = (data[4] & 2) != 0;
        boolean stickyCANWarning = (data[4] & 4) != 0;
        boolean stickyCANBusOff = (data[4] & 8) != 0;
        boolean stickyHardwareFault = (data[4] & 0x10) != 0;
        boolean stickyFirmwareFault = (data[4] & 0x20) != 0;
        boolean stickyHasReset = (data[4] & 0x40) != 0;
        boolean stickyChannel0Overcurrent = (data[4] & 0x80) != 0;
        boolean stickyChannel1Overcurrent = (data[5] & 1) != 0;
        boolean stickyChannel2Overcurrent = (data[5] & 2) != 0;
        boolean stickyChannel3Overcurrent = (data[5] & 4) != 0;
        boolean stickyChannel4Overcurrent = (data[5] & 8) != 0;
        boolean stickyChannel5Overcurrent = (data[5] & 0x10) != 0;
        boolean stickyLowBatteryFault = (data[5] & 0x20) != 0;
        int reserved2 = ServoHubCanSpec.unpackIntBits(data, 46, 18);
        return new Status1(regulatorPGoodFault, brownout, cANWarning, cANBusOff, hardwareFault, firmwareFault, hasReset, channel0Overcurrent, channel1Overcurrent, channel2Overcurrent, channel3Overcurrent, channel4Overcurrent, channel5Overcurrent, lowBatteryFault, reserved, stickyRegulatorPGoodFault, stickyBrownout, stickyCANWarning, stickyCANBusOff, stickyHardwareFault, stickyFirmwareFault, stickyHasReset, stickyChannel0Overcurrent, stickyChannel1Overcurrent, stickyChannel2Overcurrent, stickyChannel3Overcurrent, stickyChannel4Overcurrent, stickyChannel5Overcurrent, stickyLowBatteryFault, reserved2);
    }

    public static Status2 status2Unpack(byte[] data) {
        int channel0PulseWidth = ServoHubCanSpec.unpackIntBits(data, 0, 16);
        int channel1PulseWidth = ServoHubCanSpec.unpackIntBits(data, 16, 16);
        int channel2PulseWidth = ServoHubCanSpec.unpackIntBits(data, 32, 16);
        boolean channel0Enabled = (data[6] & 1) != 0;
        boolean channel1Enabled = (data[6] & 2) != 0;
        boolean channel2Enabled = (data[6] & 4) != 0;
        boolean channel0OutOfRange = (data[6] & 8) != 0;
        boolean channel1OutOfRange = (data[6] & 0x10) != 0;
        boolean channel2OutOfRange = (data[6] & 0x20) != 0;
        int reserved = ServoHubCanSpec.unpackIntBits(data, 54, 2);
        return new Status2(channel0PulseWidth, channel1PulseWidth, channel2PulseWidth, channel0Enabled, channel1Enabled, channel2Enabled, channel0OutOfRange, channel1OutOfRange, channel2OutOfRange, reserved);
    }

    public static Status3 status3Unpack(byte[] data) {
        int channel3PulseWidth = ServoHubCanSpec.unpackIntBits(data, 0, 16);
        int channel4PulseWidth = ServoHubCanSpec.unpackIntBits(data, 16, 16);
        int channel5PulseWidth = ServoHubCanSpec.unpackIntBits(data, 32, 16);
        boolean channel3Enabled = (data[6] & 1) != 0;
        boolean channel4Enabled = (data[6] & 2) != 0;
        boolean channel5Enabled = (data[6] & 4) != 0;
        boolean channel3OutOfRange = (data[6] & 8) != 0;
        boolean channel4OutOfRange = (data[6] & 0x10) != 0;
        boolean channel5OutOfRange = (data[6] & 0x20) != 0;
        int reserved = ServoHubCanSpec.unpackIntBits(data, 54, 2);
        return new Status3(channel3PulseWidth, channel4PulseWidth, channel5PulseWidth, channel3Enabled, channel4Enabled, channel5Enabled, channel3OutOfRange, channel4OutOfRange, channel5OutOfRange, reserved);
    }

    public static Status4 status4Unpack(byte[] data) {
        int channel0Current = ServoHubCanSpec.unpackIntBits(data, 0, 10);
        int channel1Current = ServoHubCanSpec.unpackIntBits(data, 10, 10);
        int channel2Current = ServoHubCanSpec.unpackIntBits(data, 20, 10);
        int channel3Current = ServoHubCanSpec.unpackIntBits(data, 30, 10);
        int channel4Current = ServoHubCanSpec.unpackIntBits(data, 40, 10);
        int channel5Current = ServoHubCanSpec.unpackIntBits(data, 50, 10);
        int reserved = ServoHubCanSpec.unpackIntBits(data, 60, 4);
        return new Status4(channel0Current, channel1Current, channel2Current, channel3Current, channel4Current, channel5Current, reserved);
    }

    public static SetServo0to2PulseWidths setServo0To2PulseWidthsUnpack(byte[] data) {
        int pulseWidth0 = ServoHubCanSpec.unpackIntBits(data, 0, 16);
        int pulseWidth1 = ServoHubCanSpec.unpackIntBits(data, 16, 16);
        int pulseWidth2 = ServoHubCanSpec.unpackIntBits(data, 32, 16);
        boolean enableChannel0 = (data[6] & 1) != 0;
        boolean enableChannel1 = (data[6] & 2) != 0;
        boolean enableChannel2 = (data[6] & 4) != 0;
        boolean powerChannel0 = (data[6] & 8) != 0;
        boolean powerChannel1 = (data[6] & 0x10) != 0;
        boolean powerChannel2 = (data[6] & 0x20) != 0;
        int reserved = ServoHubCanSpec.unpackIntBits(data, 54, 2);
        return new SetServo0to2PulseWidths(pulseWidth0, pulseWidth1, pulseWidth2, enableChannel0, enableChannel1, enableChannel2, powerChannel0, powerChannel1, powerChannel2, reserved);
    }

    public static SetServo3to5PulseWidths setServo3To5PulseWidthsUnpack(byte[] data) {
        int pulseWidth3 = ServoHubCanSpec.unpackIntBits(data, 0, 16);
        int pulseWidth4 = ServoHubCanSpec.unpackIntBits(data, 16, 16);
        int pulseWidth5 = ServoHubCanSpec.unpackIntBits(data, 32, 16);
        boolean enableChannel3 = (data[6] & 1) != 0;
        boolean enableChannel4 = (data[6] & 2) != 0;
        boolean enableChannel5 = (data[6] & 4) != 0;
        boolean powerChannel3 = (data[6] & 8) != 0;
        boolean powerChannel4 = (data[6] & 0x10) != 0;
        boolean powerChannel5 = (data[6] & 0x20) != 0;
        int reserved = ServoHubCanSpec.unpackIntBits(data, 54, 2);
        return new SetServo3to5PulseWidths(pulseWidth3, pulseWidth4, pulseWidth5, enableChannel3, enableChannel4, enableChannel5, powerChannel3, powerChannel4, powerChannel5, reserved);
    }

    public static SetBanksPulsePeriod setBanksPulsePeriodUnpack(byte[] data) {
        int channelBanksBitfield = ServoHubCanSpec.unpackIntBits(data, 0, 2);
        int reserved = ServoHubCanSpec.unpackIntBits(data, 2, 6);
        int pulsePeriod = ServoHubCanSpec.unpackIntBits(data, 8, 16);
        return new SetBanksPulsePeriod(channelBanksBitfield, reserved, pulsePeriod);
    }

    public static ResetConfiguration resetConfigurationUnpack(byte[] data) {
        int magic = ServoHubCanSpec.unpackIntBits(data, 0, 16);
        return new ResetConfiguration(magic);
    }

    public static SetServoMinPulseWidth setServoMinPulseWidthUnpack(byte[] data) {
        int channel = ServoHubCanSpec.unpackIntBits(data, 0, 8);
        int pulseUs = ServoHubCanSpec.unpackIntBits(data, 8, 16);
        return new SetServoMinPulseWidth(channel, pulseUs);
    }

    public static SetServoCenterPulseWidth setServoCenterPulseWidthUnpack(byte[] data) {
        int channel = ServoHubCanSpec.unpackIntBits(data, 0, 8);
        int pulseUs = ServoHubCanSpec.unpackIntBits(data, 8, 16);
        return new SetServoCenterPulseWidth(channel, pulseUs);
    }

    public static SetServoMaxPulseWidth setServoMaxPulseWidthUnpack(byte[] data) {
        int channel = ServoHubCanSpec.unpackIntBits(data, 0, 8);
        int pulseUs = ServoHubCanSpec.unpackIntBits(data, 8, 16);
        return new SetServoMaxPulseWidth(channel, pulseUs);
    }

    public static GetPulseRange getPulseRangeUnpack(byte[] data) {
        int channel = ServoHubCanSpec.unpackIntBits(data, 0, 8);
        return new GetPulseRange(channel);
    }

    public static SetDisableBehavior setDisableBehaviorUnpack(byte[] data) {
        int mask = ServoHubCanSpec.unpackIntBits(data, 0, 6);
        int behaviorBitfield = ServoHubCanSpec.unpackIntBits(data, 6, 6);
        int reserved = ServoHubCanSpec.unpackIntBits(data, 12, 4);
        return new SetDisableBehavior(mask, behaviorBitfield, reserved);
    }

    public static GetDisableBehavior getDisableBehaviorUnpack(byte[] data) {
        int behaviorBitfield = ServoHubCanSpec.unpackIntBits(data, 0, 6);
        long reserved = ServoHubCanSpec.unpackLongBits(data, 6, 58);
        return new GetDisableBehavior(behaviorBitfield, reserved);
    }

    public static ClearFaults clearFaultsUnpack(byte[] data) {
        return new ClearFaults();
    }

    public static Identify identifyUnpack(byte[] data) {
        return new Identify();
    }

    public static GetVersion getVersionUnpack(byte[] data) {
        int firmwareFix = ServoHubCanSpec.unpackIntBits(data, 0, 8);
        int firmwareMinor = ServoHubCanSpec.unpackIntBits(data, 8, 8);
        int firmwareYear = ServoHubCanSpec.unpackIntBits(data, 16, 8);
        int hardwareMinor = ServoHubCanSpec.unpackIntBits(data, 24, 8);
        int hardwareMajor = ServoHubCanSpec.unpackIntBits(data, 32, 8);
        int reserved = ServoHubCanSpec.unpackIntBits(data, 40, 24);
        return new GetVersion(firmwareFix, firmwareMinor, firmwareYear, hardwareMinor, hardwareMajor, reserved);
    }

    public static USBCheck uSBCheckUnpack(byte[] data) {
        return new USBCheck();
    }

    public static GetHardwareFaults getHardwareFaultsUnpack(byte[] data) {
        boolean aDCInit = (data[0] & 1) != 0;
        boolean cRCInit = (data[0] & 2) != 0;
        boolean dACInit = (data[0] & 4) != 0;
        boolean fDCANInit = (data[0] & 8) != 0;
        boolean i2CInit = (data[0] & 0x10) != 0;
        boolean sYSClockInit = (data[0] & 0x20) != 0;
        boolean sPIInit = (data[0] & 0x40) != 0;
        boolean tIMInit = (data[0] & 0x80) != 0;
        boolean uSARTInit = (data[1] & 1) != 0;
        boolean cSA1Init = (data[1] & 2) != 0;
        boolean cSA1Read = (data[1] & 4) != 0;
        boolean cSA1Invalid = (data[1] & 8) != 0;
        boolean cSA2Init = (data[1] & 0x10) != 0;
        boolean cSA2Read = (data[1] & 0x20) != 0;
        boolean cSA2Invalid = (data[1] & 0x40) != 0;
        boolean fRCCANInit = (data[1] & 0x80) != 0;
        boolean cANTx = (data[2] & 1) != 0;
        boolean cANRx = (data[2] & 2) != 0;
        boolean cANSetID = (data[2] & 4) != 0;
        boolean eEPROMRead = (data[2] & 8) != 0;
        boolean eEPROMWrite = (data[2] & 0x10) != 0;
        long reserved = ServoHubCanSpec.unpackLongBits(data, 21, 43);
        return new GetHardwareFaults(aDCInit, cRCInit, dACInit, fDCANInit, i2CInit, sYSClockInit, sPIInit, tIMInit, uSARTInit, cSA1Init, cSA1Read, cSA1Invalid, cSA2Init, cSA2Read, cSA2Invalid, fRCCANInit, cANTx, cANRx, cANSetID, eEPROMRead, eEPROMWrite, reserved);
    }

    public static SetBanksPulsePeriodResponse setBanksPulsePeriodResponseUnpack(byte[] data) {
        int channelBanksBitfield = ServoHubCanSpec.unpackIntBits(data, 0, 2);
        int reserved = ServoHubCanSpec.unpackIntBits(data, 2, 6);
        int pulsePeriod = ServoHubCanSpec.unpackIntBits(data, 8, 16);
        int result = ServoHubCanSpec.unpackIntBits(data, 24, 8);
        return new SetBanksPulsePeriodResponse(channelBanksBitfield, reserved, pulsePeriod, result);
    }

    public static ResetConfigurationResponse resetConfigurationResponseUnpack(byte[] data) {
        int magic = ServoHubCanSpec.unpackIntBits(data, 0, 16);
        return new ResetConfigurationResponse(magic);
    }

    public static SetServoMinPulseResponse setServoMinPulseResponseUnpack(byte[] data) {
        int channel = ServoHubCanSpec.unpackIntBits(data, 0, 8);
        int pulseUs = ServoHubCanSpec.unpackIntBits(data, 8, 16);
        int result = ServoHubCanSpec.unpackIntBits(data, 24, 8);
        return new SetServoMinPulseResponse(channel, pulseUs, result);
    }

    public static SetServoCenterPulseResponse setServoCenterPulseResponseUnpack(byte[] data) {
        int channel = ServoHubCanSpec.unpackIntBits(data, 0, 8);
        int pulseUs = ServoHubCanSpec.unpackIntBits(data, 8, 16);
        int result = ServoHubCanSpec.unpackIntBits(data, 24, 8);
        return new SetServoCenterPulseResponse(channel, pulseUs, result);
    }

    public static SetServoMaxPulseResponse setServoMaxPulseResponseUnpack(byte[] data) {
        int channel = ServoHubCanSpec.unpackIntBits(data, 0, 8);
        int pulseUs = ServoHubCanSpec.unpackIntBits(data, 8, 16);
        int result = ServoHubCanSpec.unpackIntBits(data, 24, 8);
        return new SetServoMaxPulseResponse(channel, pulseUs, result);
    }

    public static GetPulseRangeResponse getPulseRangeResponseUnpack(byte[] data) {
        int minPulseUs = ServoHubCanSpec.unpackIntBits(data, 0, 16);
        int centerPulseUs = ServoHubCanSpec.unpackIntBits(data, 16, 16);
        int maxPulseUs = ServoHubCanSpec.unpackIntBits(data, 32, 16);
        return new GetPulseRangeResponse(minPulseUs, centerPulseUs, maxPulseUs);
    }

    public static SetDisableBehaviorResponse setDisableBehaviorResponseUnpack(byte[] data) {
        int result = ServoHubCanSpec.unpackIntBits(data, 0, 8);
        int mask = ServoHubCanSpec.unpackIntBits(data, 8, 6);
        int behaviorBitfield = ServoHubCanSpec.unpackIntBits(data, 14, 6);
        int reserved = ServoHubCanSpec.unpackIntBits(data, 20, 4);
        return new SetDisableBehaviorResponse(result, mask, behaviorBitfield, reserved);
    }

    public static SRSEnableProgrammingMode sRSEnableProgrammingModeUnpack(byte[] data) {
        boolean channel0Enabled = (data[0] & 1) != 0;
        boolean channel1Enabled = (data[0] & 2) != 0;
        boolean channel2Enabled = (data[0] & 4) != 0;
        boolean channel3Enabled = (data[0] & 8) != 0;
        boolean channel4Enabled = (data[0] & 0x10) != 0;
        boolean channel5Enabled = (data[0] & 0x20) != 0;
        int reserved = ServoHubCanSpec.unpackIntBits(data, 6, 2);
        return new SRSEnableProgrammingMode(channel0Enabled, channel1Enabled, channel2Enabled, channel3Enabled, channel4Enabled, channel5Enabled, reserved);
    }

    public static SRSSetServoLimits sRSSetServoLimitsUnpack(byte[] data) {
        int channel = ServoHubCanSpec.unpackIntBits(data, 0, 8);
        int leftLimit = ServoHubCanSpec.unpackIntBits(data, 8, 16);
        int rightLimit = ServoHubCanSpec.unpackIntBits(data, 24, 16);
        return new SRSSetServoLimits(channel, leftLimit, rightLimit);
    }

    public static SRSSetServoDriveMode sRSSetServoDriveModeUnpack(byte[] data) {
        int channel = ServoHubCanSpec.unpackIntBits(data, 0, 8);
        int mode = ServoHubCanSpec.unpackIntBits(data, 8, 8);
        return new SRSSetServoDriveMode(channel, mode);
    }

    public static SRSProgrammingModeResponse sRSProgrammingModeResponseUnpack(byte[] data) {
        int result = ServoHubCanSpec.unpackIntBits(data, 0, 8);
        return new SRSProgrammingModeResponse(result);
    }

    public static SRSSetLimitsResponse sRSSetLimitsResponseUnpack(byte[] data) {
        int channel = ServoHubCanSpec.unpackIntBits(data, 0, 8);
        int result = ServoHubCanSpec.unpackIntBits(data, 8, 8);
        return new SRSSetLimitsResponse(channel, result);
    }

    public static SRSSetDriveModeResponse sRSSetDriveModeResponseUnpack(byte[] data) {
        int channel = ServoHubCanSpec.unpackIntBits(data, 0, 8);
        int result = ServoHubCanSpec.unpackIntBits(data, 8, 8);
        return new SRSSetDriveModeResponse(channel, result);
    }

    public static ClearFaultsResponse clearFaultsResponseUnpack(byte[] data) {
        return new ClearFaultsResponse();
    }

    public static SetCANID setCANIDUnpack(byte[] data) {
        int id = ServoHubCanSpec.unpackIntBits(data, 0, 8);
        return new SetCANID(id);
    }

    private static int unpackIntBits(byte[] data, int startBit, int length) {
        int result = 0;
        int currentByte = startBit / 8;
        int bitWithinByte = startBit % 8;
        for (int i = 0; i < length; ++i) {
            byte b = data[currentByte];
            int thisBit = (b & 1 << bitWithinByte) != 0 ? 1 : 0;
            result |= thisBit << i;
            if (++bitWithinByte != 8) continue;
            bitWithinByte = 0;
            ++currentByte;
        }
        return result;
    }

    private static long unpackLongBits(byte[] data, int startBit, int length) {
        long result = 0L;
        int currentByte = startBit / 8;
        int bitWithinByte = startBit % 8;
        for (int i = 0; i < length; ++i) {
            byte b = data[currentByte];
            long thisBit = (b & 1 << bitWithinByte) != 0 ? 1L : 0L;
            result |= thisBit << i;
            if (++bitWithinByte != 8) continue;
            bitWithinByte = 0;
            ++currentByte;
        }
        return result;
    }

    public static double bootloader0BLMajorDecode(int value) {
        return value * 1;
    }

    public static double bootloader0BLMinorDecode(int value) {
        return value * 1;
    }

    public static double bootloader0ProductIDDecode(int value) {
        return value * 1;
    }

    public static double bootloader0RsvdDecode(int value) {
        return value * 1;
    }

    public static double status0VoltageDecode(int value) {
        return (double)value * 0.025;
    }

    public static double status0ServoVoltageDecode(int value) {
        return (double)value * 0.025;
    }

    public static double status0DeviceCurrentDecode(int value) {
        return (double)value * 0.02;
    }

    public static double status0CommunicationModeDecode(int value) {
        return value * 1;
    }

    public static double status0ReservedDecode(int value) {
        return value * 1;
    }

    public static double status1ReservedDecode(int value) {
        return value * 1;
    }

    public static double status1Reserved2Decode(int value) {
        return value * 1;
    }

    public static double status2Channel0PulseWidthDecode(int value) {
        return value * 1;
    }

    public static double status2Channel1PulseWidthDecode(int value) {
        return value * 1;
    }

    public static double status2Channel2PulseWidthDecode(int value) {
        return value * 1;
    }

    public static double status2ReservedDecode(int value) {
        return value * 1;
    }

    public static double status3Channel3PulseWidthDecode(int value) {
        return value * 1;
    }

    public static double status3Channel4PulseWidthDecode(int value) {
        return value * 1;
    }

    public static double status3Channel5PulseWidthDecode(int value) {
        return value * 1;
    }

    public static double status3ReservedDecode(int value) {
        return value * 1;
    }

    public static double status4Channel0CurrentDecode(int value) {
        return (double)value * 0.01;
    }

    public static double status4Channel1CurrentDecode(int value) {
        return (double)value * 0.01;
    }

    public static double status4Channel2CurrentDecode(int value) {
        return (double)value * 0.01;
    }

    public static double status4Channel3CurrentDecode(int value) {
        return (double)value * 0.01;
    }

    public static double status4Channel4CurrentDecode(int value) {
        return (double)value * 0.01;
    }

    public static double status4Channel5CurrentDecode(int value) {
        return (double)value * 0.01;
    }

    public static double status4ReservedDecode(int value) {
        return value * 1;
    }

    public static double setServo0To2PulseWidthsPulseWidth0Decode(int value) {
        return value * 1;
    }

    public static double setServo0To2PulseWidthsPulseWidth1Decode(int value) {
        return value * 1;
    }

    public static double setServo0To2PulseWidthsPulseWidth2Decode(int value) {
        return value * 1;
    }

    public static double setServo0To2PulseWidthsReservedDecode(int value) {
        return value * 1;
    }

    public static double setServo3To5PulseWidthsPulseWidth3Decode(int value) {
        return value * 1;
    }

    public static double setServo3To5PulseWidthsPulseWidth4Decode(int value) {
        return value * 1;
    }

    public static double setServo3To5PulseWidthsPulseWidth5Decode(int value) {
        return value * 1;
    }

    public static double setServo3To5PulseWidthsReservedDecode(int value) {
        return value * 1;
    }

    public static double setBanksPulsePeriodChannelBanksBitfieldDecode(int value) {
        return value * 1;
    }

    public static double setBanksPulsePeriodReservedDecode(int value) {
        return value * 1;
    }

    public static double setBanksPulsePeriodPulsePeriodDecode(int value) {
        return value * 1;
    }

    public static double resetConfigurationMagicDecode(int value) {
        return value * 1;
    }

    public static double setServoMinPulseWidthChannelDecode(int value) {
        return value * 1;
    }

    public static double setServoMinPulseWidthPulseUsDecode(int value) {
        return value * 1;
    }

    public static double setServoCenterPulseWidthChannelDecode(int value) {
        return value * 1;
    }

    public static double setServoCenterPulseWidthPulseUsDecode(int value) {
        return value * 1;
    }

    public static double setServoMaxPulseWidthChannelDecode(int value) {
        return value * 1;
    }

    public static double setServoMaxPulseWidthPulseUsDecode(int value) {
        return value * 1;
    }

    public static double getPulseRangeChannelDecode(int value) {
        return value * 1;
    }

    public static double setDisableBehaviorMaskDecode(int value) {
        return value * 1;
    }

    public static double setDisableBehaviorBehaviorBitfieldDecode(int value) {
        return value * 1;
    }

    public static double setDisableBehaviorReservedDecode(int value) {
        return value * 1;
    }

    public static double getDisableBehaviorBehaviorBitfieldDecode(int value) {
        return value * 1;
    }

    public static double getDisableBehaviorReservedDecode(int value) {
        return value * 1;
    }

    public static double getVersionFirmwareFixDecode(int value) {
        return value * 1;
    }

    public static double getVersionFirmwareMinorDecode(int value) {
        return value * 1;
    }

    public static double getVersionFirmwareYearDecode(int value) {
        return value * 1;
    }

    public static double getVersionHardwareMinorDecode(int value) {
        return value * 1;
    }

    public static double getVersionHardwareMajorDecode(int value) {
        return value * 1;
    }

    public static double getVersionReservedDecode(int value) {
        return value * 1;
    }

    public static double getHardwareFaultsReservedDecode(int value) {
        return value * 1;
    }

    public static double setBanksPulsePeriodResponseChannelBanksBitfieldDecode(int value) {
        return value * 1;
    }

    public static double setBanksPulsePeriodResponseReservedDecode(int value) {
        return value * 1;
    }

    public static double setBanksPulsePeriodResponsePulsePeriodDecode(int value) {
        return value * 1;
    }

    public static double setBanksPulsePeriodResponseResultDecode(int value) {
        return value * 1;
    }

    public static double resetConfigurationResponseMagicDecode(int value) {
        return value * 1;
    }

    public static double setServoMinPulseResponseChannelDecode(int value) {
        return value * 1;
    }

    public static double setServoMinPulseResponsePulseUsDecode(int value) {
        return value * 1;
    }

    public static double setServoMinPulseResponseResultDecode(int value) {
        return value * 1;
    }

    public static double setServoCenterPulseResponseChannelDecode(int value) {
        return value * 1;
    }

    public static double setServoCenterPulseResponsePulseUsDecode(int value) {
        return value * 1;
    }

    public static double setServoCenterPulseResponseResultDecode(int value) {
        return value * 1;
    }

    public static double setServoMaxPulseResponseChannelDecode(int value) {
        return value * 1;
    }

    public static double setServoMaxPulseResponsePulseUsDecode(int value) {
        return value * 1;
    }

    public static double setServoMaxPulseResponseResultDecode(int value) {
        return value * 1;
    }

    public static double getPulseRangeResponseMinPulseUsDecode(int value) {
        return value * 1;
    }

    public static double getPulseRangeResponseCenterPulseUsDecode(int value) {
        return value * 1;
    }

    public static double getPulseRangeResponseMaxPulseUsDecode(int value) {
        return value * 1;
    }

    public static double setDisableBehaviorResponseResultDecode(int value) {
        return value * 1;
    }

    public static double setDisableBehaviorResponseMaskDecode(int value) {
        return value * 1;
    }

    public static double setDisableBehaviorResponseBehaviorBitfieldDecode(int value) {
        return value * 1;
    }

    public static double setDisableBehaviorResponseReservedDecode(int value) {
        return value * 1;
    }

    public static double sRSEnableProgrammingModeReservedDecode(int value) {
        return value * 1;
    }

    public static double sRSSetServoLimitsChannelDecode(int value) {
        return value * 1;
    }

    public static double sRSSetServoLimitsLeftLimitDecode(int value) {
        return value * 1;
    }

    public static double sRSSetServoLimitsRightLimitDecode(int value) {
        return value * 1;
    }

    public static double sRSSetServoDriveModeChannelDecode(int value) {
        return value * 1;
    }

    public static double sRSSetServoDriveModeModeDecode(int value) {
        return value * 1;
    }

    public static double sRSProgrammingModeResponseResultDecode(int value) {
        return value * 1;
    }

    public static double sRSSetLimitsResponseChannelDecode(int value) {
        return value * 1;
    }

    public static double sRSSetLimitsResponseResultDecode(int value) {
        return value * 1;
    }

    public static double sRSSetDriveModeResponseChannelDecode(int value) {
        return value * 1;
    }

    public static double sRSSetDriveModeResponseResultDecode(int value) {
        return value * 1;
    }

    public static double setCANIDIdDecode(int value) {
        return value * 1;
    }

    public record Bootloader0(int bLMajor, int bLMinor, int productID, int rsvd) {
    }

    public record Status0(int voltage, int servoVoltage, int deviceCurrent, boolean primaryHeartbeatLock, boolean systemEnabled, int communicationMode, boolean programmingModeEnabled, boolean servoProgrammingActive, int reserved) {
    }

    public record Status1(boolean regulatorPGoodFault, boolean brownout, boolean cANWarning, boolean cANBusOff, boolean hardwareFault, boolean firmwareFault, boolean hasReset, boolean channel0Overcurrent, boolean channel1Overcurrent, boolean channel2Overcurrent, boolean channel3Overcurrent, boolean channel4Overcurrent, boolean channel5Overcurrent, boolean lowBatteryFault, int reserved, boolean stickyRegulatorPGoodFault, boolean stickyBrownout, boolean stickyCANWarning, boolean stickyCANBusOff, boolean stickyHardwareFault, boolean stickyFirmwareFault, boolean stickyHasReset, boolean stickyChannel0Overcurrent, boolean stickyChannel1Overcurrent, boolean stickyChannel2Overcurrent, boolean stickyChannel3Overcurrent, boolean stickyChannel4Overcurrent, boolean stickyChannel5Overcurrent, boolean stickyLowBatteryFault, int reserved2) {
    }

    public record Status2(int channel0PulseWidth, int channel1PulseWidth, int channel2PulseWidth, boolean channel0Enabled, boolean channel1Enabled, boolean channel2Enabled, boolean channel0OutOfRange, boolean channel1OutOfRange, boolean channel2OutOfRange, int reserved) {
    }

    public record Status3(int channel3PulseWidth, int channel4PulseWidth, int channel5PulseWidth, boolean channel3Enabled, boolean channel4Enabled, boolean channel5Enabled, boolean channel3OutOfRange, boolean channel4OutOfRange, boolean channel5OutOfRange, int reserved) {
    }

    public record Status4(int channel0Current, int channel1Current, int channel2Current, int channel3Current, int channel4Current, int channel5Current, int reserved) {
    }

    public record SetServo0to2PulseWidths(int pulseWidth0, int pulseWidth1, int pulseWidth2, boolean enableChannel0, boolean enableChannel1, boolean enableChannel2, boolean powerChannel0, boolean powerChannel1, boolean powerChannel2, int reserved) {
    }

    public record SetServo3to5PulseWidths(int pulseWidth3, int pulseWidth4, int pulseWidth5, boolean enableChannel3, boolean enableChannel4, boolean enableChannel5, boolean powerChannel3, boolean powerChannel4, boolean powerChannel5, int reserved) {
    }

    public record SetBanksPulsePeriod(int channelBanksBitfield, int reserved, int pulsePeriod) {
    }

    public record ResetConfiguration(int magic) {
    }

    public record SetServoMinPulseWidth(int channel, int pulseUs) {
    }

    public record SetServoCenterPulseWidth(int channel, int pulseUs) {
    }

    public record SetServoMaxPulseWidth(int channel, int pulseUs) {
    }

    public record GetPulseRange(int channel) {
    }

    public record SetDisableBehavior(int mask, int behaviorBitfield, int reserved) {
    }

    public record GetDisableBehavior(int behaviorBitfield, long reserved) {
    }

    public record ClearFaults() {
    }

    public record Identify() {
    }

    public record GetVersion(int firmwareFix, int firmwareMinor, int firmwareYear, int hardwareMinor, int hardwareMajor, int reserved) {
    }

    public record USBCheck() {
    }

    public record GetHardwareFaults(boolean aDCInit, boolean cRCInit, boolean dACInit, boolean fDCANInit, boolean i2CInit, boolean sYSClockInit, boolean sPIInit, boolean tIMInit, boolean uSARTInit, boolean cSA1Init, boolean cSA1Read, boolean cSA1Invalid, boolean cSA2Init, boolean cSA2Read, boolean cSA2Invalid, boolean fRCCANInit, boolean cANTx, boolean cANRx, boolean cANSetID, boolean eEPROMRead, boolean eEPROMWrite, long reserved) {
    }

    public record SetBanksPulsePeriodResponse(int channelBanksBitfield, int reserved, int pulsePeriod, int result) {
    }

    public record ResetConfigurationResponse(int magic) {
    }

    public record SetServoMinPulseResponse(int channel, int pulseUs, int result) {
    }

    public record SetServoCenterPulseResponse(int channel, int pulseUs, int result) {
    }

    public record SetServoMaxPulseResponse(int channel, int pulseUs, int result) {
    }

    public record GetPulseRangeResponse(int minPulseUs, int centerPulseUs, int maxPulseUs) {
    }

    public record SetDisableBehaviorResponse(int result, int mask, int behaviorBitfield, int reserved) {
    }

    public record SRSEnableProgrammingMode(boolean channel0Enabled, boolean channel1Enabled, boolean channel2Enabled, boolean channel3Enabled, boolean channel4Enabled, boolean channel5Enabled, int reserved) {
    }

    public record SRSSetServoLimits(int channel, int leftLimit, int rightLimit) {
    }

    public record SRSSetServoDriveMode(int channel, int mode) {
    }

    public record SRSProgrammingModeResponse(int result) {
    }

    public record SRSSetLimitsResponse(int channel, int result) {
    }

    public record SRSSetDriveModeResponse(int channel, int result) {
    }

    public record ClearFaultsResponse() {
    }

    public record SetCANID(int id) {
    }
}

