/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app;

import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.slcan.SLCanBridge;
import com.revrobotics.device.detection.DeviceDaemon;
import com.revrobotics.device.detection.dfu.DfuManager;
import com.revrobotics.device.detection.dfu.ExecutableDfuManager;
import com.revrobotics.device.detection.gsusb.GSUsbManager;
import com.revrobotics.device.detection.gsusb.LibUsbGSUsbManager;
import com.revrobotics.revlib.support.CallbackDriver;
import com.revrobotics.revui.app.files.DirectoryManager;
import java.nio.file.Path;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CanBridgeConfiguration {
    @Bean
    public CanBridge canBridge() {
        Path pathName = DirectoryManager.getTracingPath();
        SLCanBridge bridge = new SLCanBridge(pathName);
        if (CallbackDriver.canBridgeHolder.canBridge == null) {
            CallbackDriver.canBridgeHolder.canBridge = bridge;
        }
        return bridge;
    }

    @Bean
    public DfuManager dfuManager() {
        Path directory = DirectoryManager.getExecutableDirectory();
        return new ExecutableDfuManager(directory);
    }

    @Bean
    public GSUsbManager gsUsbManager() {
        return new LibUsbGSUsbManager();
    }

    @Bean
    public DeviceDaemon deviceDaemon(CanBridge canBridge, DfuManager dfuManager, @Autowired(required=false) GSUsbManager gsUsbManager) {
        return new DeviceDaemon(canBridge, dfuManager, gsUsbManager);
    }
}

