/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jspecify.annotations.NonNull;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClient;
import org.springframework.web.multipart.MultipartFile;
import tools.jackson.databind.ObjectMapper;

@CrossOrigin(origins={"http://localhost:3000"})
@RestController
@RequestMapping(value={"/v1/report/issue"})
@Validated
public class ReportIssueController {
    private static final String BASE_URL = "https://rhc-upload-server.uc.r.appspot.com";
    RestClient client = RestClient.builder().requestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory()).baseUrl("https://rhc-upload-server.uc.r.appspot.com").build();
    private final ObjectMapper mapper = new ObjectMapper();

    @PostMapping(path={"/"}, consumes={"multipart/form-data"})
    public void reportIssue(@Parameter(description="Issue information", content={@Content(mediaType="application/json", schema=@Schema(implementation=ReportIssueRequestBody.class))}) @RequestPart(value="report") ReportIssueRequestBody report, @RequestPart(value="attachments", required=false) List<MultipartFile> attachments) throws IOException {
        ReportIssueBody request = new ReportIssueBody(report.name, report.email, report.description, report.subject, report.orderNumber);
        String requestString = this.mapper.writeValueAsString((Object)request);
        byte[] zipBytes = this.createLogZip();
        if (zipBytes == null) {
            throw new IOException("Could not create log zip");
        }
        ByteArrayResource zipResource = new ByteArrayResource(this, zipBytes){

            public @NonNull String getFilename() {
                return "logs.zip";
            }
        };
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.add((Object)"report", (Object)requestString);
        parts.add((Object)"logs", (Object)zipResource);
        if (attachments != null) {
            for (MultipartFile attachment : attachments) {
                String originalName = attachment.getOriginalFilename();
                final String filename = originalName == null ? "attachment" : originalName;
                ByteArrayResource resource = new ByteArrayResource(this, attachment.getBytes()){

                    public String getFilename() {
                        return filename;
                    }
                };
                parts.add((Object)filename, (Object)resource);
            }
        }
        ResponseEntity response = ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.client.post().uri("/report/attachments", new Object[0])).header("Content-Type", new String[]{"multipart/form-data"})).body((Object)parts).retrieve().toBodilessEntity();
        System.out.println(response);
        if (response.getStatusCode() == HttpStatus.OK) {
            System.out.println("Success");
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] createLogZip() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void addFileToZip(Path path, UnaryOperator<byte[]> transform, ZipOutputStream zos) throws IOException {
        byte[] original = Files.readAllBytes(path);
        byte[] transformed = (byte[])transform.apply(original);
        ZipEntry entry = new ZipEntry(path.getFileName().toString());
        entry.setSize(transformed.length);
        zos.putNextEntry(entry);
        zos.write(transformed);
        zos.closeEntry();
    }

    private static byte[] redactUsername(byte[] bytes) {
        String username = System.getProperty("user.name");
        String content = new String(bytes);
        String redacted = content.replaceAll(username, "REDACTED");
        return redacted.getBytes();
    }

    private static /* synthetic */ void lambda$createLogZip$1(ZipOutputStream zos, Path path) {
        try {
            ReportIssueController.addFileToZip(path, ReportIssueController::redactUsername, zos);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static /* synthetic */ boolean lambda$createLogZip$0(Path x$0) {
        return Files.isRegularFile(x$0, new LinkOption[0]);
    }

    private record ReportIssueBody(String name, String email, String description, String subject, @Nullable String orderNumber) {
    }

    public record ReportIssueRequestBody(String name, String email, String description, String subject, @Nullable String orderNumber) {
    }
}

