/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app.devices;

import com.revrobotics.ServoHubAdvanced;
import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.device.detection.Detector;
import com.revrobotics.device.detection.DeviceDaemon;
import com.revrobotics.device.detection.device.DeviceType;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.device.detection.device.Manufacturer;
import com.revrobotics.device.detection.device.RecognizedDevice;
import com.revrobotics.revui.app.CanBridgeController;
import com.revrobotics.revui.app.annotations.EnforcesDeviceType;
import com.revrobotics.revui.app.annotations.StandardExceptions;
import com.revrobotics.revui.app.annotations.Success;
import com.revrobotics.revui.app.exceptions.DeviceNotPresentException;
import com.revrobotics.revui.app.exceptions.WrongDeviceTypeException;
import com.revrobotics.revui.app.validation.CanID;
import com.revrobotics.revui.app.validation.PulseWidth;
import com.revrobotics.revui.app.validation.ServoChannel;
import com.revrobotics.servohub.ServoChannel;
import com.revrobotics.servohub.ServoHub;
import com.revrobotics.servohub.ServoHubLowLevel;
import com.revrobotics.servohub.config.ServoChannelConfig;
import com.revrobotics.servohub.config.ServoChannelConfigAccessor;
import com.revrobotics.servohub.config.ServoHubConfig;
import java.util.UUID;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/bus/{descriptor}/servo_hub/{uuid}"})
@Validated
public class ServoHubController {
    private static final Logger logger = Logger.getLogger(ServoHubController.class.getName());
    @Autowired
    DeviceDaemon deviceDaemon;

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/voltage"})
    public double getVoltage(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        ServoHub hub = this.getServoHub(device);
        return hub.getDeviceVoltage();
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/id"})
    public UUID setCanId(@PathVariable String descriptor, @PathVariable UUID uuid, @RequestBody @CanID int id) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        this.deviceDaemon.doWithRawCanBridge(decodedDescriptor, (canBridge, bus) -> {
            ServoHubAdvanced.setCanId((CanBridge)canBridge, (CanBus)bus, (int)device.id(), (int)id);
            return null;
        });
        return Detector.deviceUUID((int)id, (DeviceType)DeviceType.SERVO_CONTROLLER, (Manufacturer)Manufacturer.REV);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"usb-check"})
    public boolean checkIfUsbBridge(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        return (Boolean)this.deviceDaemon.doWithRawCanBridge(decodedDescriptor, (canBridge, bus) -> ServoHubAdvanced.checkIfUsbBridge((CanBridge)canBridge, (CanBus)bus, (int)device.id()));
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/servo_voltage"})
    public double getServoVoltage(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        ServoHub hub = this.getServoHub(device);
        return hub.getServoVoltage();
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/version"})
    public Version getVersion(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        ServoHub hub = this.getServoHub(device);
        ServoHubLowLevel.FirmwareVersion version = hub.getFirmwareVersion();
        return new Version(version.getYear(), version.getMinor(), version.getFix(), 0);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/channel/{channelNumber}/enable"})
    public void setEnabled(@PathVariable String descriptor, @PathVariable UUID uuid, @PathVariable @ServoChannel int channelNumber, boolean enabled) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        ServoHub hub = this.getServoHub(device);
        com.revrobotics.servohub.ServoChannel servoChannel = hub.getServoChannel(ServoChannel.ChannelId.fromInt((int)channelNumber));
        servoChannel.setEnabled(enabled);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/channel/{channelNumber}/power"})
    public void setPowered(@PathVariable String descriptor, @PathVariable UUID uuid, @PathVariable @ServoChannel int channelNumber, boolean powered) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        ServoHub hub = this.getServoHub(device);
        com.revrobotics.servohub.ServoChannel servoChannel = hub.getServoChannel(ServoChannel.ChannelId.fromInt((int)channelNumber));
        servoChannel.setPowered(powered);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/channel/{channelNumber}/pulse_width"})
    public void setChannelPulse(@PathVariable String descriptor, @PathVariable UUID uuid, @PathVariable @ServoChannel int channelNumber, @PulseWidth int pulseUs) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        ServoHub hub = this.getServoHub(device);
        com.revrobotics.servohub.ServoChannel servoChannel = hub.getServoChannel(ServoChannel.ChannelId.fromInt((int)channelNumber));
        servoChannel.setPulseWidth(pulseUs);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/channel/{channelNumber}/range"})
    public void setChannelMinPulse(@PathVariable String descriptor, @PathVariable UUID uuid, @PathVariable @ServoChannel int channelNumber, @PulseWidth int minPulseUs, @PulseWidth int maxPulseUs) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        ServoHub hub = this.getServoHub(device);
        ServoHubConfig config = new ServoHubConfig();
        ServoChannelConfig channelConfig = new ServoChannelConfig(ServoChannel.ChannelId.fromInt((int)channelNumber));
        channelConfig.pulseRange(minPulseUs, 1500, maxPulseUs);
        config.apply(ServoChannel.ChannelId.fromInt((int)channelNumber), channelConfig);
        hub.configure(config, ServoHub.ResetMode.kNoResetSafeParameters);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/channel/{channelNumber}/power_when_disabled"})
    public void setChannelPowerWhenDisabled(@PathVariable String descriptor, @PathVariable UUID uuid, @PathVariable @ServoChannel int channelNumber, ServoChannelConfig.BehaviorWhenDisabled behavior) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        ServoHub hub = this.getServoHub(device);
        ServoHubConfig config = new ServoHubConfig();
        ServoChannelConfig channelConfig = new ServoChannelConfig(ServoChannel.ChannelId.fromInt((int)channelNumber));
        channelConfig.disableBehavior(behavior);
        config.apply(ServoChannel.ChannelId.fromInt((int)channelNumber), channelConfig);
        hub.configure(config, ServoHub.ResetMode.kNoResetSafeParameters);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/channel/{channelNumber}/enable"})
    public boolean getChannelEnabled(@PathVariable String descriptor, @PathVariable UUID uuid, @PathVariable @ServoChannel int channelNumber) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        ServoHub hub = this.getServoHub(device);
        return hub.getServoChannel(ServoChannel.ChannelId.fromInt((int)channelNumber)).isEnabled();
    }

    @Deprecated
    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/channel/{channelNumber}/power"})
    public boolean getChannelPowered(@PathVariable String descriptor, @PathVariable UUID uuid, @PathVariable @ServoChannel int channelNumber) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        this.getServoHub(device);
        return true;
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/channel/{channelNumber}/pulse_width"})
    public double getChannelPulseWidth(@PathVariable String descriptor, @PathVariable UUID uuid, @PathVariable @ServoChannel int channelNumber) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        ServoHub hub = this.getServoHub(device);
        return hub.getServoChannel(ServoChannel.ChannelId.fromInt((int)channelNumber)).getPulseWidth();
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/channel/{channelNumber}/range"})
    public ServoChannelConfig.PulseRange getChannelPulseRange(@PathVariable String descriptor, @PathVariable UUID uuid, @PathVariable @ServoChannel int channelNumber) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        ServoHub hub = this.getServoHub(device);
        ServoChannelConfigAccessor config = hub.configAccessor.channel(ServoChannel.ChannelId.fromInt((int)channelNumber));
        return config.getPulseRange();
    }

    private ServoHub getServoHub(FRCCanDevice device) {
        ServoHub hub = this.deviceDaemon.getDeviceManager().getRevLibDeviceManager().getServoHub(device.id());
        if (hub == null) {
            throw new DeviceNotPresentException(device.uuid());
        }
        return hub;
    }

    @GetMapping(value={"/channel/{channelNumber}/power_when_disabled"})
    public ServoChannelConfig.BehaviorWhenDisabled getChannelDisableBehavior(@PathVariable String descriptor, @PathVariable UUID uuid, @PathVariable @ServoChannel int channelNumber) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        ServoHub hub = this.getServoHub(device);
        ServoChannelConfigAccessor config = hub.configAccessor.channel(ServoChannel.ChannelId.fromInt((int)channelNumber));
        return config.getDisableBehavior();
    }

    @GetMapping(value={"/faults"})
    public FaultsAndWarnings getFaults(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        ServoHub hub = this.getServoHub(device);
        return new FaultsAndWarnings(hub.getFaults(), hub.getWarnings(), hub.getStickyFaults(), hub.getStickyWarnings());
    }

    @PostMapping(value={"/faults/clear"})
    public void clearFaults(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        ServoHub hub = this.getServoHub(device);
        hub.clearFaults();
    }

    @PostMapping(value={"/identify"})
    public void identify(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        this.deviceDaemon.doWithRawCanBridge(decodedDescriptor, (canBridge, bus) -> {
            ServoHubAdvanced.identify((CanBridge)canBridge, (CanBus)bus, (int)device.id());
            return null;
        });
    }

    @PostMapping(value={"/dfu/enter"})
    public void enterDfuBootloader(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        this.deviceDaemon.doWithRawCanBridge(decodedDescriptor, (canBridge, bus) -> {
            ServoHubAdvanced.enterDfuBootloader((CanBridge)canBridge, (CanBus)bus, (int)device.id());
            return null;
        });
    }

    private void throwIfNeeded(FRCCanDevice device, UUID uuid) {
        if (device == null) {
            logger.severe("No Servo Hub with uuid " + String.valueOf(uuid) + " found");
            throw new DeviceNotPresentException(uuid);
        }
        if (device.type() != RecognizedDevice.SERVO_HUB) {
            throw new WrongDeviceTypeException();
        }
    }

    public record Version(int major, int minor, int fix, int prerelease) {
    }

    public record FaultsAndWarnings(ServoHub.Faults faults, ServoHub.Warnings warnings, ServoHub.Faults stickyFaults, ServoHub.Warnings stickyWarnings) {
    }
}

