/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app.devices;

import com.revrobotics.SparkAdvanced;
import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.device.detection.DeviceDaemon;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.device.detection.device.RecognizedDevice;
import com.revrobotics.jni.CANUpdateJNI;
import com.revrobotics.revlib.support.PlainSpark;
import com.revrobotics.revui.app.CanBridgeController;
import com.revrobotics.revui.app.exceptions.CANFirmwareUpdateFailedException;
import com.revrobotics.revui.app.exceptions.CANUpdateSessionNotFoundException;
import com.revrobotics.revui.app.exceptions.CANUpdateSessionNotReadyException;
import com.revrobotics.revui.app.exceptions.CanBusNotFoundException;
import com.revrobotics.revui.app.exceptions.SparkDeviceError;
import com.revrobotics.spark.SparkBase;
import com.revrobotics.spark.config.SparkParameters;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/bus/{descriptor}/spark/update/can/"})
public class SparkCANUpdateController {
    @Autowired
    DeviceDaemon deviceDaemon;

    @ApiResponses(value={@ApiResponse(responseCode="201", description="Session created successfully"), @ApiResponse(responseCode="404", description="Error: Bus not found"), @ApiResponse(responseCode="422", description="Error: Device error")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(path={"/"})
    public int createSession(@PathVariable String descriptor, @RequestBody UUID[] uuids, @RequestParam PlainSpark.SparkType sparkType, @RequestParam(defaultValue="3") int allowedRetries) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        if (this.deviceDaemon.getDeviceManager().getCanBus(decodedDescriptor) == null) {
            throw new CanBusNotFoundException(decodedDescriptor);
        }
        for (UUID uuid : uuids) {
            FRCCanDevice dev = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
            if (dev == null) {
                throw new SparkDeviceError(uuid);
            }
            SparkBase sparkDevice = this.deviceDaemon.getDeviceManager().getRevLibDeviceManager().getSpark(dev.id());
            if (sparkDevice == null) {
                throw new SparkDeviceError(uuid);
            }
            this.deviceDaemon.doWithRawCanBridge(decodedDescriptor, (bridge, bus) -> {
                PlainSpark.SparkType actualType;
                RecognizedDevice actualModel;
                int productId = SparkAdvanced.readParameterInt32((CanBridge)bridge, (CanBus)bus, (int)dev.id(), (int)SparkParameters.kProductId.value);
                RecognizedDevice selector0$temp = actualModel = RecognizedDevice.getSparkTypeFromProductId((int)productId);
                int index$1 = 0;
                switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"SPARK_FLEX", "SPARK_MAX"}, (RecognizedDevice)selector0$temp, index$1)) {
                    case 0: {
                        PlainSpark.SparkType sparkType2 = PlainSpark.SparkType.SPARK_FLEX;
                        break;
                    }
                    case 1: {
                        PlainSpark.SparkType sparkType2 = PlainSpark.SparkType.SPARK_MAX;
                        break;
                    }
                    default: {
                        PlainSpark.SparkType sparkType2 = actualType = PlainSpark.SparkType.UNKNOWN_SPARK;
                    }
                }
                if (actualType != sparkType) {
                    throw new SparkDeviceError(uuid);
                }
                return null;
            });
        }
        return new Session(decodedDescriptor, uuids, allowedRetries).getId();
    }

    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of active sessions")})
    @GetMapping(value={"/"})
    public int[] getSessions() {
        return Session.getAllSessionIds();
    }

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Session deleted successfully"), @ApiResponse(responseCode="404", description="Error: Session not found (sessionId does not exist)")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @DeleteMapping(value={"/{sessionId}"})
    public void deleteSession(@PathVariable int sessionId) {
        Session.getSessionById(sessionId);
        Session.endSession(sessionId);
    }

    @ApiResponses(value={@ApiResponse(responseCode="200", description="Session status retrieved successfully"), @ApiResponse(responseCode="404", description="Error: Session not found (sessionId does not exist)")})
    @GetMapping(value={"/{sessionId}"})
    public SessionStatus getSessionStatus(@PathVariable int sessionId) {
        Session session = Session.getSessionById(sessionId);
        return session.getStatus();
    }

    @ApiResponses(value={@ApiResponse(responseCode="200", description="Firmware uploaded successfully"), @ApiResponse(responseCode="404", description="Error: Session not found (sessionId does not exist)"), @ApiResponse(responseCode="500", description="Error: Failed to upload firmware file")})
    @PostMapping(path={"/{sessionId}/upload"}, consumes={"multipart/form-data"})
    public void uploadFirmware(@PathVariable int sessionId, @RequestPart(value="file") MultipartFile file) {
        Session session = Session.getSessionById(sessionId);
        session.updateStatus(SessionUpdateStatus.UPLOADING);
        try {
            Path tempFile = Files.createTempFile("sparkfirmware-", ".dfu", new FileAttribute[0]);
            Files.copy(file.getInputStream(), tempFile, StandardCopyOption.REPLACE_EXISTING);
            session.setFileName(tempFile);
            session.updateStatus(SessionUpdateStatus.READY_TO_FLASH);
        }
        catch (IOException e) {
            session.updateStatus(SessionUpdateStatus.FAILED);
            throw new CANFirmwareUpdateFailedException(sessionId);
        }
    }

    @ApiResponses(value={@ApiResponse(responseCode="202", description="Update queued successfully"), @ApiResponse(responseCode="404", description="Error: Session not found (sessionId does not exist)"), @ApiResponse(responseCode="424", description="Error: Session not ready to flash (session status is not READY_TO_FLASH)")})
    @PostMapping(value={"/{sessionId}/start"})
    public void startUpdate(@PathVariable int sessionId) {
        Session.getSessionById(sessionId).startFlashing();
    }

    private class Session {
        private final int id;
        private final String descriptor;
        private final UUID[] devices;
        private Path fileName = null;
        private volatile SessionUpdateStatus status;
        private volatile int percentage;
        private volatile Future<Boolean> queuedFlashTaskHandle = null;
        private final int allowedRetries;
        private static final Map<Integer, Session> sessions = new HashMap<Integer, Session>();
        private static volatile int nextSessionId = 0;
        private static final ExecutorService flashQueueThread = Executors.newSingleThreadExecutor();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Session(String descriptor, UUID[] devices, int allowedRetries) {
            this.descriptor = descriptor;
            this.devices = devices;
            this.status = SessionUpdateStatus.READY_FOR_UPLOAD;
            this.percentage = 0;
            this.allowedRetries = allowedRetries;
            Map<Integer, Session> map = sessions;
            synchronized (map) {
                this.id = nextSessionId++;
                sessions.put(this.id, this);
            }
        }

        public void updateStatus(SessionUpdateStatus newStatus) {
            this.status = newStatus;
        }

        public void setPercentage(int percentage) {
            this.percentage = percentage;
        }

        public void setFileName(Path fileName) {
            this.fileName = fileName;
        }

        public int getId() {
            return this.id;
        }

        public SessionStatus getStatus() {
            return new SessionStatus(this.descriptor, this.id, this.status, this.percentage, this.devices);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int[] getAllSessionIds() {
            Map<Integer, Session> map = sessions;
            synchronized (map) {
                return sessions.keySet().stream().mapToInt(Integer::intValue).toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Session getSessionById(int sessionId) {
            Map<Integer, Session> map = sessions;
            synchronized (map) {
                Session session = sessions.get(sessionId);
                if (session == null) {
                    throw new CANUpdateSessionNotFoundException(sessionId);
                }
                return session;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void endSession(int sessionId) {
            Map<Integer, Session> map = sessions;
            synchronized (map) {
                Session session = Session.getSessionById(sessionId);
                if (session.queuedFlashTaskHandle != null) {
                    session.queuedFlashTaskHandle.cancel(true);
                }
                sessions.remove(sessionId);
            }
        }

        public void startFlashing() {
            if (this.status != SessionUpdateStatus.READY_TO_FLASH) {
                throw new CANUpdateSessionNotReadyException(this.id, this.status);
            }
            if (SparkCANUpdateController.this.deviceDaemon.getDeviceManager().getCanBus(this.descriptor) == null) {
                this.updateStatus(SessionUpdateStatus.FAILED);
                throw new CanBusNotFoundException(this.descriptor);
            }
            this.updateStatus(SessionUpdateStatus.QUEUED);
            this.queuedFlashTaskHandle = flashQueueThread.submit(() -> {
                int[] deviceIDs = new int[this.devices.length];
                for (int i = 0; i < this.devices.length; ++i) {
                    FRCCanDevice dev = SparkCANUpdateController.this.deviceDaemon.getDeviceManager().getDevice(this.descriptor, this.devices[i]);
                    if (dev == null) {
                        this.updateStatus(SessionUpdateStatus.FAILED);
                        throw new SparkDeviceError(this.devices[i]);
                    }
                    deviceIDs[i] = dev.id();
                }
                this.updateStatus(SessionUpdateStatus.FLASHING);
                CANUpdateJNI.ResetSWDL();
                CANUpdateJNI.SetSWDLDevices((int[])deviceIDs);
                Path binPath = Files.createTempFile("sparkfirmware-", ".bin", new FileAttribute[0]);
                for (int i = 0; i < this.allowedRetries; ++i) {
                    int flashProgress = 0;
                    while (flashProgress < 100) {
                        flashProgress = CANUpdateJNI.IterateSWDL((String)this.fileName.toString(), (String)binPath.toString());
                        if (flashProgress < 0) {
                            this.updateStatus(SessionUpdateStatus.FAILED);
                            throw new CANFirmwareUpdateFailedException(this.id);
                        }
                        this.setPercentage(flashProgress);
                        Thread.onSpinWait();
                        if (!Thread.currentThread().isInterrupted()) continue;
                        CANUpdateJNI.ResetSWDL();
                        this.updateStatus(SessionUpdateStatus.FAILED);
                        return false;
                    }
                    Thread.sleep(1000L);
                    if (!CANUpdateJNI.SWDLChecksumFailFramePresent()) {
                        this.updateStatus(SessionUpdateStatus.COMPLETED);
                        break;
                    }
                    this.updateStatus(SessionUpdateStatus.CHECKSUM_FAILED_RETRYING);
                    Thread.sleep(1000L);
                }
                CANUpdateJNI.ResetSWDL();
                if (this.status != SessionUpdateStatus.COMPLETED) {
                    this.updateStatus(SessionUpdateStatus.FAILED);
                    throw new CANFirmwareUpdateFailedException(this.id);
                }
                return true;
            });
        }
    }

    public record SessionStatus(String busDescriptor, int id, SessionUpdateStatus status, int percentage, UUID[] devices) {
    }

    public static enum SessionUpdateStatus {
        READY_FOR_UPLOAD,
        UPLOADING,
        READY_TO_FLASH,
        QUEUED,
        FLASHING,
        COMPLETED,
        CHECKSUM_FAILED_RETRYING,
        FAILED;

    }
}

