/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import com.fasterxml.jackson.annotation.JsonView;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.http.converter.AbstractJacksonHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.servlet.view.AbstractView;
import tools.jackson.core.JsonEncoding;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.ObjectWriter;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.ser.FilterProvider;

public abstract class AbstractJacksonView
extends AbstractView {
    protected static final String JSON_VIEW_HINT = JsonView.class.getName();
    protected static final String FILTER_PROVIDER_HINT = FilterProvider.class.getName();
    private static volatile @Nullable List<JacksonModule> modules;
    private final ObjectMapper mapper;
    private JsonEncoding encoding = JsonEncoding.UTF8;
    private boolean disableCaching = true;
    protected boolean updateContentLength = false;

    protected AbstractJacksonView(MapperBuilder<?, ?> builder, String contentType) {
        this.mapper = builder.addModules(this.initModules()).build();
        this.setContentType(contentType);
        this.setExposePathVariables(false);
    }

    protected AbstractJacksonView(ObjectMapper mapper, String contentType) {
        this.mapper = mapper;
        this.setContentType(contentType);
        this.setExposePathVariables(false);
    }

    private List<JacksonModule> initModules() {
        if (modules == null) {
            modules = MapperBuilder.findModules((ClassLoader)AbstractJacksonHttpMessageConverter.class.getClassLoader());
        }
        return Objects.requireNonNull(modules);
    }

    public void setEncoding(JsonEncoding encoding) {
        Assert.notNull((Object)encoding, (String)"'encoding' must not be null");
        this.encoding = encoding;
    }

    public final JsonEncoding getEncoding() {
        return this.encoding;
    }

    public void setDisableCaching(boolean disableCaching) {
        this.disableCaching = disableCaching;
    }

    public void setUpdateContentLength(boolean updateContentLength) {
        this.updateContentLength = updateContentLength;
    }

    @Override
    protected void prepareResponse(HttpServletRequest request, HttpServletResponse response) {
        this.setResponseContentType(request, response);
        response.setCharacterEncoding(this.encoding.getJavaName());
        if (this.disableCaching) {
            response.addHeader("Cache-Control", "no-store");
        }
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object stream;
        ByteArrayOutputStream temporaryStream = null;
        if (this.updateContentLength) {
            temporaryStream = this.createTemporaryOutputStream();
            stream = temporaryStream;
        } else {
            stream = response.getOutputStream();
        }
        Object value = this.filterModel(model, request);
        Map<String, Object> hints = null;
        boolean containsFilterProviderHint = model.containsKey(FILTER_PROVIDER_HINT);
        if (model.containsKey(JSON_VIEW_HINT)) {
            if (containsFilterProviderHint) {
                hints = new HashMap<String, Object>(2);
                hints.put(JSON_VIEW_HINT, model.get(JSON_VIEW_HINT));
                hints.put(FILTER_PROVIDER_HINT, model.get(FILTER_PROVIDER_HINT));
            } else {
                hints = Collections.singletonMap(JSON_VIEW_HINT, model.get(JSON_VIEW_HINT));
            }
        } else if (containsFilterProviderHint) {
            hints = Collections.singletonMap(FILTER_PROVIDER_HINT, model.get(FILTER_PROVIDER_HINT));
        }
        this.writeContent((OutputStream)stream, value, hints);
        if (temporaryStream != null) {
            this.writeToResponse(response, temporaryStream);
        }
    }

    protected void writeContent(OutputStream stream, Object object, @Nullable Map<String, Object> hints) throws IOException {
        try (JsonGenerator generator = this.mapper.createGenerator(stream, this.encoding);){
            ObjectWriter objectWriter;
            this.writePrefix(generator, object);
            Class serializationView = null;
            FilterProvider filters = null;
            if (hints != null) {
                serializationView = (Class)hints.get(JSON_VIEW_HINT);
                filters = (FilterProvider)hints.get(FILTER_PROVIDER_HINT);
            }
            ObjectWriter objectWriter2 = objectWriter = serializationView != null ? this.mapper.writerWithView(serializationView) : this.mapper.writer();
            if (filters != null) {
                objectWriter = objectWriter.with(filters);
            }
            objectWriter.writeValue(generator, object);
            this.writeSuffix(generator, object);
            generator.flush();
        }
    }

    public abstract void setModelKey(String var1);

    protected abstract Object filterModel(Map<String, Object> var1, HttpServletRequest var2);

    protected void writePrefix(JsonGenerator generator, Object object) throws IOException {
    }

    protected void writeSuffix(JsonGenerator generator, Object object) throws IOException {
    }
}

