/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc;

import com.github.therapi.runtimejavadoc.BaseJavadoc;
import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.OtherJavadoc;
import com.github.therapi.runtimejavadoc.ParamJavadoc;
import com.github.therapi.runtimejavadoc.RuntimeJavadoc;
import com.github.therapi.runtimejavadoc.SeeAlsoJavadoc;
import com.github.therapi.runtimejavadoc.ThrowsJavadoc;
import com.github.therapi.runtimejavadoc.internal.RuntimeJavadocHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MethodJavadoc
extends BaseJavadoc {
    private final List<String> paramTypes;
    private final Map<String, ParamJavadoc> params;
    private final Map<String, ThrowsJavadoc> exceptions;
    private final Comment returns;

    public MethodJavadoc(String name, List<String> paramTypes, Comment comment, List<ParamJavadoc> params, List<ThrowsJavadoc> exceptions, List<OtherJavadoc> other, Comment returns, List<SeeAlsoJavadoc> seeAlso) {
        super(name, comment, seeAlso, other);
        this.paramTypes = RuntimeJavadocHelper.unmodifiableDefensiveCopy(paramTypes);
        this.returns = Comment.nullToEmpty(returns);
        LinkedHashMap paramJavadocMap = new LinkedHashMap();
        if (params != null) {
            params.forEach(paramJavadoc -> paramJavadocMap.put(paramJavadoc.getName(), paramJavadoc));
        }
        this.params = Collections.unmodifiableMap(paramJavadocMap);
        LinkedHashMap throwsJavadocMap = new LinkedHashMap();
        if (params != null) {
            exceptions.forEach(throwsJavadoc -> throwsJavadocMap.put(throwsJavadoc.getName(), throwsJavadoc));
        }
        this.exceptions = Collections.unmodifiableMap(throwsJavadocMap);
    }

    private MethodJavadoc(String name, List<String> paramTypes, Comment comment, Map<String, ParamJavadoc> params, Map<String, ThrowsJavadoc> exceptions, List<OtherJavadoc> other, Comment returns, List<SeeAlsoJavadoc> seeAlso) {
        super(name, comment, seeAlso, other);
        this.paramTypes = Collections.unmodifiableList(paramTypes);
        this.params = Collections.unmodifiableMap(params);
        this.exceptions = Collections.unmodifiableMap(exceptions);
        this.returns = returns;
    }

    public static MethodJavadoc createEmpty(Executable executable) {
        String name = executable instanceof Constructor ? "<init>" : executable.getName();
        List paramTypes = Arrays.stream(executable.getParameterTypes()).map(Class::getCanonicalName).collect(Collectors.toList());
        return new MethodJavadoc(name, paramTypes, null, (List)null, null, null, null, null){

            @Override
            public boolean isEmpty() {
                return true;
            }
        };
    }

    MethodJavadoc enhanceWithOverriddenJavadoc(Method method, Map<String, ClassJavadoc> classJavadocCache) {
        MethodJavadoc enhancedJavadoc = this;
        List<Class<?>> superTypes = RuntimeJavadocHelper.getAllTypeAncestors(method.getDeclaringClass());
        for (Class<?> superType : superTypes) {
            MethodJavadoc overriddenJavadoc;
            ClassJavadoc classJavadoc = classJavadocCache.get(superType.getCanonicalName());
            if (classJavadoc == null) {
                classJavadoc = RuntimeJavadoc.getSkinnyClassJavadoc(superType);
            }
            if (!(enhancedJavadoc = enhancedJavadoc.copyWithInheritance(overriddenJavadoc = classJavadoc.findMatchingMethod(method))).fullyDescribes(method)) continue;
            break;
        }
        return enhancedJavadoc;
    }

    private MethodJavadoc copyWithInheritance(MethodJavadoc superMethodJavadoc) {
        Comment comment;
        if (superMethodJavadoc.isEmpty()) {
            return this;
        }
        List<String> paramTypes = new ArrayList<String>(this.paramTypes);
        if (paramTypes.isEmpty()) {
            paramTypes = superMethodJavadoc.paramTypes;
        }
        if ((comment = this.getComment()).getElements().isEmpty()) {
            comment = superMethodJavadoc.getComment();
        }
        LinkedHashMap<String, ParamJavadoc> params = new LinkedHashMap<String, ParamJavadoc>(this.params);
        superMethodJavadoc.params.forEach(params::putIfAbsent);
        LinkedHashMap<String, ThrowsJavadoc> exceptions = new LinkedHashMap<String, ThrowsJavadoc>(this.exceptions);
        superMethodJavadoc.exceptions.forEach(exceptions::putIfAbsent);
        Comment returns = this.returns;
        if (returns.getElements().isEmpty()) {
            returns = superMethodJavadoc.returns;
        }
        return new MethodJavadoc(this.getName(), paramTypes, comment, params, exceptions, this.getOther(), returns, this.getSeeAlso());
    }

    public boolean isConstructor() {
        return "<init>".equals(this.getName());
    }

    boolean fullyDescribes(Method method) {
        if (!method.getName().equals(this.getName()) || method.getParameterCount() != this.paramTypes.size()) {
            throw new IllegalArgumentException("Method `" + method.getName() + "` does not match javadoc `" + this.getName() + "`");
        }
        return !this.getComment().getElements().isEmpty() && !this.returns.getElements().isEmpty() && method.getParameterCount() == this.params.size() && Arrays.stream(method.getExceptionTypes()).allMatch(exception -> this.exceptions.containsKey(exception.getSimpleName()));
    }

    public boolean matches(Executable executable) {
        if (executable instanceof Method) {
            return this.matches((Method)executable);
        }
        if (executable instanceof Constructor) {
            return this.matches((Constructor)executable);
        }
        throw new UnsupportedOperationException("Unknown executable type");
    }

    public boolean matches(Method method) {
        return method.getName().equals(this.getName()) && this.paramsMatch(method.getParameterTypes());
    }

    public boolean matches(Constructor<?> method) {
        return this.isConstructor() && this.paramsMatch(method.getParameterTypes());
    }

    private boolean paramsMatch(Class<?>[] paramTypes) {
        return MethodJavadoc.getCanonicalNames(paramTypes).equals(this.paramTypes);
    }

    private static List<String> getCanonicalNames(Class<?>[] paramTypes) {
        ArrayList<String> methodParamsTypes = new ArrayList<String>();
        for (Class<?> aClass : paramTypes) {
            methodParamsTypes.add(aClass.getCanonicalName());
        }
        return methodParamsTypes;
    }

    public List<String> getParamTypes() {
        return this.paramTypes;
    }

    public List<ParamJavadoc> getParams() {
        return Collections.unmodifiableList(new ArrayList<ParamJavadoc>(this.params.values()));
    }

    public List<ThrowsJavadoc> getThrows() {
        return Collections.unmodifiableList(new ArrayList<ThrowsJavadoc>(this.exceptions.values()));
    }

    public Comment getReturns() {
        return this.returns;
    }

    public String toString() {
        return "MethodJavadoc{name='" + this.getName() + '\'' + ", paramTypes='" + this.paramTypes + '\'' + ", comment=" + this.getComment() + ", params=" + this.params + ", exceptions=" + this.exceptions + ", other=" + this.getOther() + ", returns=" + this.returns + ", seeAlso=" + this.getSeeAlso() + '}';
    }
}

