/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import org.springdoc.core.customizers.SpringDocCustomizers;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.SpringDocProviders;
import org.springdoc.core.service.AbstractRequestService;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.OperationService;
import org.springdoc.webmvc.api.OpenApiResource;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;

@RestControllerEndpoint(id="openapi")
@ConditionalOnProperty(name={"springdoc.enable-default-api-docs"}, havingValue="true", matchIfMissing=true)
public class OpenApiActuatorResource
extends OpenApiResource {
    public OpenApiActuatorResource(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders, SpringDocCustomizers springDocCustomizers) {
        super(openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, springDocConfigProperties, springDocProviders, springDocCustomizers);
    }

    public OpenApiActuatorResource(String groupName, ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders, SpringDocCustomizers springDocCustomizers) {
        super(groupName, openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, springDocConfigProperties, springDocProviders, springDocCustomizers);
    }

    @Operation(hidden=true)
    @GetMapping(value={"/"}, produces={"application/json"})
    public byte[] openapiJson(HttpServletRequest request, Locale locale) throws JsonProcessingException {
        return super.openapiJson(request, "", locale);
    }

    @Operation(hidden=true)
    @GetMapping(value={"/yaml"}, produces={"application/vnd.oai.openapi"})
    public byte[] openapiYaml(HttpServletRequest request, Locale locale) throws JsonProcessingException {
        return super.openapiYaml(request, "yaml", locale);
    }

    @Override
    protected String getServerUrl(HttpServletRequest request, String apiDocsUrl) {
        return this.getActuatorURI(request.getScheme(), request.getServerName()).toString();
    }
}

