/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.security;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxRequestHeader;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxResponseHeader;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;

public class HxLocationRedirectStrategy
implements RedirectStrategy {
    private final HttpStatus status;
    private final RedirectStrategy delegate;

    public HxLocationRedirectStrategy() {
        this(HttpStatus.OK);
    }

    public HxLocationRedirectStrategy(HttpStatus status) {
        this.status = status;
        this.delegate = new DefaultRedirectStrategy();
    }

    public void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        if (request.getHeader(HtmxRequestHeader.HX_REQUEST.getValue()) == null) {
            this.delegate.sendRedirect(request, response, url);
        } else {
            this.sendHxLocationRedirect(request, response, url);
        }
    }

    protected void sendHxLocationRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        response.setHeader(HtmxResponseHeader.HX_LOCATION.getValue(), url);
        response.setStatus(this.status.value());
        response.getWriter().flush();
    }
}

