/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app;

import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JOptionPane;

public class MacMoveDialog {
    private static boolean isInApplicationsFolder() {
        try {
            Path path = Paths.get(MacMoveDialog.class.getProtectionDomain().getCodeSource().getLocation().toURI()).toRealPath(new LinkOption[0]);
            return path.toString().startsWith("/Applications/");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isPackaged() {
        return MacMoveDialog.getAppBundlePath() != null;
    }

    public static void checkAndOfferMoveToApplications() {
        if (!MacMoveDialog.isMac() || !MacMoveDialog.isPackaged()) {
            return;
        }
        if (MacMoveDialog.isInApplicationsFolder()) {
            return;
        }
        int choice = JOptionPane.showOptionDialog(null, "This app works best when installed in the Applications folder.\n\nWould you like to move it there now?", "Move to Applications?", 0, 1, null, new String[]{"Move to Applications", "Cancel"}, "Move to Applications");
        if (choice == 0) {
            MacMoveDialog.moveToApplicationsAndRelaunch();
        }
    }

    private static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    private static void moveToApplicationsAndRelaunch() {
        try {
            Path appPath = Paths.get(MacMoveDialog.getAppBundlePath(), new String[0]).resolve("..").resolve("..").toAbsolutePath();
            String script = "tell application \"Finder\"\n  set appPath to (POSIX file \"" + String.valueOf(appPath) + "\") as alias\n  set destPath to (POSIX file \"/Applications\") as alias\n  duplicate appPath to destPath with replacing\n  set appName to name of (info for appPath)\nend tell\ndelay 0.5\ndo shell script \"open \" & quoted form of (\"/Applications/\" & appName)";
            Process process = new ProcessBuilder("osascript", "-e", script).start();
            process.waitFor();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getAppBundlePath() {
        return System.getProperty("app.dir");
    }
}

