/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app.telemetry;

import com.revrobotics.revui.app.CanBridgeController;
import com.revrobotics.revui.app.StatusFrameWebsocketHandler;
import com.revrobotics.revui.app.exceptions.TelemetryLayoutFileInvalidFormat;
import com.revrobotics.revui.app.exceptions.TelemetryLayoutFileNotFound;
import com.revrobotics.revui.app.files.DirectoryManager;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;

@RestController
@RequestMapping(value={"/v1/telemetry"})
public class TelemetryController {
    @PostMapping(value={"/"})
    public void setFrameEnabled(@RequestBody TelemetryConfig config) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(config.encodedDescriptor);
        StatusFrameWebsocketHandler.INSTANCE.updateFrameEnabled(config.sessionId, decodedDescriptor, config.uuid, config.frame, config.enabled);
    }

    @ApiResponses(value={@ApiResponse(responseCode="400", description="Telemetry layout file has invalid format")})
    @PostMapping(value={"/layout"})
    public void setTelemetryLayout(@RequestBody String json) {
        try {
            Files.writeString(TelemetryController.getLayoutFilePath(), (CharSequence)TelemetryController.processJson(json), new OpenOption[0]);
        }
        catch (IOException | StreamReadException e) {
            throw new TelemetryLayoutFileInvalidFormat();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write telemetry layout file", e);
        }
    }

    @ApiResponses(value={@ApiResponse(responseCode="404", description="Telemetry layout file not found"), @ApiResponse(responseCode="500", description="Telemetry layout file corrupted or invalid format")})
    @GetMapping(value={"/layout"})
    public String getTelemetryLayout() {
        Path layoutPath = TelemetryController.getLayoutFilePath();
        if (!Files.exists(layoutPath, new LinkOption[0])) {
            throw new TelemetryLayoutFileNotFound();
        }
        try {
            return TelemetryController.processJson(Files.readString(layoutPath));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read telemetry layout file", e);
        }
    }

    private static Path getLayoutFilePath() {
        return DirectoryManager.getAppStoragePath().resolve("telemetry_layout.json");
    }

    public static String processJson(String json) throws IOException, StreamReadException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode parsed = mapper.readTree(json);
        if (!(parsed.has("ascope") && parsed.has("runSingle") && parsed.has("runMultiple"))) {
            throw new IOException("Invalid telemetry layout format");
        }
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)parsed);
    }

    public record TelemetryConfig(String sessionId, String encodedDescriptor, UUID uuid, int frame, boolean enabled) {
    }
}

