/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import org.springframework.data.jpa.repository.aot.AotQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.EntityQuery;

class NamedAotQuery
extends AotQuery {
    private final String name;
    private final DeclaredQuery query;
    private final boolean constructorExpressionOrDefaultProjection;

    public NamedAotQuery(String name, EntityQuery entityQuery) {
        super(entityQuery.getParameterBindings());
        this.name = name;
        this.query = entityQuery.getQuery();
        this.constructorExpressionOrDefaultProjection = AotQuery.hasConstructorExpressionOrDefaultProjection(entityQuery);
    }

    public static NamedAotQuery named(String namedQuery, EntityQuery query) {
        return new NamedAotQuery(namedQuery, query);
    }

    public String getName() {
        return this.name;
    }

    public DeclaredQuery getQuery() {
        return this.query;
    }

    public String getQueryString() {
        return this.getQuery().getQueryString();
    }

    @Override
    public boolean isNative() {
        return this.query.isNative();
    }

    @Override
    public boolean hasConstructorExpressionOrDefaultProjection() {
        return this.constructorExpressionOrDefaultProjection;
    }
}

