/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.can.spec;

public class PneumaticHubCanSpec {
    public static final int STATUS_0_FRAME_ID = 151328768;
    public static final int STATUS_1_FRAME_ID = 151328832;
    public static final int BOOTLOADER_0_FRAME_ID = 151367680;
    public static final int SET_COMPRESSOR_CONFIG_FRAME_ID = 151324736;
    public static final int SET_ALL_FRAME_ID = 151325696;
    public static final int PULSE_ONCE_FRAME_ID = 151325760;
    public static final int GET_STICKY_HARDWARE_FAULTS_FRAME_ID = 151329536;
    public static final int GET_HARDWARE_FAULTS_FRAME_ID = 151329600;
    public static final int CLEAR_FAULTS_FRAME_ID = 151329664;
    public static final int IDENTIFY_FRAME_ID = 151330176;
    public static final int GET_VERSION_FRAME_ID = 151332352;
    public static final int USB_CHECK_FRAME_ID = 151334080;
    public static final int SET_CAN_ID_FRAME_ID = 151355264;
    public static final int STATUS_0_LENGTH = 8;
    public static final int STATUS_1_LENGTH = 8;
    public static final int BOOTLOADER_0_LENGTH = 8;
    public static final int SET_COMPRESSOR_CONFIG_LENGTH = 5;
    public static final int SET_ALL_LENGTH = 4;
    public static final int PULSE_ONCE_LENGTH = 4;
    public static final int GET_STICKY_HARDWARE_FAULTS_LENGTH = 8;
    public static final int GET_HARDWARE_FAULTS_LENGTH = 8;
    public static final int CLEAR_FAULTS_LENGTH = 0;
    public static final int IDENTIFY_LENGTH = 0;
    public static final int GET_VERSION_LENGTH = 8;
    public static final int USB_CHECK_LENGTH = 0;
    public static final int SET_CAN_ID_LENGTH = 1;

    private static int packLeftShift(int value, int shift, int mask) {
        return value << shift & mask & 0xFF;
    }

    private static int packRightShift(int value, int shift, int mask) {
        return value >> shift & mask & 0xFF;
    }

    private static int unpackLeftShift8(int value, int shift, int mask) {
        return (value & mask) << shift & 0xFF;
    }

    private static int unpackLeftShift16(int value, int shift, int mask) {
        return (value & mask) << shift & 0xFFFF;
    }

    private static int unpackLeftShift32(int value, int shift, int mask) {
        return (value & mask) << shift & 0xFFFFFFFF;
    }

    private static int unpackRightShift8(int value, int shift, int mask) {
        return (value & mask) >> shift & 0xFF;
    }

    private static int unpackRightShift16(int value, int shift, int mask) {
        return (value & mask) >> shift & 0xFFFF;
    }

    private static int unpackRightShift32(int value, int shift, int mask) {
        return (value & mask) >> shift & 0xFFFFFFFF;
    }

    public static Status0 status0Unpack(byte[] data) {
        boolean channel0On = (data[0] & 1) != 0;
        boolean channel1On = (data[0] & 2) != 0;
        boolean channel2On = (data[0] & 4) != 0;
        boolean channel3On = (data[0] & 8) != 0;
        boolean channel4On = (data[0] & 0x10) != 0;
        boolean channel5On = (data[0] & 0x20) != 0;
        boolean channel6On = (data[0] & 0x40) != 0;
        boolean channel7On = (data[0] & 0x80) != 0;
        boolean channel8On = (data[1] & 1) != 0;
        boolean channel9On = (data[1] & 2) != 0;
        boolean channel10On = (data[1] & 4) != 0;
        boolean channel11On = (data[1] & 8) != 0;
        boolean channel12On = (data[1] & 0x10) != 0;
        boolean channel13On = (data[1] & 0x20) != 0;
        boolean channel14On = (data[1] & 0x40) != 0;
        boolean channel15On = (data[1] & 0x80) != 0;
        int analogChannel0 = PneumaticHubCanSpec.unpackIntBits(data, 16, 8);
        int analogChannel1 = PneumaticHubCanSpec.unpackIntBits(data, 24, 8);
        boolean digitalSensor = (data[4] & 1) != 0;
        boolean brownoutFault = (data[4] & 2) != 0;
        boolean compressorOvercurrentFault = (data[4] & 4) != 0;
        boolean compressorOpenFault = (data[4] & 8) != 0;
        boolean solenoidOvercurrentFault = (data[4] & 0x10) != 0;
        boolean cANWarningFault = (data[4] & 0x20) != 0;
        boolean hardwareFault = (data[4] & 0x40) != 0;
        int reserved1 = PneumaticHubCanSpec.unpackIntBits(data, 39, 1);
        boolean channel0Fault = (data[5] & 1) != 0;
        boolean channel1Fault = (data[5] & 2) != 0;
        boolean channel2Fault = (data[5] & 4) != 0;
        boolean channel3Fault = (data[5] & 8) != 0;
        boolean channel4Fault = (data[5] & 0x10) != 0;
        boolean channel5Fault = (data[5] & 0x20) != 0;
        boolean channel6Fault = (data[5] & 0x40) != 0;
        boolean channel7Fault = (data[5] & 0x80) != 0;
        boolean channel8Fault = (data[6] & 1) != 0;
        boolean channel9Fault = (data[6] & 2) != 0;
        boolean channel10Fault = (data[6] & 4) != 0;
        boolean channel11Fault = (data[6] & 8) != 0;
        boolean channel12Fault = (data[6] & 0x10) != 0;
        boolean channel13Fault = (data[6] & 0x20) != 0;
        boolean channel14Fault = (data[6] & 0x40) != 0;
        boolean channel15Fault = (data[6] & 0x80) != 0;
        boolean compressorOn = (data[7] & 1) != 0;
        boolean systemEnabled = (data[7] & 2) != 0;
        boolean roborioPresent = (data[7] & 4) != 0;
        int compressorConfig = PneumaticHubCanSpec.unpackIntBits(data, 59, 2);
        int reserved2 = PneumaticHubCanSpec.unpackIntBits(data, 61, 3);
        return new Status0(channel0On, channel1On, channel2On, channel3On, channel4On, channel5On, channel6On, channel7On, channel8On, channel9On, channel10On, channel11On, channel12On, channel13On, channel14On, channel15On, analogChannel0, analogChannel1, digitalSensor, brownoutFault, compressorOvercurrentFault, compressorOpenFault, solenoidOvercurrentFault, cANWarningFault, hardwareFault, reserved1, channel0Fault, channel1Fault, channel2Fault, channel3Fault, channel4Fault, channel5Fault, channel6Fault, channel7Fault, channel8Fault, channel9Fault, channel10Fault, channel11Fault, channel12Fault, channel13Fault, channel14Fault, channel15Fault, compressorOn, systemEnabled, roborioPresent, compressorConfig, reserved2);
    }

    public static Status1 status1Unpack(byte[] data) {
        int vBus = PneumaticHubCanSpec.unpackIntBits(data, 0, 8);
        int solenoidVoltage = PneumaticHubCanSpec.unpackIntBits(data, 8, 12);
        int reserved = PneumaticHubCanSpec.unpackIntBits(data, 20, 12);
        int compressorCurrent = PneumaticHubCanSpec.unpackIntBits(data, 32, 8);
        int solenoidCurrent = PneumaticHubCanSpec.unpackIntBits(data, 40, 8);
        boolean stickyBrownoutFault = (data[6] & 1) != 0;
        boolean stickyCompressorOCFault = (data[6] & 2) != 0;
        boolean stickyCompressorOpenFault = (data[6] & 4) != 0;
        boolean stickySolenoidOCFault = (data[6] & 8) != 0;
        boolean stickyCANWarningFault = (data[6] & 0x10) != 0;
        boolean stickyCANBusOffFault = (data[6] & 0x20) != 0;
        boolean stickyHardwareFault = (data[6] & 0x40) != 0;
        boolean stickyFirmwareFault = (data[6] & 0x80) != 0;
        boolean stickyHasReset = (data[7] & 1) != 0;
        int supplyVoltage5V = PneumaticHubCanSpec.unpackIntBits(data, 57, 7);
        return new Status1(vBus, solenoidVoltage, reserved, compressorCurrent, solenoidCurrent, stickyBrownoutFault, stickyCompressorOCFault, stickyCompressorOpenFault, stickySolenoidOCFault, stickyCANWarningFault, stickyCANBusOffFault, stickyHardwareFault, stickyFirmwareFault, stickyHasReset, supplyVoltage5V);
    }

    public static Bootloader0 bootloader0Unpack(byte[] data) {
        int bLMajor = PneumaticHubCanSpec.unpackIntBits(data, 0, 8);
        int bLMinor = PneumaticHubCanSpec.unpackIntBits(data, 8, 8);
        int productID = PneumaticHubCanSpec.unpackIntBits(data, 16, 16);
        int rsvd = PneumaticHubCanSpec.unpackIntBits(data, 32, 32);
        return new Bootloader0(bLMajor, bLMinor, productID, rsvd);
    }

    public static SetCompressorConfig setCompressorConfigUnpack(byte[] data) {
        int minimumTankPressure = PneumaticHubCanSpec.unpackIntBits(data, 0, 16);
        int maximumTankPressure = PneumaticHubCanSpec.unpackIntBits(data, 16, 16);
        boolean forceDisable = (data[4] & 1) != 0;
        boolean useDigital = (data[4] & 2) != 0;
        int reserved = PneumaticHubCanSpec.unpackIntBits(data, 34, 6);
        return new SetCompressorConfig(minimumTankPressure, maximumTankPressure, forceDisable, useDigital, reserved);
    }

    public static SetAll setAllUnpack(byte[] data) {
        int channel0 = PneumaticHubCanSpec.unpackIntBits(data, 0, 2);
        int channel1 = PneumaticHubCanSpec.unpackIntBits(data, 2, 2);
        int channel2 = PneumaticHubCanSpec.unpackIntBits(data, 4, 2);
        int channel3 = PneumaticHubCanSpec.unpackIntBits(data, 6, 2);
        int channel4 = PneumaticHubCanSpec.unpackIntBits(data, 8, 2);
        int channel5 = PneumaticHubCanSpec.unpackIntBits(data, 10, 2);
        int channel6 = PneumaticHubCanSpec.unpackIntBits(data, 12, 2);
        int channel7 = PneumaticHubCanSpec.unpackIntBits(data, 14, 2);
        int channel8 = PneumaticHubCanSpec.unpackIntBits(data, 16, 2);
        int channel9 = PneumaticHubCanSpec.unpackIntBits(data, 18, 2);
        int channel10 = PneumaticHubCanSpec.unpackIntBits(data, 20, 2);
        int channel11 = PneumaticHubCanSpec.unpackIntBits(data, 22, 2);
        int channel12 = PneumaticHubCanSpec.unpackIntBits(data, 24, 2);
        int channel13 = PneumaticHubCanSpec.unpackIntBits(data, 26, 2);
        int channel14 = PneumaticHubCanSpec.unpackIntBits(data, 28, 2);
        int channel15 = PneumaticHubCanSpec.unpackIntBits(data, 30, 2);
        return new SetAll(channel0, channel1, channel2, channel3, channel4, channel5, channel6, channel7, channel8, channel9, channel10, channel11, channel12, channel13, channel14, channel15);
    }

    public static PulseOnce pulseOnceUnpack(byte[] data) {
        boolean channel0 = (data[0] & 1) != 0;
        boolean channel1 = (data[0] & 2) != 0;
        boolean channel2 = (data[0] & 4) != 0;
        boolean channel3 = (data[0] & 8) != 0;
        boolean channel4 = (data[0] & 0x10) != 0;
        boolean channel5 = (data[0] & 0x20) != 0;
        boolean channel6 = (data[0] & 0x40) != 0;
        boolean channel7 = (data[0] & 0x80) != 0;
        boolean channel8 = (data[1] & 1) != 0;
        boolean channel9 = (data[1] & 2) != 0;
        boolean channel10 = (data[1] & 4) != 0;
        boolean channel11 = (data[1] & 8) != 0;
        boolean channel12 = (data[1] & 0x10) != 0;
        boolean channel13 = (data[1] & 0x20) != 0;
        boolean channel14 = (data[1] & 0x40) != 0;
        boolean channel15 = (data[1] & 0x80) != 0;
        int pulseLengthMs = PneumaticHubCanSpec.unpackIntBits(data, 16, 16);
        return new PulseOnce(channel0, channel1, channel2, channel3, channel4, channel5, channel6, channel7, channel8, channel9, channel10, channel11, channel12, channel13, channel14, channel15, pulseLengthMs);
    }

    public static GetStickyHardwareFaults getStickyHardwareFaultsUnpack(byte[] data) {
        boolean cANInit = (data[0] & 1) != 0;
        boolean cANSend = (data[0] & 2) != 0;
        boolean cANRx = (data[0] & 4) != 0;
        boolean cANSetId = (data[0] & 8) != 0;
        boolean eEPROMRead = (data[0] & 0x10) != 0;
        boolean eEPROMWrite = (data[0] & 0x20) != 0;
        boolean aDCInit = (data[0] & 0x40) != 0;
        boolean cRCInit = (data[0] & 0x80) != 0;
        boolean fDCANInit = (data[1] & 1) != 0;
        boolean i2CInit = (data[1] & 2) != 0;
        boolean sYSClockInit = (data[1] & 4) != 0;
        boolean sPIInit = (data[1] & 8) != 0;
        boolean timerInit = (data[1] & 0x10) != 0;
        boolean uSARTInit = (data[1] & 0x20) != 0;
        boolean lowSideInit = (data[1] & 0x40) != 0;
        boolean lowSideCMD = (data[1] & 0x80) != 0;
        long reserved = PneumaticHubCanSpec.unpackLongBits(data, 16, 48);
        return new GetStickyHardwareFaults(cANInit, cANSend, cANRx, cANSetId, eEPROMRead, eEPROMWrite, aDCInit, cRCInit, fDCANInit, i2CInit, sYSClockInit, sPIInit, timerInit, uSARTInit, lowSideInit, lowSideCMD, reserved);
    }

    public static GetHardwareFaults getHardwareFaultsUnpack(byte[] data) {
        boolean cANInit = (data[0] & 1) != 0;
        boolean cANSend = (data[0] & 2) != 0;
        boolean cANRx = (data[0] & 4) != 0;
        boolean cANSetId = (data[0] & 8) != 0;
        boolean eEPROMRead = (data[0] & 0x10) != 0;
        boolean eEPROMWrite = (data[0] & 0x20) != 0;
        boolean aDCInit = (data[0] & 0x40) != 0;
        boolean cRCInit = (data[0] & 0x80) != 0;
        boolean fDCANInit = (data[1] & 1) != 0;
        boolean i2CInit = (data[1] & 2) != 0;
        boolean sYSClockInit = (data[1] & 4) != 0;
        boolean sPIInit = (data[1] & 8) != 0;
        boolean timerInit = (data[1] & 0x10) != 0;
        boolean uSARTInit = (data[1] & 0x20) != 0;
        boolean lowSideInit = (data[1] & 0x40) != 0;
        boolean lowSideCMD = (data[1] & 0x80) != 0;
        long reserved = PneumaticHubCanSpec.unpackLongBits(data, 16, 48);
        return new GetHardwareFaults(cANInit, cANSend, cANRx, cANSetId, eEPROMRead, eEPROMWrite, aDCInit, cRCInit, fDCANInit, i2CInit, sYSClockInit, sPIInit, timerInit, uSARTInit, lowSideInit, lowSideCMD, reserved);
    }

    public static ClearFaults clearFaultsUnpack(byte[] data) {
        return new ClearFaults();
    }

    public static Identify identifyUnpack(byte[] data) {
        return new Identify();
    }

    public static GetVersion getVersionUnpack(byte[] data) {
        int firmwareFix = PneumaticHubCanSpec.unpackIntBits(data, 0, 8);
        int firmwareMinor = PneumaticHubCanSpec.unpackIntBits(data, 8, 8);
        int firmwareYear = PneumaticHubCanSpec.unpackIntBits(data, 16, 8);
        int hardwareMinor = PneumaticHubCanSpec.unpackIntBits(data, 24, 8);
        int hardwareMajor = PneumaticHubCanSpec.unpackIntBits(data, 32, 8);
        int reserved = PneumaticHubCanSpec.unpackIntBits(data, 40, 24);
        return new GetVersion(firmwareFix, firmwareMinor, firmwareYear, hardwareMinor, hardwareMajor, reserved);
    }

    public static USBCheck uSBCheckUnpack(byte[] data) {
        return new USBCheck();
    }

    public static SetCANID setCANIDUnpack(byte[] data) {
        int id = PneumaticHubCanSpec.unpackIntBits(data, 0, 8);
        return new SetCANID(id);
    }

    private static int unpackIntBits(byte[] data, int startBit, int length) {
        int result = 0;
        int currentByte = startBit / 8;
        int bitWithinByte = startBit % 8;
        for (int i = 0; i < length; ++i) {
            byte b = data[currentByte];
            int thisBit = (b & 1 << bitWithinByte) != 0 ? 1 : 0;
            result |= thisBit << i;
            if (++bitWithinByte != 8) continue;
            bitWithinByte = 0;
            ++currentByte;
        }
        return result;
    }

    private static long unpackLongBits(byte[] data, int startBit, int length) {
        long result = 0L;
        int currentByte = startBit / 8;
        int bitWithinByte = startBit % 8;
        for (int i = 0; i < length; ++i) {
            byte b = data[currentByte];
            long thisBit = (b & 1 << bitWithinByte) != 0 ? 1L : 0L;
            result |= thisBit << i;
            if (++bitWithinByte != 8) continue;
            bitWithinByte = 0;
            ++currentByte;
        }
        return result;
    }

    public static double status0AnalogChannel0Decode(int value) {
        return (double)value * 0.01961;
    }

    public static double status0AnalogChannel1Decode(int value) {
        return (double)value * 0.01961;
    }

    public static double status0Reserved1Decode(int value) {
        return value * 1;
    }

    public static double status0CompressorConfigDecode(int value) {
        return value * 1;
    }

    public static double status0Reserved2Decode(int value) {
        return value * 1;
    }

    public static double status1VBusDecode(int value) {
        return (double)value * 0.0625 + 4.0;
    }

    public static double status1SolenoidVoltageDecode(int value) {
        return (double)value * 0.0078125;
    }

    public static double status1ReservedDecode(int value) {
        return value * 1;
    }

    public static double status1CompressorCurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status1SolenoidCurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status1SupplyVoltage5VDecode(int value) {
        return (double)value * 0.0078125 + 4.5;
    }

    public static double bootloader0BLMajorDecode(int value) {
        return value * 1;
    }

    public static double bootloader0BLMinorDecode(int value) {
        return value * 1;
    }

    public static double bootloader0ProductIDDecode(int value) {
        return value * 1;
    }

    public static double bootloader0RsvdDecode(int value) {
        return value * 1;
    }

    public static double setCompressorConfigMinimumTankPressureDecode(int value) {
        return (double)value * 0.001;
    }

    public static double setCompressorConfigMaximumTankPressureDecode(int value) {
        return (double)value * 0.001;
    }

    public static double setCompressorConfigReservedDecode(int value) {
        return value * 1;
    }

    public static double setAllChannel0Decode(int value) {
        return value * 1;
    }

    public static double setAllChannel1Decode(int value) {
        return value * 1;
    }

    public static double setAllChannel2Decode(int value) {
        return value * 1;
    }

    public static double setAllChannel3Decode(int value) {
        return value * 1;
    }

    public static double setAllChannel4Decode(int value) {
        return value * 1;
    }

    public static double setAllChannel5Decode(int value) {
        return value * 1;
    }

    public static double setAllChannel6Decode(int value) {
        return value * 1;
    }

    public static double setAllChannel7Decode(int value) {
        return value * 1;
    }

    public static double setAllChannel8Decode(int value) {
        return value * 1;
    }

    public static double setAllChannel9Decode(int value) {
        return value * 1;
    }

    public static double setAllChannel10Decode(int value) {
        return value * 1;
    }

    public static double setAllChannel11Decode(int value) {
        return value * 1;
    }

    public static double setAllChannel12Decode(int value) {
        return value * 1;
    }

    public static double setAllChannel13Decode(int value) {
        return value * 1;
    }

    public static double setAllChannel14Decode(int value) {
        return value * 1;
    }

    public static double setAllChannel15Decode(int value) {
        return value * 1;
    }

    public static double pulseOncePulseLengthMsDecode(int value) {
        return value * 1;
    }

    public static double getStickyHardwareFaultsReservedDecode(int value) {
        return value * 1;
    }

    public static double getHardwareFaultsReservedDecode(int value) {
        return value * 1;
    }

    public static double getVersionFirmwareFixDecode(int value) {
        return value * 1;
    }

    public static double getVersionFirmwareMinorDecode(int value) {
        return value * 1;
    }

    public static double getVersionFirmwareYearDecode(int value) {
        return value * 1;
    }

    public static double getVersionHardwareMinorDecode(int value) {
        return value * 1;
    }

    public static double getVersionHardwareMajorDecode(int value) {
        return value * 1;
    }

    public static double getVersionReservedDecode(int value) {
        return value * 1;
    }

    public static double setCANIDIdDecode(int value) {
        return value * 1;
    }

    public record Status0(boolean channel0On, boolean channel1On, boolean channel2On, boolean channel3On, boolean channel4On, boolean channel5On, boolean channel6On, boolean channel7On, boolean channel8On, boolean channel9On, boolean channel10On, boolean channel11On, boolean channel12On, boolean channel13On, boolean channel14On, boolean channel15On, int analogChannel0, int analogChannel1, boolean digitalSensor, boolean brownoutFault, boolean compressorOvercurrentFault, boolean compressorOpenFault, boolean solenoidOvercurrentFault, boolean cANWarningFault, boolean hardwareFault, int reserved1, boolean channel0Fault, boolean channel1Fault, boolean channel2Fault, boolean channel3Fault, boolean channel4Fault, boolean channel5Fault, boolean channel6Fault, boolean channel7Fault, boolean channel8Fault, boolean channel9Fault, boolean channel10Fault, boolean channel11Fault, boolean channel12Fault, boolean channel13Fault, boolean channel14Fault, boolean channel15Fault, boolean compressorOn, boolean systemEnabled, boolean roborioPresent, int compressorConfig, int reserved2) {
    }

    public record Status1(int vBus, int solenoidVoltage, int reserved, int compressorCurrent, int solenoidCurrent, boolean stickyBrownoutFault, boolean stickyCompressorOCFault, boolean stickyCompressorOpenFault, boolean stickySolenoidOCFault, boolean stickyCANWarningFault, boolean stickyCANBusOffFault, boolean stickyHardwareFault, boolean stickyFirmwareFault, boolean stickyHasReset, int supplyVoltage5V) {
    }

    public record Bootloader0(int bLMajor, int bLMinor, int productID, int rsvd) {
    }

    public record SetCompressorConfig(int minimumTankPressure, int maximumTankPressure, boolean forceDisable, boolean useDigital, int reserved) {
    }

    public record SetAll(int channel0, int channel1, int channel2, int channel3, int channel4, int channel5, int channel6, int channel7, int channel8, int channel9, int channel10, int channel11, int channel12, int channel13, int channel14, int channel15) {
    }

    public record PulseOnce(boolean channel0, boolean channel1, boolean channel2, boolean channel3, boolean channel4, boolean channel5, boolean channel6, boolean channel7, boolean channel8, boolean channel9, boolean channel10, boolean channel11, boolean channel12, boolean channel13, boolean channel14, boolean channel15, int pulseLengthMs) {
    }

    public record GetStickyHardwareFaults(boolean cANInit, boolean cANSend, boolean cANRx, boolean cANSetId, boolean eEPROMRead, boolean eEPROMWrite, boolean aDCInit, boolean cRCInit, boolean fDCANInit, boolean i2CInit, boolean sYSClockInit, boolean sPIInit, boolean timerInit, boolean uSARTInit, boolean lowSideInit, boolean lowSideCMD, long reserved) {
    }

    public record GetHardwareFaults(boolean cANInit, boolean cANSend, boolean cANRx, boolean cANSetId, boolean eEPROMRead, boolean eEPROMWrite, boolean aDCInit, boolean cRCInit, boolean fDCANInit, boolean i2CInit, boolean sYSClockInit, boolean sPIInit, boolean timerInit, boolean uSARTInit, boolean lowSideInit, boolean lowSideCMD, long reserved) {
    }

    public record ClearFaults() {
    }

    public record Identify() {
    }

    public record GetVersion(int firmwareFix, int firmwareMinor, int firmwareYear, int hardwareMinor, int hardwareMajor, int reserved) {
    }

    public record USBCheck() {
    }

    public record SetCANID(int id) {
    }
}

