/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.sim;

import com.revrobotics.spark.SparkBase;
import com.revrobotics.spark.SparkFlex;
import com.revrobotics.spark.SparkMax;
import edu.wpi.first.hal.SimBoolean;
import edu.wpi.first.wpilibj.simulation.SimDeviceSim;

public class SparkSimFaultManager {
    private SimBoolean m_otherFault;
    private SimBoolean m_motorTypeFault;
    private SimBoolean m_sensorFault;
    private SimBoolean m_canFault;
    private SimBoolean m_temperatureFault;
    private SimBoolean m_drvFault;
    private SimBoolean m_escEepromFault;
    private SimBoolean m_firmwareFault;
    private SimBoolean m_brownoutWarning;
    private SimBoolean m_overCurrentWarning;
    private SimBoolean m_escEepromWarning;
    private SimBoolean m_extEepromWarning;
    private SimBoolean m_sensorWarning;
    private SimBoolean m_stallWarning;
    private SimBoolean m_hasResetWarning;
    private SimBoolean m_otherWarning;
    private SimBoolean m_otherStickyFault;
    private SimBoolean m_motorTypeStickyFault;
    private SimBoolean m_sensorStickyFault;
    private SimBoolean m_canStickyFault;
    private SimBoolean m_temperatureStickyFault;
    private SimBoolean m_drvStickyFault;
    private SimBoolean m_escEepromStickyFault;
    private SimBoolean m_firmwareStickyFault;
    private SimBoolean m_brownoutStickyWarning;
    private SimBoolean m_overCurrentStickyWarning;
    private SimBoolean m_escEepromStickyWarning;
    private SimBoolean m_extEepromStickyWarning;
    private SimBoolean m_sensorStickyWarning;
    private SimBoolean m_stallStickyWarning;
    private SimBoolean m_hasResetStickyWarning;
    private SimBoolean m_otherStickyWarning;
    private SparkBase m_spark;
    private String simDeviceName;

    public SparkSimFaultManager(SparkMax motor) {
        this.simDeviceName = "SPARK MAX [" + motor.getDeviceId() + "] FAULT MANAGER";
        this.m_spark = motor;
        this.setupSimDevice();
    }

    public SparkSimFaultManager(SparkFlex motor) {
        this.simDeviceName = "SPARK Flex [" + motor.getDeviceId() + "] FAULT MANAGER";
        this.m_spark = motor;
        this.setupSimDevice();
    }

    private boolean setupSimDevice() {
        this.m_spark.createSimFaultManager();
        SimDeviceSim faultManager = new SimDeviceSim(this.simDeviceName);
        this.m_otherFault = faultManager.getBoolean("Other Fault");
        this.m_motorTypeFault = faultManager.getBoolean("Motor Type Fault");
        this.m_sensorFault = faultManager.getBoolean("Sensor Fault");
        this.m_canFault = faultManager.getBoolean("CAN Fault");
        this.m_temperatureFault = faultManager.getBoolean("Temperature Fault");
        this.m_drvFault = faultManager.getBoolean("DRV Fault");
        this.m_escEepromFault = faultManager.getBoolean("ESC Eeprom Fault");
        this.m_firmwareFault = faultManager.getBoolean("Firmware Fault");
        this.m_brownoutWarning = faultManager.getBoolean("Brownout Warning");
        this.m_overCurrentWarning = faultManager.getBoolean("Over Current Warning");
        this.m_escEepromWarning = faultManager.getBoolean("ESC Eeprom Warning");
        this.m_extEepromWarning = faultManager.getBoolean("EXT Eeprom Warning");
        this.m_sensorWarning = faultManager.getBoolean("Sensor Warning");
        this.m_stallWarning = faultManager.getBoolean("Stall Warning");
        this.m_hasResetWarning = faultManager.getBoolean("Has Reset Warning");
        this.m_otherWarning = faultManager.getBoolean("Other Warning");
        this.m_otherStickyFault = faultManager.getBoolean("Other Sticky Fault");
        this.m_motorTypeStickyFault = faultManager.getBoolean("Motor Type Sticky Fault");
        this.m_sensorStickyFault = faultManager.getBoolean("Sensor Sticky Fault");
        this.m_canStickyFault = faultManager.getBoolean("CAN Sticky Fault");
        this.m_temperatureStickyFault = faultManager.getBoolean("Temperature Sticky Fault");
        this.m_drvStickyFault = faultManager.getBoolean("DRV Sticky Fault");
        this.m_escEepromStickyFault = faultManager.getBoolean("ESC Eeprom Sticky Fault");
        this.m_firmwareStickyFault = faultManager.getBoolean("Firmware Sticky Fault");
        this.m_brownoutStickyWarning = faultManager.getBoolean("Brownout Sticky Warning");
        this.m_overCurrentStickyWarning = faultManager.getBoolean("Over Current Sticky Warning");
        this.m_escEepromStickyWarning = faultManager.getBoolean("ESC Eeprom Sticky Warning");
        this.m_extEepromStickyWarning = faultManager.getBoolean("EXT Eeprom Sticky Warning");
        this.m_sensorStickyWarning = faultManager.getBoolean("Sensor Sticky Warning");
        this.m_stallStickyWarning = faultManager.getBoolean("Stall Sticky Warning");
        this.m_hasResetStickyWarning = faultManager.getBoolean("Has Reset Sticky Warning");
        this.m_otherStickyWarning = faultManager.getBoolean("Other Sticky Warning");
        return this.m_otherFault == null;
    }

    private boolean checkAndSetupSimDevice() {
        if (this.m_otherFault == null) {
            return this.setupSimDevice();
        }
        return false;
    }

    public void setFaults(SparkBase.Faults faults) {
        if (this.checkAndSetupSimDevice()) {
            return;
        }
        this.m_otherFault.set(faults.other);
        this.m_motorTypeFault.set(faults.motorType);
        this.m_sensorFault.set(faults.sensor);
        this.m_canFault.set(faults.can);
        this.m_temperatureFault.set(faults.temperature);
        this.m_drvFault.set(faults.gateDriver);
        this.m_escEepromFault.set(faults.escEeprom);
        this.m_firmwareFault.set(faults.firmware);
    }

    public void setStickyFaults(SparkBase.Faults faults) {
        if (this.checkAndSetupSimDevice()) {
            return;
        }
        this.m_otherStickyFault.set(faults.other);
        this.m_motorTypeStickyFault.set(faults.motorType);
        this.m_sensorStickyFault.set(faults.sensor);
        this.m_canStickyFault.set(faults.can);
        this.m_temperatureStickyFault.set(faults.temperature);
        this.m_drvStickyFault.set(faults.gateDriver);
        this.m_escEepromStickyFault.set(faults.escEeprom);
        this.m_firmwareStickyFault.set(faults.firmware);
    }

    public void setWarnings(SparkBase.Warnings warnings) {
        if (this.checkAndSetupSimDevice()) {
            return;
        }
        this.m_brownoutWarning.set(warnings.brownout);
        this.m_overCurrentWarning.set(warnings.overcurrent);
        this.m_escEepromWarning.set(warnings.escEeprom);
        this.m_extEepromWarning.set(warnings.extEeprom);
        this.m_sensorWarning.set(warnings.sensor);
        this.m_stallWarning.set(warnings.stall);
        this.m_hasResetWarning.set(warnings.hasReset);
        this.m_otherWarning.set(warnings.other);
    }

    public void setStickyWarnings(SparkBase.Warnings warnings) {
        if (this.checkAndSetupSimDevice()) {
            return;
        }
        this.m_brownoutStickyWarning.set(warnings.brownout);
        this.m_overCurrentStickyWarning.set(warnings.overcurrent);
        this.m_escEepromStickyWarning.set(warnings.escEeprom);
        this.m_extEepromStickyWarning.set(warnings.extEeprom);
        this.m_sensorStickyWarning.set(warnings.sensor);
        this.m_stallStickyWarning.set(warnings.stall);
        this.m_hasResetStickyWarning.set(warnings.hasReset);
        this.m_otherStickyWarning.set(warnings.other);
    }
}

