/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark;

import com.revrobotics.REVLibError;
import com.revrobotics.RelativeEncoder;
import com.revrobotics.jni.CANSparkJNI;
import com.revrobotics.jni.REVLibJNI;
import com.revrobotics.spark.SparkAbsoluteEncoder;
import com.revrobotics.spark.SparkAnalogSensor;
import com.revrobotics.spark.SparkClosedLoopController;
import com.revrobotics.spark.SparkLimitSwitch;
import com.revrobotics.spark.SparkLowLevel;
import com.revrobotics.spark.SparkRelativeEncoder;
import com.revrobotics.spark.SparkSoftLimit;
import com.revrobotics.spark.config.SparkBaseConfig;
import edu.wpi.first.wpilibj.DriverStation;

public abstract class SparkBase
extends SparkLowLevel {
    protected SparkRelativeEncoder encoder;
    protected final Object encoderLock = new Object();
    protected SparkAnalogSensor analogSensor;
    protected final Object analogSensorLock = new Object();
    protected SparkAbsoluteEncoder absoluteEncoder;
    protected final Object absoluteEncoderLock = new Object();
    protected SparkClosedLoopController closedLoopController;
    protected final Object closedLoopControllerLock = new Object();
    protected SparkLimitSwitch forwardLimitSwitch;
    protected final Object forwardLimitSwitchLock = new Object();
    protected SparkLimitSwitch reverseLimitSwitch;
    protected final Object reverseLimitSwitchLock = new Object();
    protected SparkSoftLimit forwardSoftLimit;
    protected final Object forwardSoftLimitLock = new Object();
    protected SparkSoftLimit reverseSoftLimit;
    protected final Object reverseSoftLimitLock = new Object();
    private double m_setpoint = 0.0;

    public SparkBase(int deviceId, SparkLowLevel.MotorType type, SparkLowLevel.SparkModel model) {
        super(deviceId, type, model);
    }

    public void set(double speed) {
        this.throwIfClosed();
        this.m_setpoint = speed;
        this.setpointCommand(speed, ControlType.kDutyCycle);
    }

    public void setVoltage(double outputVolts) {
        this.throwIfClosed();
        this.setpointCommand(outputVolts, ControlType.kVoltage);
    }

    public double get() {
        this.throwIfClosed();
        return this.m_setpoint;
    }

    @Deprecated
    public void setInverted(boolean isInverted) {
        this.throwIfClosed();
        DriverStation.reportWarning((String)"The inversion setting should be set via a SparkMaxConfig or a SparkFlexConfig object", (boolean)true);
        CANSparkJNI.c_Spark_SetInverted(this.sparkHandle, isInverted);
    }

    @Deprecated
    public boolean getInverted() {
        this.throwIfClosed();
        DriverStation.reportWarning((String)"The inversion setting should be retrieved via the configAccessor field of a SparkMax or SparkFlex object", (boolean)true);
        return CANSparkJNI.c_Spark_GetInverted(this.sparkHandle);
    }

    public void disable() {
        this.throwIfClosed();
        this.set(0.0);
    }

    public void stopMotor() {
        this.throwIfClosed();
        this.set(0.0);
    }

    @Deprecated(since="2026", forRemoval=true)
    public REVLibError configure(SparkBaseConfig config, ResetMode resetMode, PersistMode persistMode) {
        this.throwIfClosed();
        REVLibError status = REVLibError.fromInt(CANSparkJNI.c_Spark_Configure(this.sparkHandle, config.flatten(), resetMode == ResetMode.kResetSafeParameters, persistMode == PersistMode.kPersistParameters));
        if (status != REVLibError.kOk) {
            if (status == REVLibError.kTimeout || status == REVLibError.kCannotPersistParametersWhileEnabled) {
                return status;
            }
            throw new IllegalStateException(REVLibJNI.c_REVLib_ErrorFromCode(status.value));
        }
        return status;
    }

    public REVLibError configure(SparkBaseConfig config, com.revrobotics.ResetMode resetMode, com.revrobotics.PersistMode persistMode) {
        this.throwIfClosed();
        REVLibError status = REVLibError.fromInt(CANSparkJNI.c_Spark_Configure(this.sparkHandle, config.flatten(), resetMode == com.revrobotics.ResetMode.kResetSafeParameters, persistMode == com.revrobotics.PersistMode.kPersistParameters));
        if (status != REVLibError.kOk) {
            if (status == REVLibError.kTimeout || status == REVLibError.kCannotPersistParametersWhileEnabled) {
                return status;
            }
            throw new IllegalStateException(REVLibJNI.c_REVLib_ErrorFromCode(status.value));
        }
        return status;
    }

    @Deprecated(since="2026", forRemoval=true)
    public REVLibError configureAsync(SparkBaseConfig config, ResetMode resetMode, PersistMode persistMode) {
        this.throwIfClosed();
        return REVLibError.fromInt(CANSparkJNI.c_Spark_ConfigureAsync(this.sparkHandle, config.flatten(), resetMode == ResetMode.kResetSafeParameters, persistMode == PersistMode.kPersistParameters));
    }

    public REVLibError configureAsync(SparkBaseConfig config, com.revrobotics.ResetMode resetMode, com.revrobotics.PersistMode persistMode) {
        this.throwIfClosed();
        return REVLibError.fromInt(CANSparkJNI.c_Spark_ConfigureAsync(this.sparkHandle, config.flatten(), resetMode == com.revrobotics.ResetMode.kResetSafeParameters, persistMode == com.revrobotics.PersistMode.kPersistParameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelativeEncoder getEncoder() {
        this.throwIfClosed();
        Object object = this.encoderLock;
        synchronized (object) {
            if (this.encoder == null) {
                this.encoder = new SparkRelativeEncoder(this);
            }
            return this.encoder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparkAnalogSensor getAnalog() {
        this.throwIfClosed();
        Object object = this.analogSensorLock;
        synchronized (object) {
            if (this.analogSensor == null) {
                this.analogSensor = new SparkAnalogSensor(this);
            }
            return this.analogSensor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparkAbsoluteEncoder getAbsoluteEncoder() {
        this.throwIfClosed();
        Object object = this.absoluteEncoderLock;
        synchronized (object) {
            if (this.absoluteEncoder == null) {
                this.absoluteEncoder = new SparkAbsoluteEncoder(this);
            }
            return this.absoluteEncoder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparkClosedLoopController getClosedLoopController() {
        this.throwIfClosed();
        Object object = this.closedLoopControllerLock;
        synchronized (object) {
            if (this.closedLoopController == null) {
                this.closedLoopController = new SparkClosedLoopController(this);
            }
            return this.closedLoopController;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparkLimitSwitch getForwardLimitSwitch() {
        this.throwIfClosed();
        Object object = this.forwardLimitSwitchLock;
        synchronized (object) {
            if (this.forwardLimitSwitch == null) {
                this.forwardLimitSwitch = new SparkLimitSwitch(this, SparkLimitSwitch.Direction.kForward);
            }
            return this.forwardLimitSwitch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparkLimitSwitch getReverseLimitSwitch() {
        this.throwIfClosed();
        Object object = this.reverseLimitSwitchLock;
        synchronized (object) {
            if (this.reverseLimitSwitch == null) {
                this.reverseLimitSwitch = new SparkLimitSwitch(this, SparkLimitSwitch.Direction.kReverse);
            }
            return this.reverseLimitSwitch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparkSoftLimit getForwardSoftLimit() {
        this.throwIfClosed();
        Object object = this.forwardSoftLimitLock;
        synchronized (object) {
            if (this.forwardSoftLimit == null) {
                this.forwardSoftLimit = new SparkSoftLimit(this, SparkSoftLimit.SoftLimitDirection.kForward);
            }
            return this.forwardSoftLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparkSoftLimit getReverseSoftLimit() {
        this.throwIfClosed();
        Object object = this.reverseSoftLimitLock;
        synchronized (object) {
            if (this.reverseSoftLimit == null) {
                this.reverseSoftLimit = new SparkSoftLimit(this, SparkSoftLimit.SoftLimitDirection.kReverse);
            }
            return this.reverseSoftLimit;
        }
    }

    int getMotorInterface() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetMotorInterface(this.sparkHandle);
    }

    public REVLibError resumeFollowerMode() {
        this.throwIfClosed();
        return REVLibError.fromInt(CANSparkJNI.c_Spark_StartFollowerMode(this.sparkHandle));
    }

    public REVLibError resumeFollowerModeAsync() {
        this.throwIfClosed();
        return REVLibError.fromInt(CANSparkJNI.c_Spark_StartFollowerModeAsync(this.sparkHandle));
    }

    public REVLibError pauseFollowerMode() {
        this.throwIfClosed();
        return REVLibError.fromInt(CANSparkJNI.c_Spark_StopFollowerMode(this.sparkHandle));
    }

    public REVLibError pauseFollowerModeAsync() {
        this.throwIfClosed();
        return REVLibError.fromInt(CANSparkJNI.c_Spark_StopFollowerModeAsync(this.sparkHandle));
    }

    public boolean isFollower() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_IsFollower(this.sparkHandle);
    }

    public boolean hasActiveFault() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetFaults(this.sparkHandle) != 0;
    }

    public boolean hasStickyFault() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetStickyFaults(this.sparkHandle) != 0;
    }

    public boolean hasActiveWarning() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetWarnings(this.sparkHandle) != 0;
    }

    public boolean hasStickyWarning() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetStickyWarnings(this.sparkHandle) != 0;
    }

    public Faults getFaults() {
        this.throwIfClosed();
        return new Faults(CANSparkJNI.c_Spark_GetFaults(this.sparkHandle));
    }

    public Faults getStickyFaults() {
        this.throwIfClosed();
        return new Faults(CANSparkJNI.c_Spark_GetStickyFaults(this.sparkHandle));
    }

    public Warnings getWarnings() {
        this.throwIfClosed();
        return new Warnings(CANSparkJNI.c_Spark_GetWarnings(this.sparkHandle));
    }

    public Warnings getStickyWarnings() {
        this.throwIfClosed();
        return new Warnings(CANSparkJNI.c_Spark_GetStickyWarnings(this.sparkHandle));
    }

    public double getBusVoltage() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetBusVoltage(this.sparkHandle);
    }

    public double getAppliedOutput() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetAppliedOutput(this.sparkHandle);
    }

    public double getOutputCurrent() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetOutputCurrent(this.sparkHandle);
    }

    public double getMotorTemperature() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetMotorTemperature(this.sparkHandle);
    }

    public REVLibError clearFaults() {
        this.throwIfClosed();
        return REVLibError.fromInt(CANSparkJNI.c_Spark_ClearFaults(this.sparkHandle));
    }

    public REVLibError setCANTimeout(int milliseconds) {
        this.throwIfClosed();
        return REVLibError.fromInt(CANSparkJNI.c_Spark_SetCANTimeout(this.sparkHandle, milliseconds));
    }

    public REVLibError getLastError() {
        this.throwIfClosed();
        return REVLibError.fromInt(CANSparkJNI.c_Spark_GetLastError(this.sparkHandle));
    }

    SparkLowLevel.SparkModel getSparkModel() {
        this.throwIfClosed();
        int model = CANSparkJNI.c_Spark_GetSparkModel(this.sparkHandle);
        return SparkLowLevel.SparkModel.fromId(model);
    }

    public static enum ControlType {
        kDutyCycle(0),
        kVelocity(1),
        kVoltage(2),
        kPosition(3),
        kCurrent(4),
        kMAXMotionPositionControl(5),
        kMAXMotionVelocityControl(6);

        public final int value;

        private ControlType(int value) {
            this.value = value;
        }
    }

    @Deprecated(since="2026", forRemoval=true)
    public static enum ResetMode {
        kNoResetSafeParameters(0),
        kResetSafeParameters(1);

        public final int value;

        private ResetMode(int value) {
            this.value = value;
        }
    }

    @Deprecated(since="2026", forRemoval=true)
    public static enum PersistMode {
        kNoPersistParameters(0),
        kPersistParameters(1);

        public final int value;

        private PersistMode(int value) {
            this.value = value;
        }
    }

    public static class Faults {
        public final boolean other;
        public final boolean motorType;
        public final boolean sensor;
        public final boolean can;
        public final boolean temperature;
        public final boolean gateDriver;
        public final boolean escEeprom;
        public final boolean firmware;
        public final int rawBits;

        public Faults(int faults) {
            this.rawBits = faults;
            this.other = (faults & 1) != 0;
            this.motorType = (faults & 2) != 0;
            this.sensor = (faults & 4) != 0;
            this.can = (faults & 8) != 0;
            this.temperature = (faults & 0x10) != 0;
            this.gateDriver = (faults & 0x20) != 0;
            this.escEeprom = (faults & 0x40) != 0;
            this.firmware = (faults & 0x80) != 0;
        }
    }

    public static class Warnings {
        public final boolean brownout;
        public final boolean overcurrent;
        public final boolean escEeprom;
        public final boolean extEeprom;
        public final boolean sensor;
        public final boolean stall;
        public final boolean hasReset;
        public final boolean other;
        public final int rawBits;

        public Warnings(int warnings) {
            this.rawBits = warnings;
            this.brownout = (warnings & 1) != 0;
            this.overcurrent = (warnings & 2) != 0;
            this.escEeprom = (warnings & 4) != 0;
            this.extEeprom = (warnings & 8) != 0;
            this.sensor = (warnings & 0x10) != 0;
            this.stall = (warnings & 0x20) != 0;
            this.hasReset = (warnings & 0x40) != 0;
            this.other = (warnings & 0x80) != 0;
        }
    }

    static enum DataPortConfig {
        kNone(-1, "none"),
        kLimitSwitchesAndAbsoluteEncoder(0, "limit switch and/or absolute encoder"),
        kAltEncoder(1, "alternate encoder");

        final int m_value;
        final String m_name;

        private DataPortConfig(int value, String name) {
            this.m_value = value;
            this.m_name = name;
        }

        public static DataPortConfig fromInt(int id) {
            for (DataPortConfig type : DataPortConfig.values()) {
                if (type.m_value != id) continue;
                return type;
            }
            return kNone;
        }
    }
}

