/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark;

import com.revrobotics.PersistMode;
import com.revrobotics.REVLibError;
import com.revrobotics.RelativeEncoder;
import com.revrobotics.ResetMode;
import com.revrobotics.jni.CANSparkJNI;
import com.revrobotics.spark.SparkAbsoluteEncoder;
import com.revrobotics.spark.SparkBase;
import com.revrobotics.spark.SparkLimitSwitch;
import com.revrobotics.spark.SparkLowLevel;
import com.revrobotics.spark.SparkMaxAlternateEncoder;
import com.revrobotics.spark.config.SparkBaseConfig;
import com.revrobotics.spark.config.SparkMaxConfigAccessor;
import edu.wpi.first.wpilibj.DriverStation;

public class SparkMax
extends SparkBase {
    private SparkMaxAlternateEncoder altEncoder;
    private final Object altEncoderLock = new Object();
    public final SparkMaxConfigAccessor configAccessor = new SparkMaxConfigAccessor(this.sparkHandle);

    public SparkMax(int deviceId, SparkLowLevel.MotorType type) {
        super(deviceId, type, SparkLowLevel.SparkModel.SparkMax);
        if (CANSparkJNI.c_Spark_GetSparkModel(this.sparkHandle) != SparkLowLevel.SparkModel.SparkMax.id) {
            DriverStation.reportWarning((String)("CANSparkMax object created for CAN ID " + deviceId + ", which is not a SPARK MAX. Some functionalities may not work."), (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated(since="2026", forRemoval=true)
    public REVLibError configure(SparkBaseConfig config, SparkBase.ResetMode resetMode, SparkBase.PersistMode persistMode) {
        REVLibError status = super.configure(config, resetMode, persistMode);
        Object object = this.altEncoderLock;
        synchronized (object) {
            if (this.altEncoder != null) {
                this.checkDataPortAlternateEncoder();
            }
        }
        object = this.absoluteEncoderLock;
        synchronized (object) {
            if (this.absoluteEncoder != null) {
                this.checkDataPortAbsoluteEncoder();
            }
        }
        object = this.forwardLimitSwitchLock;
        synchronized (object) {
            if (this.forwardLimitSwitch != null) {
                this.checkDataPortLimitSwitch();
            }
        }
        object = this.reverseLimitSwitchLock;
        synchronized (object) {
            if (this.reverseLimitSwitch != null) {
                this.checkDataPortLimitSwitch();
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REVLibError configure(SparkBaseConfig config, ResetMode resetMode, PersistMode persistMode) {
        REVLibError status = super.configure(config, resetMode, persistMode);
        Object object = this.altEncoderLock;
        synchronized (object) {
            if (this.altEncoder != null) {
                this.checkDataPortAlternateEncoder();
            }
        }
        object = this.absoluteEncoderLock;
        synchronized (object) {
            if (this.absoluteEncoder != null) {
                this.checkDataPortAbsoluteEncoder();
            }
        }
        object = this.forwardLimitSwitchLock;
        synchronized (object) {
            if (this.forwardLimitSwitch != null) {
                this.checkDataPortLimitSwitch();
            }
        }
        object = this.reverseLimitSwitchLock;
        synchronized (object) {
            if (this.reverseLimitSwitch != null) {
                this.checkDataPortLimitSwitch();
            }
        }
        return status;
    }

    private void checkDataPortAlternateEncoder() {
        this.throwIfClosed();
        if (CANSparkJNI.c_Spark_IsDataPortConfigured(this.sparkHandle) && CANSparkJNI.c_Spark_GetDataPortConfig(this.sparkHandle) != DataPortConfig.kAlternateEncoder.value) {
            throw new IllegalStateException("The SPARK MAX is not configured to use an alternate encoder.");
        }
    }

    private void checkDataPortAbsoluteEncoder() {
        this.throwIfClosed();
        if (CANSparkJNI.c_Spark_IsDataPortConfigured(this.sparkHandle) && CANSparkJNI.c_Spark_GetDataPortConfig(this.sparkHandle) != DataPortConfig.kDefault.value) {
            throw new IllegalStateException("The SPARK MAX is not configured to use an absolute encoder.");
        }
    }

    private void checkDataPortLimitSwitch() {
        this.throwIfClosed();
        if (CANSparkJNI.c_Spark_IsDataPortConfigured(this.sparkHandle) && CANSparkJNI.c_Spark_GetDataPortConfig(this.sparkHandle) != DataPortConfig.kDefault.value) {
            throw new IllegalStateException("The SPARK MAX is not configured to use limit switches.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelativeEncoder getAlternateEncoder() {
        this.checkDataPortAlternateEncoder();
        Object object = this.altEncoderLock;
        synchronized (object) {
            if (this.altEncoder == null) {
                this.altEncoder = new SparkMaxAlternateEncoder(this);
            }
            return this.altEncoder;
        }
    }

    @Override
    public SparkAbsoluteEncoder getAbsoluteEncoder() {
        this.checkDataPortAbsoluteEncoder();
        return super.getAbsoluteEncoder();
    }

    @Override
    public SparkLimitSwitch getForwardLimitSwitch() {
        this.checkDataPortLimitSwitch();
        return super.getForwardLimitSwitch();
    }

    @Override
    public SparkLimitSwitch getReverseLimitSwitch() {
        this.checkDataPortLimitSwitch();
        return super.getReverseLimitSwitch();
    }

    static enum DataPortConfig {
        kDefault(0),
        kAlternateEncoder(1);

        public final int value;

        private DataPortConfig(int value) {
            this.value = value;
        }
    }
}

