/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark.config;

import com.revrobotics.config.BaseConfig;
import com.revrobotics.spark.FeedbackSensor;
import com.revrobotics.spark.config.SparkMaxConfig;
import com.revrobotics.spark.config.SparkParameters;

public class LimitSwitchConfig
extends BaseConfig {
    public LimitSwitchConfig() {
        super(BaseConfig.CANType.kSpark);
    }

    public LimitSwitchConfig apply(LimitSwitchConfig config) {
        super.apply(config);
        return this;
    }

    public LimitSwitchConfig setSparkMaxDataPortConfig() {
        this.putParameter(SparkParameters.kCompatibilityPortConfig.value, SparkMaxConfig.DataPortConfig.kLimitSwitchesAndAbsoluteEncoder.value);
        return this;
    }

    @Deprecated
    public LimitSwitchConfig forwardLimitSwitchEnabled(boolean enabled) {
        return this.forwardLimitSwitchTriggerBehavior(enabled ? Behavior.kStopMovingMotor : Behavior.kKeepMovingMotor);
    }

    public LimitSwitchConfig forwardLimitSwitchTriggerBehavior(Behavior behavior) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kHardLimitFwdEn.value, behavior.value);
        return this;
    }

    public LimitSwitchConfig forwardLimitSwitchType(Type type) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kLimitSwitchFwdPolarity.value, type == Type.kNormallyClosed);
        return this;
    }

    public LimitSwitchConfig forwardLimitSwitchPosition(double position) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kLimitSwitchFwdPosition.value, (float)position);
        return this;
    }

    @Deprecated
    public LimitSwitchConfig reverseLimitSwitchEnabled(boolean enabled) {
        return this.reverseLimitSwitchTriggerBehavior(enabled ? Behavior.kStopMovingMotor : Behavior.kKeepMovingMotor);
    }

    public LimitSwitchConfig reverseLimitSwitchTriggerBehavior(Behavior behavior) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kHardLimitRevEn.value, behavior.value);
        return this;
    }

    public LimitSwitchConfig reverseLimitSwitchType(Type type) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kLimitSwitchRevPolarity.value, type == Type.kNormallyClosed);
        return this;
    }

    public LimitSwitchConfig reverseLimitSwitchPosition(double position) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kLimitSwitchRevPosition.value, (float)position);
        return this;
    }

    public LimitSwitchConfig limitSwitchPositionSensor(FeedbackSensor sensor) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kLimitSwitchPositionSensor.value, sensor.value);
        return this;
    }

    public static enum Behavior {
        kKeepMovingMotor(0),
        kStopMovingMotor(1),
        kKeepMovingMotorAndSetPosition(2),
        kStopMovingMotorAndSetPosition(3);

        public final int value;

        private Behavior(int value) {
            this.value = value;
        }

        public static Behavior fromId(int id) {
            switch (id) {
                case 0: {
                    return kKeepMovingMotor;
                }
                case 1: {
                    return kStopMovingMotor;
                }
                case 2: {
                    return kKeepMovingMotorAndSetPosition;
                }
                case 3: {
                    return kStopMovingMotorAndSetPosition;
                }
            }
            return kStopMovingMotor;
        }
    }

    public static enum Type {
        kNormallyOpen(0),
        kNormallyClosed(1);

        public final int value;

        private Type(int value) {
            this.value = value;
        }

        public static Type fromId(int id) {
            switch (id) {
                case 1: {
                    return kNormallyClosed;
                }
            }
            return kNormallyOpen;
        }
    }
}

