/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark.config;

import com.revrobotics.config.BaseConfig;
import com.revrobotics.spark.SparkBase;
import com.revrobotics.spark.config.AbsoluteEncoderConfig;
import com.revrobotics.spark.config.AnalogSensorConfig;
import com.revrobotics.spark.config.ClosedLoopConfig;
import com.revrobotics.spark.config.EncoderConfig;
import com.revrobotics.spark.config.LimitSwitchConfig;
import com.revrobotics.spark.config.SignalsConfig;
import com.revrobotics.spark.config.SoftLimitConfig;
import com.revrobotics.spark.config.SparkParameters;

public abstract class SparkBaseConfig
extends BaseConfig {
    public final AbsoluteEncoderConfig absoluteEncoder = new AbsoluteEncoderConfig();
    public final AnalogSensorConfig analogSensor = new AnalogSensorConfig();
    public final EncoderConfig encoder = new EncoderConfig();
    public final LimitSwitchConfig limitSwitch = new LimitSwitchConfig();
    public final SoftLimitConfig softLimit = new SoftLimitConfig();
    public final ClosedLoopConfig closedLoop = new ClosedLoopConfig();
    public final SignalsConfig signals = new SignalsConfig();

    SparkBaseConfig() {
        super(BaseConfig.CANType.kSpark);
    }

    public SparkBaseConfig apply(SparkBaseConfig config) {
        super.apply(config);
        this.absoluteEncoder.apply(config.absoluteEncoder);
        this.analogSensor.apply(config.analogSensor);
        this.encoder.apply(config.encoder);
        this.limitSwitch.apply(config.limitSwitch);
        this.softLimit.apply(config.softLimit);
        this.closedLoop.apply(config.closedLoop);
        this.signals.apply(config.signals);
        return this;
    }

    public SparkBaseConfig apply(AbsoluteEncoderConfig config) {
        this.absoluteEncoder.apply(config);
        return this;
    }

    public SparkBaseConfig apply(AnalogSensorConfig config) {
        this.analogSensor.apply(config);
        return this;
    }

    public SparkBaseConfig apply(EncoderConfig config) {
        this.encoder.apply(config);
        return this;
    }

    public SparkBaseConfig apply(LimitSwitchConfig config) {
        this.limitSwitch.apply(config);
        return this;
    }

    public SparkBaseConfig apply(SoftLimitConfig config) {
        this.softLimit.apply(config);
        return this;
    }

    public SparkBaseConfig apply(ClosedLoopConfig config) {
        this.closedLoop.apply(config);
        return this;
    }

    public SparkBaseConfig apply(SignalsConfig config) {
        this.signals.apply(config);
        return this;
    }

    public SparkBaseConfig idleMode(IdleMode idleMode) {
        this.putParameter(SparkParameters.kIdleMode.value, idleMode.value);
        return this;
    }

    public SparkBaseConfig inverted(boolean inverted) {
        this.putParameter(SparkParameters.kInverted.value, inverted);
        return this;
    }

    public SparkBaseConfig smartCurrentLimit(int stallLimit) {
        return this.smartCurrentLimit(stallLimit, 0, 20000);
    }

    public SparkBaseConfig smartCurrentLimit(int stallLimit, int freeLimit) {
        return this.smartCurrentLimit(stallLimit, freeLimit, 20000);
    }

    public SparkBaseConfig smartCurrentLimit(int stallLimit, int freeLimit, int limitRpm) {
        this.putParameter(SparkParameters.kSmartCurrentStallLimit.value, stallLimit);
        this.putParameter(SparkParameters.kSmartCurrentFreeLimit.value, freeLimit);
        this.putParameter(SparkParameters.kSmartCurrentConfig.value, limitRpm);
        return this;
    }

    public SparkBaseConfig secondaryCurrentLimit(double limit) {
        return this.secondaryCurrentLimit(limit, 0);
    }

    public SparkBaseConfig secondaryCurrentLimit(double limit, int chopCycles) {
        this.putParameter(SparkParameters.kCurrentChop.value, (float)limit);
        this.putParameter(SparkParameters.kCurrentChopCycles.value, chopCycles);
        return this;
    }

    public SparkBaseConfig advanceCommutation(double byDegrees) {
        this.putParameter(SparkParameters.kCommutationAdvance.value, (float)byDegrees);
        return this;
    }

    public SparkBaseConfig openLoopRampRate(double rate) {
        if (rate != 0.0) {
            rate = 1.0 / rate;
        }
        this.putParameter(SparkParameters.kOpenLoopRampRate.value, (float)rate);
        return this;
    }

    public SparkBaseConfig closedLoopRampRate(double rate) {
        if (rate != 0.0) {
            rate = 1.0 / rate;
        }
        this.putParameter(SparkParameters.kClosedLoopRampRate.value, (float)rate);
        return this;
    }

    public SparkBaseConfig voltageCompensation(double nominalVoltage) {
        this.putParameter(SparkParameters.kCompensatedNominalVoltage.value, (float)nominalVoltage);
        this.putParameter(SparkParameters.kVoltageCompensationMode.value, 2);
        return this;
    }

    public SparkBaseConfig disableVoltageCompensation() {
        this.putParameter(SparkParameters.kVoltageCompensationMode.value, 0);
        return this;
    }

    public SparkBaseConfig follow(SparkBase leader) {
        return this.follow(leader.getDeviceId());
    }

    public SparkBaseConfig follow(SparkBase leader, boolean invert) {
        return this.follow(leader.getDeviceId(), invert);
    }

    public SparkBaseConfig follow(int leaderCanId) {
        return this.follow(leaderCanId, false);
    }

    public SparkBaseConfig follow(int leaderCanId, boolean invert) {
        this.putParameter(SparkParameters.kFollowerModeLeaderId.value, leaderCanId);
        this.putParameter(SparkParameters.kFollowerModeIsInverted.value, invert);
        return this;
    }

    public SparkBaseConfig disableFollowerMode() {
        this.putParameter(SparkParameters.kFollowerModeLeaderId.value, 0);
        this.putParameter(SparkParameters.kFollowerModeIsInverted.value, false);
        return this;
    }

    @Override
    public String flatten() {
        String flattenedString = "";
        flattenedString = flattenedString + super.flatten();
        flattenedString = flattenedString + this.absoluteEncoder.flatten();
        flattenedString = flattenedString + this.analogSensor.flatten();
        flattenedString = flattenedString + this.encoder.flatten();
        flattenedString = flattenedString + this.limitSwitch.flatten();
        flattenedString = flattenedString + this.softLimit.flatten();
        flattenedString = flattenedString + this.closedLoop.flatten();
        flattenedString = flattenedString + this.signals.flatten();
        return flattenedString;
    }

    public static enum IdleMode {
        kCoast(0),
        kBrake(1);

        public final int value;

        private IdleMode(int value) {
            this.value = value;
        }

        public static IdleMode fromId(int id) {
            if (id == 1) {
                return kBrake;
            }
            return kCoast;
        }
    }
}

