/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.web.accept.ApiVersionParser;

public class SemanticApiVersionParser
implements ApiVersionParser<Version> {
    private static final Pattern semanticVersionPattern = Pattern.compile("^(\\d+)(\\.(\\d+))?(\\.(\\d+))?$");

    @Override
    public Version parseVersion(String version) {
        Assert.notNull((Object)version, (String)"'version' is required");
        version = SemanticApiVersionParser.skipNonDigits(version);
        Matcher matcher = semanticVersionPattern.matcher(version);
        Assert.state((boolean)matcher.matches(), (String)"Invalid API version format");
        String major = matcher.group(1);
        String minor = matcher.group(3);
        String patch = matcher.group(5);
        return new Version(Integer.parseInt(major), minor != null ? Integer.parseInt(minor) : 0, patch != null ? Integer.parseInt(patch) : 0);
    }

    private static String skipNonDigits(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isDigit(value.charAt(i))) continue;
            return value.substring(i);
        }
        return "";
    }

    public static final class Version
    implements Comparable<Version> {
        private final int major;
        private final int minor;
        private final int patch;

        Version(int major, int minor, int patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }

        @Override
        public int compareTo(Version other) {
            int result = Integer.compare(this.major, other.major);
            if (result != 0) {
                return result;
            }
            result = Integer.compare(this.minor, other.minor);
            if (result != 0) {
                return result;
            }
            return Integer.compare(this.patch, other.patch);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (this == other) return true;
            if (!(other instanceof Version)) return false;
            Version otherVersion = (Version)other;
            if (this.major != otherVersion.major) return false;
            if (this.minor != otherVersion.minor) return false;
            if (this.patch != otherVersion.patch) return false;
            return true;
        }

        public int hashCode() {
            int result = this.major;
            result = 31 * result + this.minor;
            result = 31 * result + this.patch;
            return result;
        }

        public String toString() {
            return this.major + "." + this.minor + "." + this.patch;
        }
    }
}

