"use strict";(self.webpackChunkadvantagescope_docs=self.webpackChunkadvantagescope_docs||[]).push([[6106],{5617:(e,n,t)=>{t.r(n),t.d(n,{assets:()=>d,contentTitle:()=>c,default:()=>g,frontMatter:()=>l,metadata:()=>a,toc:()=>u});const a=JSON.parse('{"id":"more-features/urcl","title":"\ud83d\udcdd Unofficial REV-Compatible Logger","description":"Since REV does not provide an official method of automatically recording data from the Spark Max and Spark Flex, we have provided an unofficial alternative for Java and C++ called URCL (Unofficial REV-Compatible Logger). This enables live plotting and logging of all devices similar to CTRE\'s Tuner X plotting feature and Phoenix 6 signal logger.","source":"@site/docs/more-features/urcl.md","sourceDirName":"more-features","slug":"/more-features/urcl","permalink":"/more-features/urcl","draft":false,"unlisted":false,"tags":[],"version":"current","sidebarPosition":2,"frontMatter":{"sidebar_position":2},"sidebar":"sidebar","previous":{"title":"\ud83d\udca1 AdvantageScope Lite","permalink":"/more-features/advantagescope-lite"},"next":{"title":"\ud83d\udcd0 Coordinate Systems","permalink":"/more-features/coordinate-systems"}}');var o=t(4848),r=t(8453),s=t(1470),i=t(9365);const l={sidebar_position:2},c="\ud83d\udcdd Unofficial REV-Compatible Logger",d={},u=[{value:"Setup",id:"setup",level:2},{value:"SysId Usage",id:"sysid-usage",level:2}];function h(e){const n={a:"a",admonition:"admonition",code:"code",em:"em",h1:"h1",h2:"h2",header:"header",li:"li",ol:"ol",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,r.R)(),...e.components};return(0,o.jsxs)(o.Fragment,{children:[(0,o.jsx)(n.header,{children:(0,o.jsx)(n.h1,{id:"-unofficial-rev-compatible-logger",children:"\ud83d\udcdd Unofficial REV-Compatible Logger"})}),"\n",(0,o.jsxs)(n.p,{children:["Since REV does not provide an official method of automatically recording data from the Spark Max and Spark Flex, we have provided an unofficial alternative for Java and C++ called ",(0,o.jsx)(n.a,{href:"https://github.com/Mechanical-Advantage/URCL",children:"URCL"})," (",(0,o.jsx)(n.strong,{children:"U"}),"nofficial ",(0,o.jsx)(n.strong,{children:"R"}),"EV-",(0,o.jsx)(n.strong,{children:"C"}),"ompatible ",(0,o.jsx)(n.strong,{children:"L"}),"ogger). This enables live plotting and logging of all devices similar to CTRE's ",(0,o.jsx)(n.a,{href:"https://v6.docs.ctr-electronics.com/en/latest/docs/tuner/plotting.html",children:"Tuner X plotting feature"})," and ",(0,o.jsx)(n.a,{href:"https://pro.docs.ctr-electronics.com/en/latest/docs/api-reference/api-usage/signal-logging.html",children:"Phoenix 6 signal logger"}),"."]}),"\n",(0,o.jsxs)(n.p,{children:["After setup, periodic CAN frames from all Spark Max and Spark Flex devices are published to NetworkTables or DataLog. When using NetworkTables, WPILib's ",(0,o.jsx)(n.a,{href:"https://docs.wpilib.org/en/stable/docs/software/telemetry/datalog.html",children:"DataLogManager"})," can be used to capture the data to a log file. These frames are viewable in AdvantageScope (see ",(0,o.jsx)(n.a,{href:"/overview/log-files",children:"Managing Log Files"})," and ",(0,o.jsx)(n.a,{href:"/overview/live-sources",children:"Connecting to Live Sources"}),")."]}),"\n",(0,o.jsxs)(n.ul,{children:["\n",(0,o.jsxs)(n.li,{children:[(0,o.jsx)(n.strong,{children:"All signals"})," are captured automatically, with ",(0,o.jsx)(n.strong,{children:"no manual setup for new devices"}),"."]}),"\n",(0,o.jsxs)(n.li,{children:[(0,o.jsx)(n.strong,{children:"Every frame is captured"}),", even when the status frame period is faster than the robot loop cycle."]}),"\n",(0,o.jsxs)(n.li,{children:["Frames are logged with ",(0,o.jsx)(n.strong,{children:"timestamps based on the CAN RX time"}),", enabling more accurate acceleration characterization with ",(0,o.jsx)(n.a,{href:"https://docs.wpilib.org/en/stable/docs/software/pathplanning/system-identification/introduction.html",children:"SysId"}),' compared to traditional logging in user code (see "SysId Usage" below).']}),"\n",(0,o.jsxs)(n.li,{children:["Logging is ",(0,o.jsx)(n.strong,{children:"highly efficient"}),"; operations are threaded and run for under 80\xb5s per 20ms periodic cycle, even when logging a large number of devices."]}),"\n",(0,o.jsx)(n.li,{children:(0,o.jsx)(n.strong,{children:"All functions of REVLib are unaffected."})}),"\n"]}),"\n",(0,o.jsx)(n.admonition,{type:"info",children:(0,o.jsxs)(n.p,{children:["As this library is not an official REV tool, support queries should be directed to the URCL ",(0,o.jsx)(n.a,{href:"https://github.com/Mechanical-Advantage/URCL/issues",children:"issues page"})," or ",(0,o.jsx)(n.a,{href:"mailto:software@team6328.org",children:"software@team6328.org"})," rather than REV's support contact."]})}),"\n",(0,o.jsx)(n.h2,{id:"setup",children:"Setup"}),"\n",(0,o.jsxs)(n.p,{children:["Install the URCL vendordep by following the instructions to install ",(0,o.jsx)(n.a,{href:"https://docs.wpilib.org/en/stable/docs/software/vscode-overview/3rd-party-libraries.html",children:"3rd party libraries"})," using the dependency manager in VSCode. Alternatively, you can use the following vendor JSON URL:"]}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{children:"https://raw.githubusercontent.com/Mechanical-Advantage/URCL/main/URCL.json\n"})}),"\n",(0,o.jsxs)(n.p,{children:["URCL publishes to NetworkTables by default, where data can be saved to a log file by enabling WPILib's DataLogManager. Alternatively, URCL can log directly to a DataLog. The logger should be started in ",(0,o.jsx)(n.code,{children:"robotInit"}),", as shown below."]}),"\n",(0,o.jsxs)(s.A,{children:[(0,o.jsx)(i.A,{value:"java",label:"WPILib (Java)",default:!0,children:(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-java",children:"public Robot() {\n  // If publishing to NetworkTables and DataLog\n  DataLogManager.start();\n  URCL.start();\n\n  // If logging only to DataLog\n  URCL.start(DataLogManager.getLog());\n}\n"})})}),(0,o.jsx)(i.A,{value:"cpp",label:"WPILib (C++)",children:(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-cpp",children:'#include "frc/DataLogManager.h"\n#include "URCL.h"\n\nRobot::Robot() {\n  // If publishing to NetworkTables and DataLog\n  frc::DataLogManager::Start();\n  URCL::Start();\n\n  // If logging only to DataLog\n  URCL::Start(frc::DataLogManager::GetLog());\n}\n'})})}),(0,o.jsx)(i.A,{value:"python",label:"Python",children:(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-python",children:"import urcl\nimport wpilib\n\nclass Robot(wpilib.TimedRobot):\n    def robotInit(self):\n        # If publishing to NetworkTables and DataLog\n        wpilib.DataLogManager.start()\n        urcl.start()\n\n        # If logging only to DataLog\n        urcl.start(wpilib.DataLogManager.getLog())\n"})})}),(0,o.jsxs)(i.A,{value:"advantagekit",label:"AdvantageKit",children:[(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-java",children:"public Robot() {\n  // ...\n  Logger.registerURCL(URCL.startExternal());\n  Logger.start();\n}\n"})}),(0,o.jsx)(n.admonition,{type:"warning",children:(0,o.jsxs)(n.p,{children:["URCL compatibility with AdvantageKit is provided for convenience only; the data recorded to the log is NOT available in replay. ",(0,o.jsx)(n.strong,{children:"REV motor controllers must still be part of an IO implementation with defined inputs to support replay"}),"."]})})]})]}),"\n",(0,o.jsxs)(n.p,{children:["To more easily identify devices in the log, CAN IDs can be assigned to aliases by passing a map object to the ",(0,o.jsx)(n.code,{children:"start()"})," or ",(0,o.jsx)(n.code,{children:"startExternal()"})," method. The keys are CAN IDs and the values are strings for the names to use in the log. Any devices not assigned an alias will be logged using their default names."]}),"\n",(0,o.jsxs)(n.admonition,{type:"warning",children:[(0,o.jsxs)(n.p,{children:["To minimize CAN utilization, most status frames for Spark devices are ",(0,o.jsx)(n.strong,{children:"disabled by default"})," until an associated getter method is called. Any data included in these disabled status frames will not be available in the URCL log."]}),(0,o.jsxs)(n.p,{children:["For more details, check the ",(0,o.jsx)(n.a,{href:"https://docs.revrobotics.com/revlib/24-to-25#setting-status-periods",children:"REVLib documentation"}),". We recommend using the ",(0,o.jsx)(n.a,{href:"https://codedocs.revrobotics.com/java/com/revrobotics/spark/config/signalsconfig",children:(0,o.jsx)(n.code,{children:"SignalsConfig"})})," when configuring the Spark to manually enable any signals you wish to include in the log file."]})]}),"\n",(0,o.jsx)(n.h2,{id:"sysid-usage",children:"SysId Usage"}),"\n",(0,o.jsxs)(n.ol,{children:["\n",(0,o.jsxs)(n.li,{children:["After setting up URCL as shown above, configure the SysId routine using ",(0,o.jsx)(n.code,{children:"null"})," for the mechanism log consumer. An example is shown below for Java. This configuration can be performed within the subsystem class."]}),"\n"]}),"\n",(0,o.jsxs)(s.A,{groupId:"library",children:[(0,o.jsx)(i.A,{value:"WPILib",label:"WPILib",default:!0,children:(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-java",children:"// Create the SysId routine\nvar sysIdRoutine = new SysIdRoutine(\n  new SysIdRoutine.Config(),\n  new SysIdRoutine.Mechanism(\n    (voltage) -> subsystem.runVolts(voltage.in(Volts)),\n    null, // No log consumer, since data is recorded by URCL\n    subsystem\n  )\n);\n\n// The methods below return Command objects\nsysIdRoutine.quasistatic(SysIdRoutine.Direction.kForward);\nsysIdRoutine.quasistatic(SysIdRoutine.Direction.kReverse);\nsysIdRoutine.dynamic(SysIdRoutine.Direction.kForward);\nsysIdRoutine.dynamic(SysIdRoutine.Direction.kReverse);\n"})})}),(0,o.jsx)(i.A,{value:"advantagekit",label:"AdvantageKit",children:(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-java",children:'// Create the SysId routine\nvar sysIdRoutine = new SysIdRoutine(\n  new SysIdRoutine.Config(\n    null, null, null,\n    (state) -> Logger.recordOutput("SysIdTestState", state.toString())\n  ),\n  new SysIdRoutine.Mechanism(\n    (voltage) -> subsystem.runVolts(voltage.in(Volts)),\n    null, // No log consumer, since data is recorded by URCL\n    subsystem\n  )\n);\n\n// The methods below return Command objects\nsysIdRoutine.quasistatic(SysIdRoutine.Direction.kForward);\nsysIdRoutine.quasistatic(SysIdRoutine.Direction.kReverse);\nsysIdRoutine.dynamic(SysIdRoutine.Direction.kForward);\nsysIdRoutine.dynamic(SysIdRoutine.Direction.kReverse);\n'})})})]}),"\n",(0,o.jsxs)(n.ol,{start:"2",children:["\n",(0,o.jsxs)(n.li,{children:["\n",(0,o.jsx)(n.p,{children:"Run the SysId routine on the robot. The SysId commands can be configured as auto routines or connected to a button trigger."}),"\n"]}),"\n",(0,o.jsxs)(n.li,{children:["\n",(0,o.jsxs)(n.p,{children:["Download the log file and open it in AdvantageScope. In the menu bar, go to ",(0,o.jsx)(n.code,{children:"File"})," > ",(0,o.jsx)(n.code,{children:"Export Data..."}),'. Set the format to "WPILOG" and the field set to "Include Generated". Click the save icon and choose a location to save the log.']}),"\n"]}),"\n"]}),"\n",(0,o.jsx)(n.admonition,{type:"warning",children:(0,o.jsxs)(n.p,{children:["The log file from the robot must be opened and exported by AdvantageScope ",(0,o.jsx)(n.em,{children:"before opening it using the SysId analyzer"}),". This is required to convert the CAN data recorded by URCL to a format compatible with SysId."]})}),"\n",(0,o.jsxs)(n.ol,{start:"3",children:["\n",(0,o.jsxs)(n.li,{children:["\n",(0,o.jsx)(n.p,{children:'Open the SysId analyzer by searching for "WPILib: Start Tool" in the VSCode command palette and choosing "SysId" (or using the desktop launcher on Windows). Open the exported log file by clicking "Open data log file..."'}),"\n"]}),"\n",(0,o.jsxs)(n.li,{children:["\n",(0,o.jsx)(n.p,{children:"Choose the following fields below to run the analysis using the default encoder. Position and velocity data from secondary encoders can also be used (alternate, external, analog, absolute, etc)."}),"\n",(0,o.jsxs)(n.ul,{children:["\n",(0,o.jsx)(n.li,{children:'Position = "NT:/URCL/<Device>/MotorPositionRotations"'}),"\n",(0,o.jsx)(n.li,{children:'Velocity = "NT:/URCL/<Device>/MotorVelocityRPM"'}),"\n",(0,o.jsx)(n.li,{children:'Voltage = "NT:/URCL/<Device>/AppliedOutputVoltage"'}),"\n"]}),"\n"]}),"\n"]}),"\n",(0,o.jsx)(n.admonition,{type:"tip",children:(0,o.jsxs)(n.p,{children:["The gains produced by SysId will use the units the Spark Max/Flex is configured to report (using ",(0,o.jsx)(n.a,{href:"https://codedocs.revrobotics.com/java/com/revrobotics/relativeencoder#setPositionConversionFactor(double)",children:(0,o.jsx)(n.code,{children:"setPositionConversionFactor"})})," and ",(0,o.jsx)(n.a,{href:"https://codedocs.revrobotics.com/java/com/revrobotics/relativeencoder#setVelocityConversionFactor(double)",children:(0,o.jsx)(n.code,{children:"setVelocityConversionFactor"})}),"). By default, these are rotations and RPM with no gearing applied. If the units used when recording data do not match the desired units, the scaling can be adjusted in SysId during analysis."]})})]})}function g(e={}){const{wrapper:n}={...(0,r.R)(),...e.components};return n?(0,o.jsx)(n,{...e,children:(0,o.jsx)(h,{...e})}):h(e)}},9365:(e,n,t)=>{t.d(n,{A:()=>s});t(6540);var a=t(4164);const o={tabItem:"tabItem_Ymn6"};var r=t(4848);function s({children:e,hidden:n,className:t}){return(0,r.jsx)("div",{role:"tabpanel",className:(0,a.A)(o.tabItem,t),hidden:n,children:e})}},1470:(e,n,t)=>{t.d(n,{A:()=>w});var a=t(6540),o=t(4164),r=t(3104),s=t(6347),i=t(205),l=t(7485),c=t(1682),d=t(679);function u(e){return a.Children.toArray(e).filter((e=>"\n"!==e)).map((e=>{if(!e||(0,a.isValidElement)(e)&&function(e){const{props:n}=e;return!!n&&"object"==typeof n&&"value"in n}(e))return e;throw new Error(`Docusaurus error: Bad <Tabs> child <${"string"==typeof e.type?e.type:e.type.name}>: all children of the <Tabs> component should be <TabItem>, and every <TabItem> should have a unique "value" prop.`)}))?.filter(Boolean)??[]}function h(e){const{values:n,children:t}=e;return(0,a.useMemo)((()=>{const e=n??function(e){return u(e).map((({props:{value:e,label:n,attributes:t,default:a}})=>({value:e,label:n,attributes:t,default:a})))}(t);return function(e){const n=(0,c.XI)(e,((e,n)=>e.value===n.value));if(n.length>0)throw new Error(`Docusaurus error: Duplicate values "${n.map((e=>e.value)).join(", ")}" found in <Tabs>. Every value needs to be unique.`)}(e),e}),[n,t])}function g({value:e,tabValues:n}){return n.some((n=>n.value===e))}function p({queryString:e=!1,groupId:n}){const t=(0,s.W6)(),o=function({queryString:e=!1,groupId:n}){if("string"==typeof e)return e;if(!1===e)return null;if(!0===e&&!n)throw new Error('Docusaurus error: The <Tabs> component groupId prop is required if queryString=true, because this value is used as the search param name. You can also provide an explicit value such as queryString="my-search-param".');return n??null}({queryString:e,groupId:n});return[(0,l.aZ)(o),(0,a.useCallback)((e=>{if(!o)return;const n=new URLSearchParams(t.location.search);n.set(o,e),t.replace({...t.location,search:n.toString()})}),[o,t])]}function f(e){const{defaultValue:n,queryString:t=!1,groupId:o}=e,r=h(e),[s,l]=(0,a.useState)((()=>function({defaultValue:e,tabValues:n}){if(0===n.length)throw new Error("Docusaurus error: the <Tabs> component requires at least one <TabItem> children component");if(e){if(!g({value:e,tabValues:n}))throw new Error(`Docusaurus error: The <Tabs> has a defaultValue "${e}" but none of its children has the corresponding value. Available values are: ${n.map((e=>e.value)).join(", ")}. If you intend to show no default tab, use defaultValue={null} instead.`);return e}const t=n.find((e=>e.default))??n[0];if(!t)throw new Error("Unexpected error: 0 tabValues");return t.value}({defaultValue:n,tabValues:r}))),[c,u]=p({queryString:t,groupId:o}),[f,m]=function({groupId:e}){const n=function(e){return e?`docusaurus.tab.${e}`:null}(e),[t,o]=(0,d.Dv)(n);return[t,(0,a.useCallback)((e=>{n&&o.set(e)}),[n,o])]}({groupId:o}),b=(()=>{const e=c??f;return g({value:e,tabValues:r})?e:null})();(0,i.A)((()=>{b&&l(b)}),[b]);return{selectedValue:s,selectValue:(0,a.useCallback)((e=>{if(!g({value:e,tabValues:r}))throw new Error(`Can't select invalid tab value=${e}`);l(e),u(e),m(e)}),[u,m,r]),tabValues:r}}var m=t(2303);const b={tabList:"tabList__CuJ",tabItem:"tabItem_LNqP"};var v=t(4848);function y({className:e,block:n,selectedValue:t,selectValue:a,tabValues:s}){const i=[],{blockElementScrollPositionUntilNextRender:l}=(0,r.a_)(),c=e=>{const n=e.currentTarget,o=i.indexOf(n),r=s[o].value;r!==t&&(l(n),a(r))},d=e=>{let n=null;switch(e.key){case"Enter":c(e);break;case"ArrowRight":{const t=i.indexOf(e.currentTarget)+1;n=i[t]??i[0];break}case"ArrowLeft":{const t=i.indexOf(e.currentTarget)-1;n=i[t]??i[i.length-1];break}}n?.focus()};return(0,v.jsx)("ul",{role:"tablist","aria-orientation":"horizontal",className:(0,o.A)("tabs",{"tabs--block":n},e),children:s.map((({value:e,label:n,attributes:a})=>(0,v.jsx)("li",{role:"tab",tabIndex:t===e?0:-1,"aria-selected":t===e,ref:e=>{i.push(e)},onKeyDown:d,onClick:c,...a,className:(0,o.A)("tabs__item",b.tabItem,a?.className,{"tabs__item--active":t===e}),children:n??e},e)))})}function x({lazy:e,children:n,selectedValue:t}){const r=(Array.isArray(n)?n:[n]).filter(Boolean);if(e){const e=r.find((e=>e.props.value===t));return e?(0,a.cloneElement)(e,{className:(0,o.A)("margin-top--md",e.props.className)}):null}return(0,v.jsx)("div",{className:"margin-top--md",children:r.map(((e,n)=>(0,a.cloneElement)(e,{key:n,hidden:e.props.value!==t})))})}function j(e){const n=f(e);return(0,v.jsxs)("div",{className:(0,o.A)("tabs-container",b.tabList),children:[(0,v.jsx)(y,{...n,...e}),(0,v.jsx)(x,{...n,...e})]})}function w(e){const n=(0,m.A)();return(0,v.jsx)(j,{...e,children:u(e.children)},String(n))}},8453:(e,n,t)=>{t.d(n,{R:()=>s,x:()=>i});var a=t(6540);const o={},r=a.createContext(o);function s(e){const n=a.useContext(r);return a.useMemo((function(){return"function"==typeof e?e(n):{...n,...e}}),[n,e])}function i(e){let n;return n=e.disableParentContext?"function"==typeof e.components?e.components(o):e.components||o:s(e.components),a.createElement(r.Provider,{value:n},e.children)}}}]);