"use strict";(self.webpackChunkadvantagescope_docs=self.webpackChunkadvantagescope_docs||[]).push([[7086],{3679:(e,t,r)=>{r.r(t),r.d(t,{assets:()=>i,contentTitle:()=>d,default:()=>h,frontMatter:()=>a,metadata:()=>n,toc:()=>c});const n=JSON.parse('{"id":"overview/legacy-formats","title":"\u26a0\ufe0f Legacy Format Deprecation","description":"WPILib supports the type-safe and unit-safe struct format for publishing complex data types such as geometry objects, swerve states, and more! AdvantageScope takes advantage of the struct format to streamline the process of configuring fields for visualization. For example, 2D and 3D poses can now be used side-by-side on the \ud83d\uddfa 2D Field and \ud83d\udc40 3D Field tabs with no manual configuration and no unit errors.","source":"@site/docs/overview/legacy-formats.md","sourceDirName":"overview","slug":"/overview/legacy-formats","permalink":"/overview/legacy-formats","draft":false,"unlisted":false,"tags":[],"version":"current","sidebarPosition":6,"frontMatter":{"sidebar_position":6},"sidebar":"sidebar","previous":{"title":"\ud83d\udcfd\ufe0f Championship Conference","permalink":"/overview/champs-conference"},"next":{"title":"Tab Reference","permalink":"/category/tab-reference"}}');var s=r(4848),o=r(8453);const a={sidebar_position:6},d="\u26a0\ufe0f Legacy Format Deprecation",i={},c=[{value:"What&#39;s Changing?",id:"whats-changing",level:2},{value:"How Do I Update?",id:"how-do-i-update",level:2}];function l(e){const t={a:"a",admonition:"admonition",code:"code",h1:"h1",h2:"h2",header:"header",p:"p",pre:"pre",strong:"strong",table:"table",tbody:"tbody",td:"td",th:"th",thead:"thead",tr:"tr",...(0,o.R)(),...e.components},{Details:r}=t;return r||function(e,t){throw new Error("Expected "+(t?"component":"object")+" `"+e+"` to be defined: you likely forgot to import, pass, or provide it.")}("Details",!0),(0,s.jsxs)(s.Fragment,{children:[(0,s.jsx)(t.header,{children:(0,s.jsx)(t.h1,{id:"\ufe0f-legacy-format-deprecation",children:"\u26a0\ufe0f Legacy Format Deprecation"})}),"\n",(0,s.jsxs)(t.p,{children:["WPILib supports the type-safe and unit-safe ",(0,s.jsx)(t.strong,{children:"struct format"})," for publishing complex data types such as geometry objects, swerve states, and more! AdvantageScope takes advantage of the struct format to streamline the process of configuring fields for visualization. For example, 2D and 3D poses can now be used side-by-side on the ",(0,s.jsx)(t.a,{href:"/tab-reference/2d-field",children:"\ud83d\uddfa 2D Field"})," and ",(0,s.jsx)(t.a,{href:"/tab-reference/3d-field",children:"\ud83d\udc40 3D Field"})," tabs with ",(0,s.jsx)(t.strong,{children:"no manual configuration"})," and ",(0,s.jsx)(t.strong,{children:"no unit errors"}),"."]}),"\n",(0,s.jsxs)(t.p,{children:['Before 2025, AdvantageScope supported both structs and the legacy "number array" format for geometry types. The legacy format packed structured data into a format like ',(0,s.jsx)(t.code,{children:"double[]"})," (e.g. a pose would be represented by the array ",(0,s.jsx)(t.code,{children:"[x, y, rotation]"}),")."]}),"\n",(0,s.jsx)(t.admonition,{type:"info",children:(0,s.jsxs)(t.p,{children:["For more information on the design of structs and their advantages, check out ",(0,s.jsx)(t.a,{href:"https://www.chiefdelphi.com/t/introducing-monologue-annotation-based-telemetry-and-data-logging-for-java-teams/443917/5",children:"this post"}),"."]})}),"\n",(0,s.jsx)(t.h2,{id:"whats-changing",children:"What's Changing?"}),"\n",(0,s.jsxs)(t.p,{children:["In 2025 and 2026, AdvantageScope continues to support both the modern struct format and the legacy number array format. However, ",(0,s.jsxs)(t.strong,{children:["the legacy number array format is now ",(0,s.jsx)("u",{children:"deprecated"})," and will be removed in 2027"]}),". AdvantageScope will present a warning when the legacy format is used, and additional information must be manually provided to specify the packing format and units."]}),"\n",(0,s.jsxs)(t.table,{children:[(0,s.jsx)(t.thead,{children:(0,s.jsxs)(t.tr,{children:[(0,s.jsx)(t.th,{}),(0,s.jsx)(t.th,{children:"Modern Struct Format"}),(0,s.jsx)(t.th,{children:"Legacy Number Array Format"})]})}),(0,s.jsxs)(t.tbody,{children:[(0,s.jsxs)(t.tr,{children:[(0,s.jsxs)(t.td,{children:[(0,s.jsx)(t.strong,{children:"2024"})," (v3.x)"]}),(0,s.jsx)(t.td,{children:"\u2705 Recommended"}),(0,s.jsx)(t.td,{children:"\u2705 Supported"})]}),(0,s.jsxs)(t.tr,{children:[(0,s.jsxs)(t.td,{children:[(0,s.jsx)(t.strong,{children:"2025"})," (v4.x)"]}),(0,s.jsx)(t.td,{children:"\u2705 Recommended"}),(0,s.jsx)(t.td,{children:"\u26a0\ufe0f Deprecated"})]}),(0,s.jsxs)(t.tr,{children:[(0,s.jsxs)(t.td,{children:[(0,s.jsx)(t.strong,{children:"2026"})," (v26.x)"]}),(0,s.jsx)(t.td,{children:"\u2705 Recommended"}),(0,s.jsx)(t.td,{children:"\u26a0\ufe0f Deprecated"})]}),(0,s.jsxs)(t.tr,{children:[(0,s.jsxs)(t.td,{children:[(0,s.jsx)(t.strong,{children:"2027"})," (v27.x)"]}),(0,s.jsx)(t.td,{children:"\u2705 Recommended"}),(0,s.jsx)(t.td,{children:"\u274c Removed"})]})]})]}),"\n",(0,s.jsx)(t.admonition,{type:"warning",children:(0,s.jsx)(t.p,{children:"While the legacy format can still be used, additional information must be provided about the packing format and units of each field. After adding an array field to a tab, the format can be configured by clicking the icon to the left of the field name."})}),"\n",(0,s.jsx)(t.h2,{id:"how-do-i-update",children:"How Do I Update?"}),"\n",(0,s.jsxs)(t.p,{children:["Most major tools and libraries already support the modern struct format (check the documentation of each library for details). Below, you can see how to upgrade to the modern format for several common libraries. The struct format supports both single objects and object arrays (such as ",(0,s.jsx)(t.code,{children:"Pose2d[]"}),")."]}),"\n",(0,s.jsx)(t.admonition,{type:"tip",children:(0,s.jsx)(t.p,{children:"If you rely on a library that hasn't upgraded to the new format, reach out the developers for details."})}),"\n",(0,s.jsxs)(r,{children:[(0,s.jsx)("summary",{children:"NetworkTables"}),(0,s.jsxs)(t.p,{children:["To publish struct data to NetworkTables, create a ",(0,s.jsx)(t.code,{children:"StructPublisher"})," with the desired type and call ",(0,s.jsx)(t.code,{children:"set()"})," as shown below."]}),(0,s.jsx)(t.pre,{children:(0,s.jsx)(t.code,{className:"language-java",children:'StructPublisher<Pose2d> publisher = NetworkTableInstance.getDefault()\r\n  .getStructTopic("MyPose", Pose2d.struct).publish();\r\npublisher.set(new Pose2d());\n'})}),(0,s.jsx)(t.admonition,{type:"tip",children:(0,s.jsxs)(t.p,{children:["WPILib will support a struct alternative to the ",(0,s.jsx)(t.a,{href:"https://github.wpilib.org/allwpilib/docs/release/java/edu/wpi/first/wpilibj/smartdashboard/SmartDashboard.html",children:(0,s.jsx)(t.code,{children:"SmartDashboard"})})," style ",(0,s.jsx)(t.code,{children:"put"})," methods in 2027. In the meantime, consider using another logging library such as Monologue that supports an imperative API."]})})]}),"\n",(0,s.jsxs)(r,{children:[(0,s.jsx)("summary",{children:"Field2d"}),(0,s.jsxs)(t.p,{children:["WPILib's ",(0,s.jsx)(t.code,{children:"Field2d"})," class does not support the modern struct format, but will be superseded by an improved telemetry API in 2027. In the meantime, users who wish to try the modern format can publish pose data using the NetworkTables API shown above."]})]}),"\n",(0,s.jsxs)(r,{children:[(0,s.jsx)("summary",{children:"Epilogue"}),(0,s.jsx)(t.p,{children:"To publish struct data using Epilogue, simply return a supported object type from a logged method:"}),(0,s.jsx)(t.pre,{children:(0,s.jsx)(t.code,{className:"language-java",children:"@Logged\r\npublic class MyClass {\r\n  public Pose2d getPose() {\r\n    return new Pose2d();\r\n  }\r\n}\n"})})]}),"\n",(0,s.jsxs)(r,{children:[(0,s.jsx)("summary",{children:"AdvantageKit"}),(0,s.jsxs)(t.p,{children:["To log and replay struct data using AdvantageKit, simply pass a supported object type to the ",(0,s.jsx)(t.code,{children:"recordOutput"})," method, return it from a method/field tagged with ",(0,s.jsx)(t.code,{children:"@AutoLogOutput"}),", or include it in an inputs class tagged with ",(0,s.jsx)(t.code,{children:"@AutoLog"}),"."]}),(0,s.jsx)(t.pre,{children:(0,s.jsx)(t.code,{className:"language-java",children:'// Standard output logging\r\nLogger.recordOutput("MyPose", new Pose2d());\r\n\r\n// Annotation output logging\r\npublic class MyClass {\r\n  @AutoLogOutput\r\n  public Pose2d getPose() {\r\n    return new Pose2d();\r\n  }\r\n\r\n  @AutoLogOutput\r\n  public Pose2d myPose = new Pose2d();\r\n}\r\n\r\n// Inputs class\r\n@AutoLog\r\npublic class Inputs {\r\n  public Pose2d myPose = new Pose2d();\r\n}\n'})})]}),"\n",(0,s.jsxs)(r,{children:[(0,s.jsx)("summary",{children:"DogLog"}),(0,s.jsxs)(t.p,{children:["To publish struct data using DogLog, simply pass a supported object type to the ",(0,s.jsx)(t.code,{children:"log"})," method:"]}),(0,s.jsx)(t.pre,{children:(0,s.jsx)(t.code,{className:"language-java",children:'DogLog.log("MyPose", new Pose2d());\n'})})]}),"\n",(0,s.jsxs)(r,{children:[(0,s.jsx)("summary",{children:"DataLog"}),(0,s.jsxs)(t.p,{children:["To append struct data to a raw ",(0,s.jsx)(t.code,{children:"DataLog"}),", create a ",(0,s.jsx)(t.code,{children:"StructLogEntry"})," with the desired type and call ",(0,s.jsx)(t.code,{children:"set()"})," as shown below."]}),(0,s.jsx)(t.pre,{children:(0,s.jsx)(t.code,{className:"language-java",children:'StructLogEntry<Pose2d> logEntry =\r\n        StructLogEntry.create(DataLogManager.getLog(), "MyPose", Pose2d.struct);\r\nlogEntry.append(new Pose2d());\n'})})]}),"\n",(0,s.jsxs)(r,{children:[(0,s.jsx)("summary",{children:"Phoenix Signal Logger (Hoot)"}),(0,s.jsxs)(t.p,{children:["To write struct data to a Hoot file, pass a supported object to the ",(0,s.jsx)(t.code,{children:"writeStruct"})," method along with the associated struct object."]}),(0,s.jsx)(t.pre,{children:(0,s.jsx)(t.code,{className:"language-java",children:'SignalLogger.writeStruct("MyPose", Pose2d.struct, new Pose2d());\n'})})]})]})}function h(e={}){const{wrapper:t}={...(0,o.R)(),...e.components};return t?(0,s.jsx)(t,{...e,children:(0,s.jsx)(l,{...e})}):l(e)}},8453:(e,t,r)=>{r.d(t,{R:()=>a,x:()=>d});var n=r(6540);const s={},o=n.createContext(s);function a(e){const t=n.useContext(o);return n.useMemo((function(){return"function"==typeof e?e(t):{...t,...e}}),[t,e])}function d(e){let t;return t=e.disableParentContext?"function"==typeof e.components?e.components(s):e.components||s:a(e.components),n.createElement(o.Provider,{value:t},e.children)}}}]);