/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.canbridge;

import com.revrobotics.canbridge.CanMode;

public record CanMessage(int messageId, long timestamp, boolean isRtr, CanMode mode, byte[] data) {
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("0x");
        builder.append(Integer.toString(this.messageId, 16));
        builder.append(": ");
        for (byte datum : this.data) {
            builder.append(Integer.toString(datum & 0xFF, 16));
        }
        return builder.toString();
    }

    public static CanMessage createClassic(int messageId, byte[] data) {
        return new CanMessage(messageId, System.currentTimeMillis(), false, CanMode.CLASSIC, data);
    }

    public static CanMessage createRtr(int messageId, byte[] data) {
        return new CanMessage(messageId, System.currentTimeMillis(), true, CanMode.CLASSIC, data);
    }
}

