/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.device.detection;

import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.device.detection.Detector;
import com.revrobotics.device.detection.DeviceManager;
import com.revrobotics.device.detection.HeartbeatSender;
import com.revrobotics.device.detection.REVLibDeviceManager;
import com.revrobotics.device.detection.dfu.DfuManager;
import com.revrobotics.device.detection.gsusb.GSUsbManager;
import com.revrobotics.device.detection.polling.MessagePollingService;

public class DeviceDaemon {
    private final Detector detector;
    private final DeviceManager deviceManager;
    private final CanBridge canBridge;
    private final DfuManager dfuManager;

    public DeviceDaemon(CanBridge canBridge, DfuManager dfuManager, GSUsbManager gsUsbManager) {
        this.dfuManager = dfuManager;
        this.detector = new Detector(canBridge, dfuManager, gsUsbManager);
        MessagePollingService messagePollingService = new MessagePollingService(canBridge);
        REVLibDeviceManager revLibDeviceManager = new REVLibDeviceManager();
        HeartbeatSender sender = new HeartbeatSender(canBridge, this.detector);
        this.deviceManager = new DeviceManager(this.detector, messagePollingService, sender, revLibDeviceManager);
        this.deviceManager.startIfNotRunning();
        this.canBridge = canBridge;
    }

    public Detector getDetector() {
        return this.detector;
    }

    public DeviceManager getDeviceManager() {
        return this.deviceManager;
    }

    public <R> R doWithRawCanBridge(String descriptor, WithRawCanBridge<R> action) {
        CanBus bus = this.canBridge.getBusOrNull(descriptor);
        return action.withRawCanBridge(this.canBridge, bus);
    }

    public DfuManager getDfuManager() {
        return this.dfuManager;
    }

    public static interface WithRawCanBridge<R> {
        public R withRawCanBridge(CanBridge var1, CanBus var2);
    }
}

