/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.device.detection;

import com.revrobotics.EncoderFrameEmitter;
import com.revrobotics.PneumaticHubStatusEmitter;
import com.revrobotics.PowerHubStatusEmitter;
import com.revrobotics.ServoHubStatusFrameEmitter;
import com.revrobotics.SparkStatusFrameEmitter;
import com.revrobotics.StatusFrameEmitter;
import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.device.detection.AllCanFrames;
import com.revrobotics.device.detection.Detector;
import com.revrobotics.device.detection.HeartbeatSender;
import com.revrobotics.device.detection.REVLibDeviceManager;
import com.revrobotics.device.detection.device.DeviceTree;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.device.detection.device.RecognizedDevice;
import com.revrobotics.device.detection.polling.MessagePollingService;
import com.revrobotics.devices.PneumaticHub;
import com.revrobotics.devices.PowerHub;
import com.revrobotics.encoder.DetachedEncoder;
import com.revrobotics.servohub.ServoHub;
import com.revrobotics.servohub.ServoHubLowLevel;
import com.revrobotics.spark.SparkBase;
import com.revrobotics.spark.SparkLowLevel;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class DeviceManager {
    private final Logger logger = Logger.getLogger(DeviceManager.class.getName());
    private static final int DETECTION_INTERVAL_MS = 1000;
    private final Detector detector;
    private final MessagePollingService messagePollingService;
    private final REVLibDeviceManager revLibDeviceManager;
    private final HeartbeatSender heartbeatSender;
    private ScheduledExecutorService detectorExecutor;
    private final Map<String, StatusFrameEmitterHolder> sparkStatusFrameEmitterHolders = new ConcurrentHashMap<String, StatusFrameEmitterHolder>();
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final Map<String, DeviceTree> deviceTreeByDescriptor = new ConcurrentHashMap<String, DeviceTree>();
    private long lastDetectionTime = 0L;

    public DeviceManager(Detector detector, MessagePollingService messagePollingService, HeartbeatSender heartbeatSender, REVLibDeviceManager revLibDeviceManager) {
        this.detector = detector;
        this.messagePollingService = messagePollingService;
        this.heartbeatSender = heartbeatSender;
        this.revLibDeviceManager = revLibDeviceManager;
    }

    public void startIfNotRunning() {
        if (!this.isStarted.get()) {
            this.isStarted.set(true);
            this.startDetector();
        }
    }

    public void setup() {
        this.detector.addScanCallback(Detector.DetectorStage.FULLY_INITIALIZED, (devices, added, removed, changed) -> {
            for (DeviceTree tree : added) {
                if (!RecognizedDevice.isCan(tree.root().type())) continue;
                CanBus canBus = this.getDeviceForTree(tree);
                this.heartbeatSender.addDevice(canBus);
            }
            for (DeviceTree tree : changed) {
                this.ejectMissingDevices(tree);
                this.handleNewDevices(tree);
            }
            for (DeviceTree tree : devices) {
                this.deviceTreeByDescriptor.put(tree.descriptor(), tree);
            }
        });
        this.revLibDeviceManager.registerToDetector(this.detector);
    }

    void startDetector() {
        this.setup();
        this.runDetector();
    }

    private void handleNewDevices(DeviceTree tree) {
    }

    private void ejectMissingDevices(DeviceTree tree) {
    }

    void runDetector() {
        this.detectorExecutor = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread t = new Thread(runnable);
            t.setName("Detector Thread");
            t.setDaemon(true);
            return t;
        });
        this.detectorExecutor.scheduleAtFixedRate(this::iterate, 0L, 5L, TimeUnit.MILLISECONDS);
    }

    public void iterate() {
        try {
            AllCanFrames allCanData = this.messagePollingService.iterate();
            if (System.currentTimeMillis() - this.lastDetectionTime >= 1000L) {
                this.detector.iterate(allCanData);
                this.lastDetectionTime = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            this.logger.severe("Detector thread caught an exception");
            e.printStackTrace();
        }
    }

    private CanBus getDeviceForTree(DeviceTree deviceTree) {
        return this.messagePollingService.getCurrentDevices().stream().filter(canDevice -> canDevice.descriptor().equals(deviceTree.descriptor())).findFirst().orElse(null);
    }

    public FRCCanDevice getDevice(String descriptor, UUID uuid) {
        DeviceTree tree = this.deviceTreeByDescriptor.get(descriptor);
        if (tree == null) {
            return null;
        }
        if (tree.root().uuid().equals(uuid)) {
            return tree.root();
        }
        for (FRCCanDevice device : tree.children()) {
            if (!device.uuid().equals(uuid)) continue;
            return device;
        }
        return null;
    }

    public Map<String, DeviceTree> getDevices() {
        return this.deviceTreeByDescriptor;
    }

    public DeviceTree getDeviceTree(String descriptor) {
        return this.deviceTreeByDescriptor.get(descriptor);
    }

    public REVLibDeviceManager getRevLibDeviceManager() {
        return this.revLibDeviceManager;
    }

    public CanBus getCanBus(String descriptor) {
        return this.messagePollingService.getCurrentDevices().stream().filter(canDevice -> canDevice.descriptor().equals(descriptor)).findFirst().orElse(null);
    }

    public void addSparkStatusEmitterMap(String sessionId, StatusFrameEmitterHolder emitter) {
        this.sparkStatusFrameEmitterHolders.put(sessionId, emitter);
    }

    public StatusFrameEmitterHolder addSparkStatusEmitterMap(String sessionId) {
        StatusFrameEmitterHolder emitter = new StatusFrameEmitterHolder(sessionId);
        this.addSparkStatusEmitterMap(sessionId, emitter);
        return emitter;
    }

    public StatusFrameEmitterHolder getSparkStatusFrameEmitter(String sessionId) {
        return this.sparkStatusFrameEmitterHolders.get(sessionId);
    }

    public void closeFrameEmitters(String sessionId) {
        StatusFrameEmitterHolder emitterHolder = this.sparkStatusFrameEmitterHolders.remove(sessionId);
        if (emitterHolder != null) {
            emitterHolder.close();
        }
    }

    public void removeSparkStatusFrameEmitter(String sessionId) {
        this.sparkStatusFrameEmitterHolders.remove(sessionId);
    }

    public HeartbeatSender getHeartbeatSender() {
        return this.heartbeatSender;
    }

    public void close() {
        this.lastDetectionTime = 0L;
        this.isStarted.set(false);
        this.detectorExecutor.shutdownNow();
        REVLibDeviceManager.servoHubs.values().forEach(ServoHubLowLevel::close);
        REVLibDeviceManager.servoHubs.clear();
        REVLibDeviceManager.sparks.values().forEach(SparkLowLevel::close);
        REVLibDeviceManager.sparks.clear();
        this.detector.close();
    }

    public static class StatusFrameEmitterHolder {
        private final String sessionId;
        private final Map<FullDeviceIdentifier, StatusFrameEmitter> emitters = new ConcurrentHashMap<FullDeviceIdentifier, StatusFrameEmitter>();

        public StatusFrameEmitterHolder(String sessionId) {
            this.sessionId = sessionId;
        }

        public String sessionId() {
            return this.sessionId;
        }

        public StatusFrameEmitter getEmitter(FullDeviceIdentifier identifier) {
            return this.emitters.get(identifier);
        }

        public StatusFrameEmitter addSparkEmitterCallback(SparkBase spark, FullDeviceIdentifier identifier, CanBridge bridge, CanBus bus, SparkStatusFrameEmitter.StatusDataCallback statusCallback, StatusFrameEmitter.OnStopCallback onStopCallback) {
            String encodedDescriptor = Base64.getUrlEncoder().withoutPadding().encodeToString(identifier.descriptor.getBytes(StandardCharsets.UTF_8));
            SparkStatusFrameEmitter emitter = new SparkStatusFrameEmitter(encodedDescriptor, identifier.uuid, spark, bridge, bus, statusCallback, onStopCallback);
            this.emitters.put(identifier, (StatusFrameEmitter)emitter);
            emitter.start();
            return emitter;
        }

        public StatusFrameEmitter addServoHubEmitterCallback(ServoHub servoHub, FullDeviceIdentifier identifier, ServoHubStatusFrameEmitter.StatusDataCallback statusCallback, StatusFrameEmitter.OnStopCallback onStopCallback) {
            String encodedDescriptor = Base64.getUrlEncoder().withoutPadding().encodeToString(identifier.descriptor.getBytes(StandardCharsets.UTF_8));
            ServoHubStatusFrameEmitter emitter = new ServoHubStatusFrameEmitter(encodedDescriptor, identifier.uuid, servoHub, statusCallback, onStopCallback);
            this.emitters.put(identifier, (StatusFrameEmitter)emitter);
            emitter.start();
            return emitter;
        }

        public StatusFrameEmitter addPowerHubEmitterCallback(PowerHub powerHub, FullDeviceIdentifier identifier, PowerHubStatusEmitter.StatusDataCallback callback, StatusFrameEmitter.OnStopCallback onStopCallback, CanBridge bridge, CanBus bus) {
            String encodedDescriptor = Base64.getUrlEncoder().withoutPadding().encodeToString(identifier.descriptor.getBytes(StandardCharsets.UTF_8));
            PowerHubStatusEmitter emitter = new PowerHubStatusEmitter(encodedDescriptor, identifier.uuid, powerHub, callback, onStopCallback);
            this.emitters.put(identifier, (StatusFrameEmitter)emitter);
            emitter.start();
            return emitter;
        }

        public StatusFrameEmitter addPneumaticHubEmitterCallback(PneumaticHub pneumaticHub, FullDeviceIdentifier identifier, PneumaticHubStatusEmitter.StatusDataCallback callback, StatusFrameEmitter.OnStopCallback onStopCallback) {
            String encodedDescriptor = Base64.getUrlEncoder().withoutPadding().encodeToString(identifier.descriptor.getBytes(StandardCharsets.UTF_8));
            PneumaticHubStatusEmitter emitter = new PneumaticHubStatusEmitter(encodedDescriptor, identifier.uuid, pneumaticHub, callback, onStopCallback);
            this.emitters.put(identifier, (StatusFrameEmitter)emitter);
            emitter.start();
            return emitter;
        }

        public StatusFrameEmitter addEncoderEmitterCallback(DetachedEncoder encoder, FullDeviceIdentifier identifier, EncoderFrameEmitter.StatusDataCallback callback, StatusFrameEmitter.OnStopCallback onStopCallback) {
            String encodedDescriptor = Base64.getUrlEncoder().withoutPadding().encodeToString(identifier.descriptor.getBytes(StandardCharsets.UTF_8));
            EncoderFrameEmitter emitter = new EncoderFrameEmitter(encodedDescriptor, identifier.uuid, encoder, callback, onStopCallback);
            this.emitters.put(identifier, (StatusFrameEmitter)emitter);
            emitter.start();
            return emitter;
        }

        public void stopEmitter(FullDeviceIdentifier identifier) {
            StatusFrameEmitter emitter = this.emitters.remove(identifier);
            if (emitter != null) {
                emitter.stop();
            }
        }

        public void close() {
            this.emitters.forEach((identifier, emitter) -> emitter.stop());
            this.emitters.clear();
        }
    }

    public record FullDeviceIdentifier(String descriptor, UUID uuid) {
    }
}

