/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.device.detection;

import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.canbridge.CanMessage;
import com.revrobotics.device.detection.Detector;
import com.revrobotics.device.detection.device.DeviceTree;
import com.revrobotics.device.detection.device.FRCCanDevice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public class HeartbeatSender {
    private static final Logger logger = Logger.getLogger(HeartbeatSender.class.getName());
    private static final int SECONDARY_HEARTBEAT_ID = 33893504;
    private static final int REV_UNIVERSAL_SECONDARY_HEARTBEAT_ID = 328384;
    private static final int SECONDARY_HEARTBEAT_INTERVAL = 25;
    private final CanBridge bridge;
    private final Map<CanBus, byte[]> heartbeatMap = new HashMap<CanBus, byte[]>();
    private ReentrantLock lock = new ReentrantLock();

    public HeartbeatSender(CanBridge bridge, Detector detector) {
        this.bridge = bridge;
        this.removeMissingSparks(detector);
    }

    private void removeMissingSparks(Detector detector) {
        detector.addScanCallback(Detector.DetectorStage.DEVICES_DETECTED, (devices, added, removed, changed) -> {
            for (DeviceTree tree : removed) {
                this.heartbeatMap.entrySet().removeIf(entry -> ((CanBus)entry.getKey()).descriptor().equals(tree.descriptor()));
            }
            for (DeviceTree changedTree : changed) {
                Optional<Map.Entry> heartbeatInfo = this.heartbeatMap.entrySet().stream().filter(entry -> ((CanBus)entry.getKey()).descriptor().equals(changedTree.descriptor())).findFirst();
                if (!heartbeatInfo.isPresent()) continue;
                ArrayList<FRCCanDevice> devicesToCheck = new ArrayList<FRCCanDevice>(changedTree.children());
                devicesToCheck.addFirst(changedTree.root());
                for (int i = 0; i < 64; ++i) {
                    CanBus heartbeatBus = (CanBus)heartbeatInfo.get().getKey();
                    if (HeartbeatSender.isSparkPresent(i, devicesToCheck)) continue;
                    this.disableSpark(heartbeatBus, i);
                }
            }
        });
    }

    private static boolean isSparkPresent(int id, List<FRCCanDevice> devices) {
        return devices.stream().anyMatch(device -> device.id() == id && device.type().isSPARK());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableSpark(CanBus bus, int id) {
        this.lock.lock();
        try {
            int index;
            byte[] heartbeatData = this.heartbeatMap.get(bus);
            if (heartbeatData == null) {
                logger.severe("Failed to enable SPARK " + id + " on bus " + String.valueOf(bus) + ": No heartbeat data found");
                return;
            }
            logger.info("Enabling SPARK " + id + " on bus " + String.valueOf(bus));
            int n = index = id / 8;
            heartbeatData[n] = (byte)(heartbeatData[n] | (byte)(1 << id % 8));
            this.updateHeartbeat(bus);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableSpark(CanBus bus, int id) {
        this.lock.lock();
        try {
            int index;
            byte[] heartbeatData = this.heartbeatMap.get(bus);
            if (heartbeatData == null) {
                logger.severe("Failed to disable SPARK " + id + " on bus " + String.valueOf(bus) + ": No heartbeat data found");
                return;
            }
            logger.info("Disabling SPARK " + id + " on bus " + String.valueOf(bus));
            int n = index = id / 8;
            heartbeatData[n] = (byte)(heartbeatData[n] & (byte)(~(1 << id % 8)));
            this.updateHeartbeat(bus);
        }
        finally {
            this.lock.unlock();
        }
    }

    void addDevice(CanBus bus) {
        if (bus == null) {
            return;
        }
        this.heartbeatMap.put(bus, new byte[8]);
        this.updateHeartbeat(bus);
    }

    void updateHeartbeat(CanBus bus) {
        logger.info("Updating secondary heartbeat for bus " + String.valueOf(bus));
        CanMessage heartbeatMessage = CanMessage.createClassic((int)33893504, (byte[])this.heartbeatMap.get(bus));
        this.bridge.sendMessage(bus, heartbeatMessage, 25);
        CanMessage revUniversalSecondaryHeartbeatMessage = CanMessage.createClassic((int)328384, (byte[])new byte[]{1});
        this.bridge.sendMessage(bus, revUniversalSecondaryHeartbeatMessage, 25);
    }

    void removeDevice(CanBus bus) {
        this.heartbeatMap.remove(bus);
        this.bridge.stopMessage(bus, CanMessage.createClassic((int)33893504, (byte[])new byte[8]));
    }
}

