/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.device.detection.detectors;

import com.revrobotics.EncoderAdvanced;
import com.revrobotics.ServoHubAdvanced;
import com.revrobotics.SparkAdvanced;
import com.revrobotics.can.spec.EncoderCanSpec;
import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.canbridge.CanMessage;
import com.revrobotics.device.detection.AllCanFrames;
import com.revrobotics.device.detection.CanBusData;
import com.revrobotics.device.detection.Detector;
import com.revrobotics.device.detection.device.DeviceTree;
import com.revrobotics.device.detection.device.DeviceType;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.device.detection.device.Manufacturer;
import com.revrobotics.device.detection.device.RecognizedDevice;
import com.revrobotics.device.detection.parsing.CanIdParsing;
import com.revrobotics.devices.PneumaticHub;
import com.revrobotics.devices.PowerHub;
import com.revrobotics.spark.config.SparkParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FRCCanDetector {
    private final CanBridge canBridge;

    public FRCCanDetector(CanBridge canBridge) {
        this.canBridge = canBridge;
    }

    public Detector.DeviceDetector frcCanDeviceDetector() {
        return new Detector.DeviceDetector(){
            private AllCanFrames allFrames;

            @Override
            public void iterate(AllCanFrames allFrames) {
                this.allFrames = allFrames;
            }

            @Override
            public List<DeviceTree> devicesToRemove(List<DeviceTree> devices) {
                return devices.stream().filter(device -> FRCCanDetector.this.frcCanDeviceCanBeRemoved(this.allFrames, (DeviceTree)device)).toList();
            }

            @Override
            public List<DeviceTree> devicesToAdd(List<DeviceTree> devices) {
                ArrayList<DeviceTree> addedDevices = new ArrayList<DeviceTree>();
                for (CanBusData entry : this.allFrames.allMessages().values()) {
                    DeviceTree newDevice;
                    Optional<DeviceTree> matchingBus = devices.stream().filter(device -> device.descriptor().equals(entry.descriptor())).findFirst();
                    if (!matchingBus.isEmpty() || (newDevice = FRCCanDetector.this.createNewDevice(entry)) == null) continue;
                    addedDevices.add(newDevice);
                }
                return addedDevices;
            }

            @Override
            public List<DeviceTree> updateDeviceTrees(List<DeviceTree> devices) {
                ArrayList<DeviceTree> changedDevices = new ArrayList<DeviceTree>();
                for (CanBusData entry : this.allFrames.allMessages().values()) {
                    DeviceTree tree;
                    Optional<DeviceTree> matchingBus = devices.stream().filter(device -> device.descriptor().equals(entry.descriptor())).findFirst();
                    if (matchingBus.isEmpty()) continue;
                    List<FRCCanDevice> devicesOnBusNow = FRCCanDetector.this.findCanDevices(entry.descriptor(), entry.messages());
                    if (matchingBus.get().busMatches(devicesOnBusNow) || (tree = FRCCanDetector.this.createNewDevice(entry)) == null) continue;
                    changedDevices.add(tree);
                }
                return changedDevices;
            }
        };
    }

    private boolean frcCanDeviceCanBeRemoved(AllCanFrames allFrames, DeviceTree device) {
        return RecognizedDevice.isCan(device.root().type()) && !allFrames.allMessages().containsKey(device.descriptor());
    }

    private DeviceTree createNewDevice(CanBusData frames) {
        List<FRCCanDevice> devices = this.findCanDevices(frames.descriptor(), frames.messages());
        if (!devices.isEmpty()) {
            FRCCanDevice root = this.findRoot(frames.descriptor(), devices);
            devices.remove(root);
            return new DeviceTree(root, frames.descriptor(), devices);
        }
        return null;
    }

    private FRCCanDevice findRoot(String descriptor, List<FRCCanDevice> devices) {
        CanBus bus = this.canBridge.getBusOrNull(descriptor);
        for (FRCCanDevice device : devices) {
            boolean isBridge;
            boolean bl;
            block15: {
                block14: {
                    if (device == null || device.type() == null) break block14;
                    switch (device.type()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case SPARK_FLEX: 
                        case SPARK_MAX: 
                        case UNKNOWN_SPARK: {
                            if (SparkAdvanced.checkIfUsbBridge((CanBridge)this.canBridge, (CanBus)bus, (int)device.id())) {
                                break;
                            }
                            break block14;
                        }
                        case SERVO_HUB: {
                            if (ServoHubAdvanced.checkIfUsbBridge((CanBridge)this.canBridge, (CanBus)bus, (int)device.id())) {
                                break;
                            }
                            break block14;
                        }
                        case PDH: {
                            if (PowerHub.checkIfUsbBridge((CanBridge)this.canBridge, (CanBus)bus, (int)device.id())) {
                                break;
                            }
                            break block14;
                        }
                        case PH: {
                            if (PneumaticHub.checkIfUsbBridge((CanBridge)this.canBridge, (CanBus)bus, (int)device.id())) {
                                break;
                            }
                            break block14;
                        }
                        case UNKNOWN_ENCODER: 
                        case MAXSPLINE_ENCODER: {
                            break block14;
                        }
                        case DFU: 
                        case GS_USB: {
                            break;
                        }
                        case ROBORIO: 
                        case CONTROL_HUB: 
                        case EXPANSION_HUB: 
                        case REV_FIRMWARE_INTERFACE: 
                        case CTRE_DEVICE: 
                        case THRIFTY_DEVICE: 
                        case FUSION_DEVICE: 
                        case STUDICA_DEVICE: 
                        case REDUX_DEVICE: 
                        case SWYFT_DEVICE: {
                            break block14;
                        }
                    }
                    bl = true;
                    break block15;
                }
                bl = false;
            }
            if (!(isBridge = bl)) continue;
            return device;
        }
        return devices.getFirst();
    }

    private List<FRCCanDevice> findCanDevices(String descriptor, List<CanMessage> messages) {
        ArrayList<FRCCanDevice> canDevices = new ArrayList<FRCCanDevice>();
        for (CanMessage message : messages) {
            CanBus bus;
            int deviceId = CanIdParsing.parseDeviceId(message.messageId());
            DeviceType deviceType = CanIdParsing.parseDeviceType(message.messageId());
            Manufacturer manufacturer = CanIdParsing.manufacturer(message.messageId());
            boolean isBootloader = false;
            RecognizedDevice recognizedDevice = RecognizedDevice.fromCanInfo(manufacturer, deviceType);
            if (recognizedDevice == RecognizedDevice.UNKNOWN_SPARK) {
                if ((message.messageId() & 0x1FFFFFC0) != 33929216) continue;
                bus = this.canBridge.getBusOrNull(descriptor);
                recognizedDevice = FRCCanDetector.getSparkModel(this.canBridge, bus, message, deviceId);
            }
            if (recognizedDevice == RecognizedDevice.UNKNOWN_ENCODER) {
                if ((message.messageId() & 0x1FFFFFC0) == 117815296) {
                    bus = this.canBridge.getBusOrNull(descriptor);
                    recognizedDevice = FRCCanDetector.getEncoderModel(this.canBridge, bus, message, deviceId);
                } else {
                    if ((message.messageId() & 0x1FFFFFC0) != 117813248) continue;
                    isBootloader = true;
                    recognizedDevice = FRCCanDetector.getEncoderModelFromBootloader(message);
                }
            }
            if (recognizedDevice == RecognizedDevice.SERVO_HUB) {
                if ((message.messageId() & 0x1FFFFFC0) == 201701376) {
                    isBootloader = false;
                } else {
                    if ((message.messageId() & 0x1FFFFFC0) != 201699328) continue;
                    isBootloader = true;
                }
            }
            if (recognizedDevice == RecognizedDevice.PDH) {
                if ((message.messageId() & 0x1FFFFFC0) == 134551552) {
                    isBootloader = false;
                } else {
                    if ((message.messageId() & 0x1FFFFFC0) != 134590464) continue;
                    isBootloader = true;
                }
            }
            if (recognizedDevice == RecognizedDevice.PH) {
                if ((message.messageId() & 0x1FFFFFC0) == 151328768) {
                    isBootloader = false;
                } else {
                    if ((message.messageId() & 0x1FFFFFC0) != 151367680) continue;
                    isBootloader = true;
                }
            }
            FRCCanDevice device = new FRCCanDevice(descriptor, deviceId, isBootloader, recognizedDevice, Detector.deviceUUID(deviceId, deviceType, manufacturer));
            if (!canDevices.stream().noneMatch(device::frcEquals)) continue;
            canDevices.add(device);
        }
        return canDevices;
    }

    private static RecognizedDevice getSparkModel(CanBridge bridge, CanBus bus, CanMessage message, int canId) {
        SparkAdvanced.SparkModel model = SparkAdvanced.getModel((CanMessage)message);
        if (model == SparkAdvanced.SparkModel.SPARK_MAX) {
            return RecognizedDevice.SPARK_MAX;
        }
        if (model == SparkAdvanced.SparkModel.SPARK_FLEX) {
            return RecognizedDevice.SPARK_FLEX;
        }
        if (model == SparkAdvanced.SparkModel.UNKNOWN) {
            SparkAdvanced.SparkFirmwareVersion version = SparkAdvanced.getFirmwareVersion((CanBridge)bridge, (CanBus)bus, (int)canId);
            if (version == null) {
                return RecognizedDevice.UNKNOWN_SPARK;
            }
            int versionParameter = SparkAdvanced.readParameterInt32((CanBridge)bridge, (CanBus)bus, (int)canId, (int)SparkParameters.kProductId.value);
            return RecognizedDevice.getSparkTypeFromProductId(versionParameter);
        }
        return RecognizedDevice.UNKNOWN_SPARK;
    }

    private static RecognizedDevice getEncoderModel(CanBridge bridge, CanBus bus, CanMessage message, int canId) {
        EncoderAdvanced.EncoderModel model = EncoderAdvanced.getEncoderModel((CanMessage)message);
        return switch (model) {
            default -> throw new MatchException(null, null);
            case EncoderAdvanced.EncoderModel.MAXSPLINE -> RecognizedDevice.MAXSPLINE_ENCODER;
            case EncoderAdvanced.EncoderModel.UNKNOWN -> RecognizedDevice.UNKNOWN_ENCODER;
        };
    }

    private static RecognizedDevice getEncoderModelFromBootloader(CanMessage message) {
        int productId = EncoderCanSpec.bootloader0Unpack((byte[])message.data()).productID();
        return switch (productId) {
            case 36872 -> RecognizedDevice.MAXSPLINE_ENCODER;
            default -> RecognizedDevice.UNKNOWN_ENCODER;
        };
    }
}

