/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.device.detection.detectors;

import com.revrobotics.device.detection.AllCanFrames;
import com.revrobotics.device.detection.Detector;
import com.revrobotics.device.detection.device.DeviceTree;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.device.detection.device.RecognizedDevice;
import com.revrobotics.device.detection.gsusb.GSUsbManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class GsUsbDetector {
    private final GSUsbManager gsUsbManager;

    public GsUsbDetector(GSUsbManager gsUsbManager) {
        this.gsUsbManager = gsUsbManager;
    }

    public Detector.DeviceDetector gsUsbDeviceDetector() {
        return new Detector.DeviceDetector(){
            List<GSUsbManager.GsUsbDevice> gsUsbDevices;

            @Override
            public void iterate(AllCanFrames allFrames) {
                this.gsUsbDevices = GsUsbDetector.this.gsUsbManager != null ? GsUsbDetector.this.gsUsbManager.listGsUsbDevices() : List.of();
            }

            @Override
            public List<DeviceTree> devicesToRemove(List<DeviceTree> devices) {
                return devices.stream().filter(device -> GsUsbDetector.this.gsUsbDeviceCanBeRemoved(this.gsUsbDevices, (DeviceTree)device)).toList();
            }

            @Override
            public List<DeviceTree> devicesToAdd(List<DeviceTree> devices) {
                ArrayList<DeviceTree> addedDevices = new ArrayList<DeviceTree>();
                for (GSUsbManager.GsUsbDevice device : this.gsUsbDevices) {
                    Optional<DeviceTree> matchingDeviceTree = devices.stream().filter(tree -> Objects.equals(tree.descriptor(), device.descriptor())).findFirst();
                    if (!matchingDeviceTree.isEmpty()) continue;
                    FRCCanDevice gsUsbDevice = new FRCCanDevice(device.descriptor(), 0, false, RecognizedDevice.GS_USB, UUID.randomUUID());
                    DeviceTree newTree = new DeviceTree(gsUsbDevice, device.descriptor(), Collections.emptyList());
                    addedDevices.add(newTree);
                }
                return addedDevices;
            }

            @Override
            public List<DeviceTree> updateDeviceTrees(List<DeviceTree> devices) {
                return List.of();
            }
        };
    }

    private boolean gsUsbDeviceCanBeRemoved(List<GSUsbManager.GsUsbDevice> gsUsbDevices, DeviceTree device) {
        return RecognizedDevice.isGsUsb(device.root().type()) && gsUsbDevices.stream().noneMatch(gsUsbDevice -> gsUsbDevice.descriptor().equals(device.descriptor()));
    }
}

