/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.executable;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class ExecutableFinder {
    public static Path findExecutable(String name) {
        Path target;
        String osName = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        Path executableFolder = ExecutableFinder.getBaseExecutableFolder();
        if (System.getProperty("app.dir") != null) {
            return osName.contains("win") ? executableFolder.resolve(name + ".exe") : executableFolder.resolve(name);
        }
        if (osName.contains("win")) {
            target = executableFolder.resolve("windows").resolve(name + ".exe");
        } else if (osName.contains("mac") && arch.contains("amd64")) {
            target = executableFolder.resolve("mac-x64").resolve(name);
        } else if (osName.contains("mac") && arch.contains("aarch64")) {
            target = executableFolder.resolve("mac-arm64").resolve(name);
        } else if (osName.contains("linux")) {
            target = executableFolder.resolve("linux-x64").resolve(name);
        } else {
            throw new IllegalStateException("Unsupported operating system: " + osName + " or arch: " + arch);
        }
        if (!Files.exists(target, new LinkOption[0])) {
            throw new IllegalStateException(String.valueOf(target) + " does not exist");
        }
        return target;
    }

    private static Path getBaseExecutableFolder() {
        String appDir = System.getProperty("app.dir");
        if (appDir == null) {
            Path bundledDir = Path.of("..", new String[0]).resolve("..").resolve("bundled-exes").toAbsolutePath().normalize();
            if (!bundledDir.getFileName().toString().equals("bundled-exes")) {
                throw new IllegalStateException(String.valueOf(bundledDir) + " is not the bundled exe directory");
            }
            return bundledDir;
        }
        Path appPath = Path.of(appDir, new String[0]);
        return System.getProperty("os.name").toLowerCase().contains("linux") ? appPath.resolve("bin") : appPath.resolve("..").resolve("bin");
    }
}

