/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app;

import com.revrobotics.PersistMode;
import com.revrobotics.ResetMode;
import com.revrobotics.SparkAdvanced;
import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.canbridge.slcan.SLCanBridge;
import com.revrobotics.device.detection.Detector;
import com.revrobotics.device.detection.DeviceDaemon;
import com.revrobotics.device.detection.device.DeviceType;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.device.detection.device.Manufacturer;
import com.revrobotics.jni.CANSparkJNI;
import com.revrobotics.revlib.support.PlainSpark;
import com.revrobotics.revui.app.CanBridgeController;
import com.revrobotics.revui.app.annotations.ChecksForResponse;
import com.revrobotics.revui.app.annotations.EnforcesDeviceType;
import com.revrobotics.revui.app.annotations.EnforcesParameterType;
import com.revrobotics.revui.app.annotations.StandardExceptions;
import com.revrobotics.revui.app.annotations.Success;
import com.revrobotics.revui.app.devices.SparkController;
import com.revrobotics.revui.app.exceptions.ActionFailedException;
import com.revrobotics.revui.app.exceptions.DeviceNotPresentException;
import com.revrobotics.revui.app.exceptions.IllegalParameterType;
import com.revrobotics.revui.app.exceptions.ParameterDoesntExistException;
import com.revrobotics.revui.app.exceptions.WrongDeviceTypeException;
import com.revrobotics.revui.app.validation.CanID;
import com.revrobotics.spark.SparkBase;
import com.revrobotics.spark.config.SparkBaseConfig;
import com.revrobotics.spark.config.SparkMaxConfig;
import com.revrobotics.spark.config.SparkParameters;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:3000"})
@RestController
@RequestMapping(value={"/v1/bus/{descriptor}/spark/{uuid}/parameter"})
@Validated
public class SparkParameterController {
    @Autowired
    DeviceDaemon deviceDaemon;

    @Success
    @GetMapping(value={"/count"})
    public int numParameters(@PathVariable String descriptor, @PathVariable UUID uuid) {
        return SparkParameters.values().length;
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/info/{index}"})
    public SparkController.ParameterInfo getParameterInfo(@PathVariable String descriptor, @PathVariable UUID uuid, @PathVariable int index) {
        SparkParameters parameter = this.getParameterByIndex(index);
        if (parameter == null) {
            throw new ParameterDoesntExistException(index);
        }
        return new SparkController.ParameterInfo(parameter.name(), parameter.value, parameter.type);
    }

    @GetMapping(value={"/value"})
    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @ChecksForResponse
    public Object getParameterValue(@PathVariable String descriptor, @PathVariable UUID uuid, int index) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        SparkParameters parameter = this.getParameterByIndex(index);
        if (parameter == null) {
            throw new ParameterDoesntExistException(index);
        }
        SparkBase device = this.getSpark(decodedDescriptor, uuid);
        PlainSpark spark = (PlainSpark)device;
        try {
            return this.readParameterValue(decodedDescriptor, spark, parameter);
        }
        catch (IllegalStateException e) {
            throw new ActionFailedException();
        }
    }

    private Object readParameterValue(String decodedDescriptor, PlainSpark spark, SparkParameters parameter) {
        return this.deviceDaemon.doWithRawCanBridge(decodedDescriptor, (bridge, bus) -> {
            switch (parameter.type) {
                case UINT32: {
                    int result = SparkAdvanced.readParameterInt32((CanBridge)bridge, (CanBus)bus, (int)spark.getDeviceId(), (int)parameter.value);
                    return Long.valueOf((long)result & 0xFFFFFFFFL);
                }
                case INT32: {
                    return Integer.valueOf(SparkAdvanced.readParameterInt32((CanBridge)bridge, (CanBus)bus, (int)spark.getDeviceId(), (int)parameter.value));
                }
                case FLOAT: {
                    return Float.valueOf(SparkAdvanced.readParameterFloat((CanBridge)bridge, (CanBus)bus, (int)spark.getDeviceId(), (int)parameter.value));
                }
                case BOOL: {
                    return Boolean.valueOf(SparkAdvanced.readParameterBool((CanBridge)bridge, (CanBus)bus, (int)spark.getDeviceId(), (int)parameter.value));
                }
            }
            throw new IllegalArgumentException("Type was unknown");
        });
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @ChecksForResponse
    @GetMapping(value={"/value/all"})
    public AllSparkParameters allParameters(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        HashMap<Integer, Object> paramValues = new HashMap<Integer, Object>();
        SparkBase device = this.getSpark(decodedDescriptor, uuid);
        PlainSpark spark = (PlainSpark)device;
        try {
            for (SparkParameters parameter : SparkParameters.values()) {
                Object value = this.readParameterValue(decodedDescriptor, spark, parameter);
                paramValues.put(parameter.value, value);
            }
        }
        catch (IllegalStateException e) {
            throw new ActionFailedException();
        }
        return new AllSparkParameters(paramValues);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @EnforcesParameterType
    @PostMapping(value={"/value"})
    public void setParameterValue(@PathVariable String descriptor, @PathVariable UUID uuid, int index, @RequestBody @Parameter(schema=@Schema(oneOf={Integer.class, Float.class, Boolean.class})) String value) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        SparkParameters parameter = this.getParameterByIndex(index);
        if (parameter == null) {
            throw new ParameterDoesntExistException(index);
        }
        SparkBase device = this.getSpark(decodedDescriptor, uuid);
        PlainSpark spark = (PlainSpark)device;
        try {
            SparkParameterController.setSparkParameterByIndex(index, value, parameter, spark);
        }
        catch (NumberFormatException e) {
            throw new IllegalParameterType(index);
        }
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/burn"})
    public void burnFlash(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        SparkBase spark = this.getSpark(decodedDescriptor, uuid);
        spark.configure((SparkBaseConfig)new SparkMaxConfig(), ResetMode.kNoResetSafeParameters, PersistMode.kPersistParameters);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/reset/safe"})
    public void resetSafe(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        SparkBase spark = this.getSpark(decodedDescriptor, uuid);
        spark.configure((SparkBaseConfig)new SparkMaxConfig(), ResetMode.kResetSafeParameters, PersistMode.kNoPersistParameters);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/reset/all"})
    public boolean resetAll(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        SparkBase spark = this.getSpark(decodedDescriptor, uuid);
        return (Boolean)this.deviceDaemon.doWithRawCanBridge(decodedDescriptor, (canBridge, bus) -> {
            boolean result = SparkAdvanced.fullFactoryResetWithRetries((CanBridge)canBridge, (CanBus)bus, (int)spark.getDeviceId());
            if (canBridge instanceof SLCanBridge) {
                ((SLCanBridge)canBridge).openPorts();
            }
            return result;
        });
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/canid"})
    public UUID setCanId(@PathVariable String descriptor, @PathVariable UUID uuid, @RequestBody @CanID int canId) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        SparkBase device = this.getSpark(decodedDescriptor, uuid);
        PlainSpark spark = (PlainSpark)device;
        SparkParameterController.setSparkParameterByIndex(0, String.valueOf(canId), SparkParameters.kCANID, spark);
        return Detector.deviceUUID((int)canId, (DeviceType)DeviceType.MOTOR_CONTROLLER, (Manufacturer)Manufacturer.REV);
    }

    private static void setSparkParameterByIndex(int index, String value, SparkParameters parameter, PlainSpark spark) {
        switch (parameter.type) {
            case UINT32: {
                int i = Integer.parseUnsignedInt(value);
                CANSparkJNI.c_Spark_SetParameterUint32((long)spark.getHandle(), (int)parameter.value, (int)i);
                break;
            }
            case INT32: {
                int i = Integer.parseUnsignedInt(value);
                CANSparkJNI.c_Spark_SetParameterInt32((long)spark.getHandle(), (int)parameter.value, (int)i);
                break;
            }
            case FLOAT: {
                float f = Float.parseFloat(value);
                CANSparkJNI.c_Spark_SetParameterFloat32((long)spark.getHandle(), (int)parameter.value, (float)f);
                break;
            }
            case BOOL: {
                boolean b = Boolean.parseBoolean(value);
                CANSparkJNI.c_Spark_SetParameterBool((long)spark.getHandle(), (int)parameter.value, (boolean)b);
                break;
            }
            default: {
                throw new IllegalParameterType(index);
            }
        }
    }

    private SparkParameters getParameterByIndex(int index) {
        for (SparkParameters parameter : SparkParameters.values()) {
            if (parameter.value != index) continue;
            return parameter;
        }
        return null;
    }

    private SparkBase getSpark(String descriptor, UUID uuid) {
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(descriptor, uuid);
        this.throwIfNeeded(device, uuid);
        SparkBase result = this.deviceDaemon.getDeviceManager().getRevLibDeviceManager().getSpark(device.id());
        if (result == null) {
            throw new DeviceNotPresentException(uuid);
        }
        return result;
    }

    private void throwIfNeeded(FRCCanDevice device, UUID uuid) {
        if (device == null) {
            throw new DeviceNotPresentException(uuid);
        }
        if (device.type() == null || !device.type().isSPARK()) {
            throw new WrongDeviceTypeException();
        }
    }

    public record AllSparkParameters(Map<Integer, Object> paramTable) {
    }
}

