/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app.devices;

import com.revrobotics.EncoderAdvanced;
import com.revrobotics.ResetMode;
import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.device.detection.Detector;
import com.revrobotics.device.detection.DeviceDaemon;
import com.revrobotics.device.detection.device.DeviceType;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.device.detection.device.Manufacturer;
import com.revrobotics.device.detection.device.RecognizedDevice;
import com.revrobotics.encoder.DetachedEncoder;
import com.revrobotics.encoder.config.DetachedEncoderConfig;
import com.revrobotics.encoder.config.DetachedSignalsConfig;
import com.revrobotics.revui.app.CanBridgeController;
import com.revrobotics.revui.app.annotations.EnforcesDeviceType;
import com.revrobotics.revui.app.annotations.StandardExceptions;
import com.revrobotics.revui.app.annotations.Success;
import com.revrobotics.revui.app.exceptions.DeviceNotPresentException;
import com.revrobotics.revui.app.exceptions.WrongDeviceTypeException;
import java.util.UUID;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/bus/{descriptor}/encoder/{uuid}"})
public class EncoderController {
    private static final Logger logger = Logger.getLogger(EncoderController.class.getName());
    @Autowired
    DeviceDaemon deviceDaemon;

    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/identify"})
    public void identify(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        this.deviceDaemon.doWithRawCanBridge(CanBridgeController.decodeDescriptor(descriptor), (bridge, bus) -> {
            EncoderAdvanced.identify((CanBridge)bridge, (CanBus)bus, (int)encoder.getDeviceId());
            return null;
        });
    }

    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/position"})
    public double getPosition(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return encoder.getPosition();
    }

    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/velocity"})
    public double getVelocity(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return encoder.getVelocity();
    }

    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/angle"})
    public double getAngle(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return encoder.getAngle();
    }

    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/version"})
    public DetachedEncoder.FirmwareVersion getVersion(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return encoder.getFirmwareVersion();
    }

    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/faults"})
    public FaultsAndSticky getFaults(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return new FaultsAndSticky(encoder.getFaults(), encoder.getStickyFaults());
    }

    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/faults/clear"})
    public void clearFaults(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        encoder.clearFaults();
    }

    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/parameter/reset"})
    public void resetParameters(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        encoder.configure(new DetachedEncoderConfig(), ResetMode.kResetSafeParameters);
    }

    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/parameter/inverted"})
    public boolean getInverted(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return encoder.detachedEncoderAccessor.isInverted();
    }

    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/parameter/average_depth"})
    public int getAverageDepth(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return encoder.detachedEncoderAccessor.getAverageDepth();
    }

    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/parameter/position_conversion_factor"})
    public float getPositionConversionFactor(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return encoder.detachedEncoderAccessor.getPositionConversionFactor();
    }

    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/parameter/velocity_conversion_factor"})
    public float getVelocityConversionFactor(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return encoder.detachedEncoderAccessor.getVelocityConversionFactor();
    }

    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/parameter/zero_centered"})
    public boolean getZeroCentered(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return encoder.detachedEncoderAccessor.isDutyCycleZeroCentered();
    }

    @StandardExceptions
    @EnforcesDeviceType
    @Deprecated(forRemoval=true)
    @GetMapping(value={"/parameter/absolute_average_depth"})
    public int getAbsoluteAverageDepth(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return encoder.detachedEncoderAccessor.getAverageDepth();
    }

    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/parameter/absolute_offset"})
    public float getAbsoluteOffset(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return encoder.detachedEncoderAccessor.getDutyCycleOffset();
    }

    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/parameter/start_pulse_us"})
    public double getStartPulseUs(@PathVariable String descriptor, @PathVariable UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return encoder.detachedEncoderAccessor.getDutyCycleStartPulseUs();
    }

    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/parameter/end_pulse_us"})
    public double getEndPulseUs(@PathVariable String descriptor, @PathVariable UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return encoder.detachedEncoderAccessor.getDutyCycleEndPulseUs();
    }

    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/parameter/absolute_period"})
    public double getAbsolutePeriod(@PathVariable String descriptor, @PathVariable UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return encoder.detachedEncoderAccessor.getDutyCyclePeriodUs();
    }

    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/parameter/status_frame_period"})
    public double getStatusFramePeriod(@PathVariable String descriptor, @PathVariable UUID uuid, int frame) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return switch (frame) {
            case 2 -> encoder.detachedEncoderAccessor.signals.getEncoderPositionPeriodMs();
            case 3 -> encoder.detachedEncoderAccessor.signals.getEncoderVelocityPeriodMs();
            case 4 -> encoder.detachedEncoderAccessor.signals.getEncoderAnglePeriodMs();
            default -> throw new IllegalArgumentException("No getter for frame " + frame);
        };
    }

    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/parameter/angle_conversion_factor"})
    public double getAngleConversionFactor(@PathVariable String descriptor, @PathVariable UUID uuid) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return encoder.detachedEncoderAccessor.getAngleConversionFactor();
    }

    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/parameter/inverted"})
    public void setInverted(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid, boolean value) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        encoder.configure(new DetachedEncoderConfig().inverted(value), ResetMode.kNoResetSafeParameters);
    }

    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/parameter/average_depth"})
    public void setAverageDepth(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid, int value) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        encoder.configure(new DetachedEncoderConfig().averageDepth(value), ResetMode.kNoResetSafeParameters);
    }

    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/parameter/position_conversion_factor"})
    public void setPositionConversionFactor(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid, float value) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        encoder.configure(new DetachedEncoderConfig().positionConversionFactor((double)value), ResetMode.kNoResetSafeParameters);
    }

    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/parameter/angle_conversion_factor"})
    public void setAngleConversionFactor(@PathVariable String descriptor, @PathVariable UUID uuid, float value) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        encoder.configure(new DetachedEncoderConfig().angleConversionFactor((double)value), ResetMode.kNoResetSafeParameters);
    }

    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/parameter/status_frame_period"})
    public void setStatusFramePeriod(@PathVariable String descriptor, @PathVariable UUID uuid, int frame, int value) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        DetachedEncoderConfig config = new DetachedEncoderConfig();
        DetachedSignalsConfig signals = config.signals;
        switch (frame) {
            case 2: {
                signals.encoderPositionPeriodMs(value);
                break;
            }
            case 3: {
                signals.encoderVelocityPeriodMs(value);
                break;
            }
            case 4: {
                signals.encoderAnglePeriodMs(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid status frame period");
            }
        }
        encoder.configure(config, ResetMode.kNoResetSafeParameters);
    }

    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/parameter/velocity_conversion_factor"})
    public void setVelocityConversionFactor(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid, float value) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        encoder.configure(new DetachedEncoderConfig().velocityConversionFactor((double)value), ResetMode.kNoResetSafeParameters);
    }

    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/parameter/zero_centered"})
    public void setZeroCentered(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid, boolean value) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        encoder.configure(new DetachedEncoderConfig().dutyCycleZeroCentered(value), ResetMode.kNoResetSafeParameters);
    }

    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/parameter/absolute_offset"})
    public void setAbsoluteOffset(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid, float value) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        encoder.configure(new DetachedEncoderConfig().dutyCycleOffset((double)value), ResetMode.kNoResetSafeParameters);
    }

    @StandardExceptions
    @EnforcesDeviceType
    @Deprecated(forRemoval=true)
    @PostMapping(value={"/parameter/absolute_average_depth"})
    public void setAbsoluteAverageDepth(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid, int value) {
        System.out.println("Set absolute average depth is a no-op");
    }

    @StandardExceptions
    @EnforcesDeviceType
    @Deprecated(forRemoval=true)
    @PostMapping(value={"/parameter/start_pulse_us"})
    public void setStartPulseUs(@PathVariable String descriptor, @PathVariable UUID uuid, float value) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        encoder.configure(new DetachedEncoderConfig().dutyCycleStartPulseUs((double)value), ResetMode.kNoResetSafeParameters);
    }

    @StandardExceptions
    @EnforcesDeviceType
    @Deprecated(forRemoval=true)
    @PostMapping(value={"/parameter/end_pulse_us"})
    public void setEndPulseUs(@PathVariable String descriptor, @PathVariable UUID uuid, float value) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        encoder.configure(new DetachedEncoderConfig().dutyCycleEndPulseUs((double)value), ResetMode.kNoResetSafeParameters);
    }

    @StandardExceptions
    @EnforcesDeviceType
    @Deprecated(forRemoval=true)
    @PostMapping(value={"/parameter/absolute_period"})
    public void setAbsolutePeriod(@PathVariable String descriptor, @PathVariable UUID uuid, float value) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        encoder.configure(new DetachedEncoderConfig().dutyCyclePeriodUs((double)value), ResetMode.kNoResetSafeParameters);
    }

    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/id"})
    public UUID setCanID(@PathVariable(value="descriptor") String descriptor, @PathVariable(value="uuid") UUID uuid, int value) {
        DetachedEncoder encoder = this.getEncoder(descriptor, uuid);
        return (UUID)this.deviceDaemon.doWithRawCanBridge(CanBridgeController.decodeDescriptor(descriptor), (bridge, bus) -> {
            EncoderAdvanced.setCanId((CanBridge)bridge, (CanBus)bus, (int)encoder.getDeviceId(), (int)value);
            return Detector.deviceUUID((int)value, (DeviceType)DeviceType.ENCODER, (Manufacturer)Manufacturer.REV);
        });
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/usb-check"})
    public boolean usbCheck(@PathVariable String descriptor, @PathVariable UUID uuid) {
        return false;
    }

    private DetachedEncoder getEncoder(String descriptor, UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        if (device == null) {
            throw new DeviceNotPresentException(uuid);
        }
        if (device.type() != RecognizedDevice.MAXSPLINE_ENCODER) {
            throw new WrongDeviceTypeException();
        }
        DetachedEncoder encoder = this.deviceDaemon.getDeviceManager().getRevLibDeviceManager().getEncoder(device.id());
        if (encoder == null) {
            throw new DeviceNotPresentException(uuid);
        }
        return encoder;
    }

    public record FaultsAndSticky(DetachedEncoder.Faults faults, DetachedEncoder.Faults stickyFaults) {
    }
}

