/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.encoder.config;

import com.revrobotics.config.BaseConfig;
import com.revrobotics.encoder.config.DetachedEncoderParameter;
import com.revrobotics.encoder.config.DetachedSignalsConfig;

public class DetachedEncoderConfig
extends BaseConfig {
    public final DetachedSignalsConfig signals = new DetachedSignalsConfig();

    public DetachedEncoderConfig() {
        super(BaseConfig.CANType.kDetachedEncoder);
    }

    public DetachedEncoderConfig apply(DetachedEncoderConfig other) {
        super.apply(other);
        this.signals.apply(other.signals);
        return this;
    }

    public DetachedEncoderConfig apply(DetachedSignalsConfig config) {
        this.signals.apply(config);
        return this;
    }

    public DetachedEncoderConfig inverted(boolean inverted) {
        this.putParameter(DetachedEncoderParameter.kEncoderInverted.getIndex(), inverted);
        return this;
    }

    public DetachedEncoderConfig velocityConversionFactor(double factor) {
        this.putParameter(DetachedEncoderParameter.kVelocityConversionFactor.getIndex(), (float)factor);
        return this;
    }

    public DetachedEncoderConfig averageDepth(int depth) {
        this.putParameter(DetachedEncoderParameter.kEncoderAverageDepth.getIndex(), depth);
        return this;
    }

    public DetachedEncoderConfig positionConversionFactor(double factor) {
        this.putParameter(DetachedEncoderParameter.kPositionConversionFactor.getIndex(), (float)factor);
        return this;
    }

    public DetachedEncoderConfig angleConversionFactor(double factor) {
        this.putParameter(DetachedEncoderParameter.kAngleConversionFactor.getIndex(), (float)factor);
        return this;
    }

    public DetachedEncoderConfig dutyCycleZeroCentered(boolean isZeroCentered) {
        this.putParameter(DetachedEncoderParameter.kDutyCycleZeroCentered.getIndex(), isZeroCentered);
        return this;
    }

    public DetachedEncoderConfig dutyCycleOffset(double offset) {
        this.putParameter(DetachedEncoderParameter.kDutyCycleOffset.getIndex(), (float)offset);
        return this;
    }

    public DetachedEncoderConfig dutyCycleStartPulseUs(double startPulseUs) {
        this.putParameter(DetachedEncoderParameter.kDutyCycleStartPulseUs.getIndex(), (float)startPulseUs);
        return this;
    }

    public DetachedEncoderConfig dutyCycleEndPulseUs(double endPulseUs) {
        this.putParameter(DetachedEncoderParameter.kDutyCycleEndPulseUs.getIndex(), (float)endPulseUs);
        return this;
    }

    public DetachedEncoderConfig dutyCyclePeriodUs(double periodUs) {
        this.putParameter(DetachedEncoderParameter.kDutyCyclePeriodUs.getIndex(), (float)periodUs);
        return this;
    }

    @Override
    public String flatten() {
        String flattenedString = "";
        flattenedString = flattenedString + super.flatten();
        flattenedString = flattenedString + this.signals.flatten();
        return flattenedString;
    }
}

