/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.encoder.config;

import com.revrobotics.config.BaseConfig;
import com.revrobotics.encoder.config.DetachedEncoderParameter;

public class DetachedSignalsConfig
extends BaseConfig {
    public DetachedSignalsConfig() {
        super(BaseConfig.CANType.kDetachedEncoder);
    }

    private void setPeriodMsCore(int parameterId, int periodMs) {
        Object value = this.getParameter(parameterId);
        if (value == null) {
            this.putParameter(parameterId, periodMs);
        } else {
            int currentPeriodMs = (Integer)value;
            this.putParameter(parameterId, Math.min(currentPeriodMs, periodMs));
        }
    }

    public DetachedSignalsConfig apply(DetachedSignalsConfig config) {
        super.apply(config);
        return this;
    }

    public DetachedSignalsConfig encoderPositionPeriodMs(int periodMs) {
        this.setPeriodMsCore(DetachedEncoderParameter.kStatus3Period.getIndex(), periodMs);
        return this;
    }

    public DetachedSignalsConfig encoderVelocityPeriodMs(int periodMs) {
        this.setPeriodMsCore(DetachedEncoderParameter.kStatus4Period.getIndex(), periodMs);
        return this;
    }

    public DetachedSignalsConfig encoderAnglePeriodMs(int periodMs) {
        this.setPeriodMsCore(DetachedEncoderParameter.kStatus2Period.getIndex(), periodMs);
        return this;
    }
}

