/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.sim;

import com.revrobotics.servohub.ServoHub;
import edu.wpi.first.hal.SimBoolean;
import edu.wpi.first.wpilibj.simulation.SimDeviceSim;

public class ServoHubSimFaultManager {
    private SimBoolean m_regulatorPGoodFault;
    private SimBoolean m_firmwareFault;
    private SimBoolean m_hardwareFault;
    private SimBoolean m_lowBatteryFault;
    private SimBoolean m_regulatorPGoodStickyFault;
    private SimBoolean m_firmwareStickyFault;
    private SimBoolean m_hardwareStickyFault;
    private SimBoolean m_lowBatteryStickyFault;
    private SimBoolean m_brownoutWarning;
    private SimBoolean m_canWarning;
    private SimBoolean m_canBusOffWarning;
    private SimBoolean m_hasResetWarning;
    private SimBoolean m_channel0OvercurrentWarning;
    private SimBoolean m_channel1OvercurrentWarning;
    private SimBoolean m_channel2OvercurrentWarning;
    private SimBoolean m_channel3OvercurrentWarning;
    private SimBoolean m_channel4OvercurrentWarning;
    private SimBoolean m_channel5OvercurrentWarning;
    private SimBoolean m_brownoutStickyWarning;
    private SimBoolean m_canStickyWarning;
    private SimBoolean m_canBusOffStickyWarning;
    private SimBoolean m_hasResetStickyWarning;
    private SimBoolean m_channel0OvercurrentStickyWarning;
    private SimBoolean m_channel1OvercurrentStickyWarning;
    private SimBoolean m_channel2OvercurrentStickyWarning;
    private SimBoolean m_channel3OvercurrentStickyWarning;
    private SimBoolean m_channel4OvercurrentStickyWarning;
    private SimBoolean m_channel5OvercurrentStickyWarning;
    private ServoHub m_servoHub;
    private String simDeviceName;

    public ServoHubSimFaultManager(ServoHub servoHub) {
        this.simDeviceName = "Servo Hub [" + servoHub.getDeviceId() + "] FAULT MANAGER";
        this.m_servoHub = servoHub;
        this.setupSimDevice();
    }

    private void setupSimDevice() {
        this.m_servoHub.createSimFaultManager();
        SimDeviceSim faultManager = new SimDeviceSim(this.simDeviceName);
        this.m_regulatorPGoodFault = faultManager.getBoolean("Regulator P Good Fault");
        this.m_firmwareFault = faultManager.getBoolean("Firmware Fault");
        this.m_hardwareFault = faultManager.getBoolean("Hardware Fault");
        this.m_lowBatteryFault = faultManager.getBoolean("Low Battery Fault");
        this.m_regulatorPGoodStickyFault = faultManager.getBoolean("Regulator P Good Sticky Fault");
        this.m_firmwareStickyFault = faultManager.getBoolean("Firmware Sticky Fault");
        this.m_hardwareStickyFault = faultManager.getBoolean("Hardware Sticky Fault");
        this.m_lowBatteryStickyFault = faultManager.getBoolean("Low Battery Sticky Fault");
        this.m_brownoutWarning = faultManager.getBoolean("Brownout Warning");
        this.m_canWarning = faultManager.getBoolean("CAN Warning");
        this.m_canBusOffWarning = faultManager.getBoolean("CAN Bus Off Warning");
        this.m_hasResetWarning = faultManager.getBoolean("Has Reset Warning");
        this.m_channel0OvercurrentWarning = faultManager.getBoolean("Channel 0 Over Current Warning");
        this.m_channel1OvercurrentWarning = faultManager.getBoolean("Channel 1 Over Current Warning");
        this.m_channel2OvercurrentWarning = faultManager.getBoolean("Channel 2 Over Current Warning");
        this.m_channel3OvercurrentWarning = faultManager.getBoolean("Channel 3 Over Current Warning");
        this.m_channel4OvercurrentWarning = faultManager.getBoolean("Channel 4 Over Current Warning");
        this.m_channel5OvercurrentWarning = faultManager.getBoolean("Channel 5 Over Current Warning");
        this.m_brownoutStickyWarning = faultManager.getBoolean("Brownout Sticky Warning");
        this.m_canStickyWarning = faultManager.getBoolean("CAN Sticky Warning");
        this.m_canBusOffStickyWarning = faultManager.getBoolean("CAN Bus Off Sticky Warning");
        this.m_hasResetStickyWarning = faultManager.getBoolean("Has Reset Sticky Warning");
        this.m_channel0OvercurrentStickyWarning = faultManager.getBoolean("Channel 0 Over Current Sticky Warning");
        this.m_channel1OvercurrentStickyWarning = faultManager.getBoolean("Channel 1 Over Current Sticky Warning");
        this.m_channel2OvercurrentStickyWarning = faultManager.getBoolean("Channel 2 Over Current Sticky Warning");
        this.m_channel3OvercurrentStickyWarning = faultManager.getBoolean("Channel 3 Over Current Sticky Warning");
        this.m_channel4OvercurrentStickyWarning = faultManager.getBoolean("Channel 4 Over Current Sticky Warning");
        this.m_channel5OvercurrentStickyWarning = faultManager.getBoolean("Channel 5 Over Current Sticky Warning");
    }

    public void setFaults(ServoHub.Faults faults) {
        this.m_regulatorPGoodFault.set(faults.regulatorPowerGood);
        this.m_firmwareFault.set(faults.firmware);
        this.m_hardwareFault.set(faults.hardware);
        this.m_lowBatteryFault.set(faults.lowBattery);
    }

    public void setStickyFaults(ServoHub.Faults faults) {
        this.m_regulatorPGoodStickyFault.set(faults.regulatorPowerGood);
        this.m_firmwareStickyFault.set(faults.firmware);
        this.m_hardwareStickyFault.set(faults.hardware);
        this.m_lowBatteryStickyFault.set(faults.lowBattery);
    }

    public void setWarnings(ServoHub.Warnings warnings) {
        this.m_brownoutWarning.set(warnings.brownout);
        this.m_canWarning.set(warnings.canWarning);
        this.m_canBusOffWarning.set(warnings.canBusOff);
        this.m_hasResetWarning.set(warnings.hasReset);
        this.m_channel0OvercurrentWarning.set(warnings.channel0Overcurrent);
        this.m_channel1OvercurrentWarning.set(warnings.channel1Overcurrent);
        this.m_channel2OvercurrentWarning.set(warnings.channel2Overcurrent);
        this.m_channel3OvercurrentWarning.set(warnings.channel3Overcurrent);
        this.m_channel4OvercurrentWarning.set(warnings.channel4Overcurrent);
        this.m_channel5OvercurrentWarning.set(warnings.channel5Overcurrent);
    }

    public void setStickyWarnings(ServoHub.Warnings warnings) {
        this.m_brownoutStickyWarning.set(warnings.brownout);
        this.m_canStickyWarning.set(warnings.canWarning);
        this.m_canBusOffStickyWarning.set(warnings.canBusOff);
        this.m_hasResetStickyWarning.set(warnings.hasReset);
        this.m_channel0OvercurrentStickyWarning.set(warnings.channel0Overcurrent);
        this.m_channel1OvercurrentStickyWarning.set(warnings.channel1Overcurrent);
        this.m_channel2OvercurrentStickyWarning.set(warnings.channel2Overcurrent);
        this.m_channel3OvercurrentStickyWarning.set(warnings.channel3Overcurrent);
        this.m_channel4OvercurrentStickyWarning.set(warnings.channel4Overcurrent);
        this.m_channel5OvercurrentStickyWarning.set(warnings.channel5Overcurrent);
    }
}

