/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark;

import com.revrobotics.NativeResourceCleaner;
import com.revrobotics.REVDevice;
import com.revrobotics.REVLibError;
import com.revrobotics.jni.CANSparkJNI;
import com.revrobotics.spark.SparkBase;
import edu.wpi.first.wpilibj.motorcontrol.MotorController;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.Nullable;

public abstract class SparkLowLevel
extends NativeResourceCleaner
implements MotorController,
REVDevice,
AutoCloseable {
    public static final int kAPIMajorVersion = CANSparkJNI.c_Spark_GetAPIMajorRevision();
    public static final int kAPIMinorVersion = CANSparkJNI.c_Spark_GetAPIMinorRevision();
    public static final int kAPIBuildVersion = CANSparkJNI.c_Spark_GetAPIBuildRevision();
    public static final int kAPIVersion = CANSparkJNI.c_Spark_GetAPIVersion();
    protected final long sparkHandle;
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final int deviceId;
    private String firmwareString;
    protected final MotorType motorType;
    protected final SparkModel expectedSparkModel;

    SparkLowLevel(int deviceId, MotorType type, SparkModel model) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        this.deviceId = deviceId;
        this.firmwareString = "";
        this.motorType = type;
        this.expectedSparkModel = model;
        if (CANSparkJNI.c_Spark_RegisterId(deviceId) == REVLibError.kDuplicateCANId.value) {
            throw new IllegalStateException("A CANSparkMax instance has already been created with this device ID: " + deviceId);
        }
        this.sparkHandle = CANSparkJNI.c_Spark_Create(deviceId, type.value, model.id);
        this.registerCleaner(this.sparkHandle);
    }

    @Override
    public void close() {
        boolean wasClosed = this.isClosed.getAndSet(true);
        if (wasClosed) {
            return;
        }
        CANSparkJNI.c_Spark_Close(this.sparkHandle);
    }

    @Override
    protected NativeResourceCleaner.OnClean getCleanAction() {
        return CANSparkJNI::c_Spark_Destroy;
    }

    public int getFirmwareVersion() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetFirmwareVersion(this.sparkHandle);
    }

    public void setControlFramePeriodMs(int periodMs) {
        this.throwIfClosed();
        CANSparkJNI.c_Spark_SetControlFramePeriod(this.sparkHandle, periodMs);
    }

    public String getFirmwareString() {
        this.throwIfClosed();
        if (this.firmwareString == "") {
            int version = this.getFirmwareVersion();
            ByteBuffer b = ByteBuffer.allocate(4);
            b.putInt(version);
            byte[] verBytes = b.array();
            StringBuilder firmwareString = new StringBuilder();
            firmwareString.append("v").append(verBytes[0]).append(".").append(verBytes[1]).append(".").append(verBytes[2] << 8 | verBytes[3]);
            this.firmwareString = firmwareString.toString();
        }
        return this.firmwareString;
    }

    public byte[] getSerialNumber() {
        this.throwIfClosed();
        return new byte[0];
    }

    public int getDeviceId() {
        this.throwIfClosed();
        return this.deviceId;
    }

    public MotorType getMotorType() {
        this.throwIfClosed();
        return this.motorType;
    }

    public void setPeriodicFrameTimeout(int timeoutMs) {
        this.throwIfClosed();
        CANSparkJNI.c_Spark_SetPeriodicFrameTimeout(this.sparkHandle, timeoutMs);
    }

    public @Nullable PeriodicStatus0 getPeriodicStatus0() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetPeriodicStatus0(this.sparkHandle);
    }

    public @Nullable PeriodicStatus1 getPeriodicStatus1() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetPeriodicStatus1(this.sparkHandle);
    }

    public @Nullable PeriodicStatus2 getPeriodicStatus2() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetPeriodicStatus2(this.sparkHandle);
    }

    public @Nullable PeriodicStatus3 getPeriodicStatus3() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetPeriodicStatus3(this.sparkHandle);
    }

    public @Nullable PeriodicStatus4 getPeriodicStatus4() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetPeriodicStatus4(this.sparkHandle);
    }

    public @Nullable PeriodicStatus5 getPeriodicStatus5() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetPeriodicStatus5(this.sparkHandle);
    }

    public @Nullable PeriodicStatus6 getPeriodicStatus6() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetPeriodicStatus6(this.sparkHandle);
    }

    public @Nullable PeriodicStatus7 getPeriodicStatus7() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetPeriodicStatus7(this.sparkHandle);
    }

    public @Nullable PeriodicStatus8 getPeriodicStatus8() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetPeriodicStatus8(this.sparkHandle);
    }

    public @Nullable PeriodicStatus9 getPeriodicStatus9() {
        this.throwIfClosed();
        return CANSparkJNI.c_Spark_GetPeriodicStatus9(this.sparkHandle);
    }

    public void setCANMaxRetries(int numRetries) {
        this.throwIfClosed();
        CANSparkJNI.c_Spark_SetCANMaxRetries(this.sparkHandle, numRetries);
    }

    REVLibError setpointCommand(double value) {
        this.throwIfClosed();
        return this.setpointCommand(value, SparkBase.ControlType.kDutyCycle);
    }

    REVLibError setpointCommand(double value, SparkBase.ControlType ctrl) {
        this.throwIfClosed();
        return this.setpointCommand(value, ctrl, 0);
    }

    REVLibError setpointCommand(double value, SparkBase.ControlType ctrl, int pidSlot) {
        this.throwIfClosed();
        return this.setpointCommand(value, ctrl, pidSlot, 0.0);
    }

    REVLibError setpointCommand(double value, SparkBase.ControlType ctrl, int pidSlot, double arbFeedforward) {
        this.throwIfClosed();
        return this.setpointCommand(value, ctrl, pidSlot, arbFeedforward, 0);
    }

    REVLibError setpointCommand(double value, SparkBase.ControlType ctrl, int pidSlot, double arbFeedforward, int arbFFUnits) {
        this.throwIfClosed();
        return REVLibError.fromInt(CANSparkJNI.c_Spark_SetpointCommand(this.sparkHandle, (float)value, ctrl.value, pidSlot, (float)arbFeedforward, arbFFUnits));
    }

    public float getSafeFloat(float f) {
        this.throwIfClosed();
        if (Float.isNaN(f) || Float.isInfinite(f)) {
            return 0.0f;
        }
        return f;
    }

    public void createSimFaultManager() {
        CANSparkJNI.c_Spark_CreateSimFaultManager(this.sparkHandle);
    }

    protected void throwIfClosed() {
        if (this.isClosed.get()) {
            throw new IllegalStateException("This SPARK object has previously been closed.");
        }
    }

    public static enum MotorType {
        kBrushed(0),
        kBrushless(1);

        public final int value;

        private MotorType(int value) {
            this.value = value;
        }

        public static MotorType fromId(int id) {
            for (MotorType type : MotorType.values()) {
                if (type.value != id) continue;
                return type;
            }
            return null;
        }
    }

    protected static enum SparkModel {
        Unknown(0),
        SparkFlex(1),
        SparkMax(2);

        final int id;

        private SparkModel(int id) {
            this.id = id;
        }

        static SparkModel fromId(int id) {
            for (SparkModel model : SparkModel.values()) {
                if (model.id != id) continue;
                return model;
            }
            return Unknown;
        }
    }

    public static class PeriodicStatus0 {
        public double appliedOutput;
        public double voltage;
        public double current;
        public int motorTemperature;
        public boolean hardForwardLimitReached;
        public boolean hardReverseLimitReached;
        public boolean softForwardLimitReached;
        public boolean softReverseLimitReached;
        public boolean inverted;
        public boolean primaryHeartbeatLock;
    }

    public static class PeriodicStatus1 {
        public boolean otherFault;
        public boolean motorTypeFault;
        public boolean sensorFault;
        public boolean canFault;
        public boolean temperatureFault;
        public boolean drvFault;
        public boolean escEepromFault;
        public boolean firmwareFault;
        public boolean brownoutWarning;
        public boolean overcurrentWarning;
        public boolean escEepromWarning;
        public boolean extEepromWarning;
        public boolean sensorWarning;
        public boolean stallWarning;
        public boolean hasResetWarning;
        public boolean otherWarning;
        public boolean otherStickyFault;
        public boolean motorTypeStickyFault;
        public boolean sensorStickyFault;
        public boolean canStickyFault;
        public boolean temperatureStickyFault;
        public boolean drvStickyFault;
        public boolean escEepromStickyFault;
        public boolean firmwareStickyFault;
        public boolean brownoutStickyWarning;
        public boolean overcurrentStickyWarning;
        public boolean escEepromStickyWarning;
        public boolean extEepromStickyWarning;
        public boolean sensorStickyWarning;
        public boolean stallStickyWarning;
        public boolean hasResetStickyWarning;
        public boolean otherStickyWarning;
        public boolean isFollower;
    }

    public static class PeriodicStatus2 {
        public double primaryEncoderVelocity;
        public double primaryEncoderPosition;
    }

    public static class PeriodicStatus3 {
        public double analogVoltage;
        public double analogVelocity;
        public double analogPosition;
    }

    public static class PeriodicStatus4 {
        public double externalOrAltEncoderVelocity;
        public double externalOrAltEncoderPosition;
    }

    public static class PeriodicStatus5 {
        public double dutyCycleEncoderVelocity;
        public double dutyCycleEncoderPosition;
    }

    public static class PeriodicStatus6 {
        public double unadjustedDutyCycle;
        public double dutyCyclePeriod;
        public boolean dutyCycleNoSignal;
    }

    public static class PeriodicStatus7 {
        public double iAccumulation;
    }

    public static class PeriodicStatus8 {
        public double setpoint;
        public boolean isAtSetpoint;
        public int selectedPidSlot;
    }

    public static class PeriodicStatus9 {
        public double maxmotionSetpointPosition;
        public double maxmotionSetpointVelocity;
    }

    public static enum PeriodicFrame {
        kStatus0(0),
        kStatus1(1),
        kStatus2(2),
        kStatus3(3),
        kStatus4(4),
        kStatus5(5),
        kStatus6(6),
        kStatus7(7),
        kStatus8(8);

        public final int value;

        private PeriodicFrame(int value) {
            this.value = value;
        }

        public static PeriodicFrame fromId(int id) {
            for (PeriodicFrame type : PeriodicFrame.values()) {
                if (type.value != id) continue;
                return type;
            }
            return null;
        }
    }
}

