/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark.config;

import com.revrobotics.config.BaseConfig;
import com.revrobotics.spark.config.SparkMaxConfig;
import com.revrobotics.spark.config.SparkParameters;

public class AbsoluteEncoderConfig
extends BaseConfig {
    public AbsoluteEncoderConfig() {
        super(BaseConfig.CANType.kSpark);
    }

    public AbsoluteEncoderConfig apply(AbsoluteEncoderConfig config) {
        super.apply(config);
        return this;
    }

    public AbsoluteEncoderConfig setSparkMaxDataPortConfig() {
        this.putParameter(SparkParameters.kCompatibilityPortConfig.value, SparkMaxConfig.DataPortConfig.kLimitSwitchesAndAbsoluteEncoder.value);
        return this;
    }

    public AbsoluteEncoderConfig inverted(boolean inverted) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kDutyCycleInverted.value, inverted);
        return this;
    }

    public AbsoluteEncoderConfig positionConversionFactor(double factor) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kDutyCyclePositionFactor.value, (float)factor);
        return this;
    }

    public AbsoluteEncoderConfig velocityConversionFactor(double factor) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kDutyCycleVelocityFactor.value, (float)factor);
        return this;
    }

    public AbsoluteEncoderConfig zeroOffset(double offset) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kDutyCycleOffset.value, (float)offset);
        return this;
    }

    public AbsoluteEncoderConfig averageDepth(int depth) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kDutyCycleAverageDepth.value, switch (depth) {
            case 1 -> 0;
            case 2 -> 1;
            case 4 -> 2;
            case 8 -> 3;
            case 16 -> 4;
            case 32 -> 5;
            case 64 -> 6;
            default -> 7;
        });
        return this;
    }

    public AbsoluteEncoderConfig startPulseUs(double startPulseUs) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kDutyCycleEncoderStartPulseUs.value, (float)startPulseUs);
        return this;
    }

    public AbsoluteEncoderConfig endPulseUs(double endPulseUs) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kDutyCycleEncoderEndPulseUs.value, (float)endPulseUs);
        return this;
    }

    public AbsoluteEncoderConfig zeroCentered(boolean zeroCentered) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kDutyCycleZeroCentered.value, zeroCentered);
        return this;
    }

    public static class Presets {
        public static final AbsoluteEncoderConfig REV_ThroughBoreEncoder = new AbsoluteEncoderConfig().startPulseUs(1.0).endPulseUs(1.0);
        public static final AbsoluteEncoderConfig REV_ThroughBoreEncoderV2 = new AbsoluteEncoderConfig().startPulseUs(3.88443797).endPulseUs(1.94221899);
        public static final AbsoluteEncoderConfig REV_SplineEncoder = new AbsoluteEncoderConfig().startPulseUs(1.0).endPulseUs(1.0);
    }
}

