/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark.config;

import com.revrobotics.config.BaseConfig;
import com.revrobotics.spark.config.SparkMaxConfig;
import com.revrobotics.spark.config.SparkParameters;

public class AlternateEncoderConfig
extends BaseConfig {
    public AlternateEncoderConfig() {
        super(BaseConfig.CANType.kSpark);
    }

    public AlternateEncoderConfig apply(AlternateEncoderConfig config) {
        super.apply(config);
        return this;
    }

    public AlternateEncoderConfig setSparkMaxDataPortConfig() {
        this.putParameter(SparkParameters.kCompatibilityPortConfig.value, SparkMaxConfig.DataPortConfig.kAlternateEncoder.value);
        return this;
    }

    public AlternateEncoderConfig countsPerRevolution(int cpr) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kAltEncoderCountsPerRev.value, cpr);
        return this;
    }

    public AlternateEncoderConfig inverted(boolean inverted) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kAltEncoderInverted.value, inverted);
        return this;
    }

    public AlternateEncoderConfig positionConversionFactor(double factor) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kAltEncoderPositionConversion.value, (float)factor);
        return this;
    }

    public AlternateEncoderConfig velocityConversionFactor(double factor) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kAltEncoderVelocityConversion.value, (float)factor);
        return this;
    }

    public AlternateEncoderConfig averageDepth(int depth) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kAltEncoderAverageDepth.value, depth);
        return this;
    }

    public AlternateEncoderConfig measurementPeriod(int periodMs) {
        this.setSparkMaxDataPortConfig();
        this.putParameter(SparkParameters.kAltEncoderSampleDelta.value, periodMs);
        return this;
    }

    public static enum Type {
        kQuadrature(0);

        public final int value;

        private Type(int value) {
            this.value = value;
        }

        public static Type fromId(int id) {
            return kQuadrature;
        }
    }

    public static class Presets {
        public static final AlternateEncoderConfig REV_ThroughBoreEncoder = new AlternateEncoderConfig().countsPerRevolution(8192);
        public static final AlternateEncoderConfig REV_ThroughBoreEncoderV2 = new AlternateEncoderConfig().countsPerRevolution(8192);
        public static final AlternateEncoderConfig REV_SplineEncoder = new AlternateEncoderConfig().countsPerRevolution(8192);
    }
}

