"use strict";(self.webpackChunkadvantagescope_docs=self.webpackChunkadvantagescope_docs||[]).push([[6625],{2032:(e,t,n)=>{n.r(t),n.d(t,{assets:()=>h,contentTitle:()=>c,default:()=>m,frontMatter:()=>d,metadata:()=>i,toc:()=>u});const i=JSON.parse('{"id":"tab-reference/3d-field/index","title":"\ud83d\udc40 3D Field","description":"The 3D field shows a 3D visualization of the robot and field. It can be used with regular 2D poses, but is especially helpful when working with 3D calculations (like localizing with AprilTags). Multiple camera views are available, including field relative, robot relative, and fixed. AdvantageScope XR allows this tab to be visualized using augmented reality. The timeline shows when the robot is enabled and can be used to navigate through the log data.","source":"@site/docs/tab-reference/3d-field/index.md","sourceDirName":"tab-reference/3d-field","slug":"/tab-reference/3d-field/","permalink":"/tab-reference/3d-field/","draft":false,"unlisted":false,"tags":[],"version":"current","frontMatter":{},"sidebar":"sidebar","previous":{"title":"\ud83d\uddfa 2D Field","permalink":"/tab-reference/2d-field"},"next":{"title":"AdvantageScope XR","permalink":"/tab-reference/3d-field/advantagescope-xr"}}');var a=n(4848),s=n(8453),o=n(1470),r=n(9365),l=n(4511);const d={},c="\ud83d\udc40 3D Field",h={},u=[{value:"Adding Objects",id:"adding-objects",level:2},{value:"Data Format",id:"data-format",level:2},{value:"Mechanisms &amp; Components",id:"mechanisms--components",level:2},{value:"2D Mechanisms",id:"2d-mechanisms",level:3},{value:"3D Components",id:"3d-components",level:3},{value:"Game Piece Objects",id:"game-piece-objects",level:2},{value:"Camera Options",id:"camera-options",level:2},{value:"Orbit Field",id:"orbit-field",level:3},{value:"Orbit Robot",id:"orbit-robot",level:3},{value:"Driver Station",id:"driver-station",level:3},{value:"Fixed Camera",id:"fixed-camera",level:3},{value:"Configuration",id:"configuration",level:2},{value:"Rendering Modes",id:"rendering-modes",level:3}];function p(e){const t={a:"a",admonition:"admonition",code:"code",em:"em",h1:"h1",h2:"h2",h3:"h3",header:"header",img:"img",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,s.R)(),...e.components},{Details:i}=t;return i||function(e,t){throw new Error("Expected "+(t?"component":"object")+" `"+e+"` to be defined: you likely forgot to import, pass, or provide it.")}("Details",!0),(0,a.jsxs)(a.Fragment,{children:[(0,a.jsx)(t.header,{children:(0,a.jsx)(t.h1,{id:"-3d-field",children:"\ud83d\udc40 3D Field"})}),"\n",(0,a.jsxs)(t.p,{children:["The 3D field shows a 3D visualization of the robot and field. It can be used with regular 2D poses, but is especially helpful when working with 3D calculations (like localizing with AprilTags). Multiple camera views are available, including field relative, robot relative, and fixed. ",(0,a.jsx)(t.a,{href:"advantagescope-xr",children:"AdvantageScope XR"})," allows this tab to be visualized using augmented reality. The timeline shows when the robot is enabled and can be used to navigate through the log data."]}),"\n",(0,a.jsx)(t.p,{children:(0,a.jsx)(t.img,{alt:"Example of 3D field tab",src:n(7364).A+"",width:"2590",height:"1728"})}),"\n",(0,a.jsxs)(i,{children:[(0,a.jsx)("summary",{children:"Timeline Controls"}),(0,a.jsx)(t.p,{children:"The timeline is used to control playback and visualization. Clicking on the timeline selects a time, and right-clicking deselects it. The selected time is synchronized across all tabs, making it easy to quickly find this location in other views."}),(0,a.jsx)(t.p,{children:"The green sections of the timeline indicate when the robot is autonomous, and the blue sections indicate when the robot is teleoperated."}),(0,a.jsxs)(t.p,{children:["To zoom, place the cursor over the timeline and scroll up or down. A range can also be selecting by clicking and dragging while holding ",(0,a.jsx)(t.code,{children:"Shift"}),". Move left and right by scrolling horizontally (on supported devices), or by clicking and dragging on the timeline. When connected live, scrolling to the left unlocks from the current time, and scrolling all the way to the right locks to the current time again. Press ",(0,a.jsx)(t.code,{children:"Ctrl+\\"})," to zoom to the period where the robot is enabled."]}),(0,a.jsx)(t.p,{children:(0,a.jsx)(t.img,{alt:"Timeline",src:n(1024).A+"",width:"1560",height:"64"})})]}),"\n",(0,a.jsx)(t.admonition,{type:"warning",children:(0,a.jsxs)(t.p,{children:["The 2026 FRC field model is consistent with the AprilTag layout for the ",(0,a.jsx)(t.strong,{children:"welded"})," field. The differences between the welded and AndyMark fields are very minor, but there may be small (~0.5 inch) misalignments when visualizing AprilTag poses based on the AndyMark field layout."]})}),"\n",(0,a.jsx)(t.h2,{id:"adding-objects",children:"Adding Objects"}),"\n",(0,a.jsxs)(t.p,{children:['To get started, drag a field to the "Poses" section. Delete an object using the X button, or hide it temporarily by clicking the eye icon or double-clicking the field name. To remove all objects, click the trash can near the axis title and then ',(0,a.jsx)(t.code,{children:"Clear All"}),". Objects can be rearranged in the list by clicking and dragging."]}),"\n",(0,a.jsxs)(t.p,{children:[(0,a.jsx)(t.strong,{children:"To customize each object, click the colored icon or right-click on the field name."})," AdvantageScope supports a large number of object types, many of which can be customized (such as changing colors and robot models). Some objects must be added as children to an existing object."]}),"\n",(0,a.jsx)(t.admonition,{type:"tip",children:(0,a.jsxs)(t.p,{children:["To see a full list of supported object types, click the ",(0,a.jsx)(t.code,{children:"?"})," icon. This list also includes the supported data types and whether the objects must be added as children."]})}),"\n",(0,a.jsx)(t.admonition,{type:"info",children:(0,a.jsxs)(t.p,{children:["AdvantageScope supports several sizes of AprilTags for FTC fields. Sizes are measured as the ",(0,a.jsx)(t.strong,{children:"side length of the black section of the AprilTag"}),", not including the required white border."]})}),"\n",(0,a.jsx)(t.h2,{id:"data-format",children:"Data Format"}),"\n",(0,a.jsxs)(t.p,{children:["Geometry data should be published as a byte-encoded struct or protobuf. Various 2D and 3D geometry types are supported, including ",(0,a.jsx)(t.code,{children:"Pose2d"}),", ",(0,a.jsx)(t.code,{children:"Pose3d"}),", ",(0,a.jsx)(t.code,{children:"Translation2d"}),", ",(0,a.jsx)(t.code,{children:"Translation3d"}),", and more."]}),"\n",(0,a.jsx)(t.admonition,{type:"warning",children:(0,a.jsxs)(t.p,{children:["The legacy number array format for geometry data is now deprecated. See ",(0,a.jsx)(t.a,{href:"/overview/legacy-formats",children:"here"})," for details."]})}),"\n",(0,a.jsx)(t.p,{children:"Many libraries support the struct format, including WPILib and AdvantageKit. The example code below shows how to log 3D pose data in Java."}),"\n",(0,a.jsxs)(o.A,{groupId:"library",children:[(0,a.jsxs)(r.A,{value:"wpilib",label:"WPILib",default:!0,children:[(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-java",children:'Pose3d poseA = new Pose3d();\r\nPose3d poseB = new Pose3d();\r\n\r\nStructPublisher<Pose3d> publisher = NetworkTableInstance.getDefault()\r\n  .getStructTopic("MyPose", Pose3d.struct).publish();\r\nStructArrayPublisher<Pose3d> arrayPublisher = NetworkTableInstance.getDefault()\r\n  .getStructArrayTopic("MyPoseArray", Pose3d.struct).publish();\r\n\r\nperiodic() {\r\n  publisher.set(poseA);\r\n  arrayPublisher.set(new Pose3d[] {poseA, poseB});\r\n}\n'})}),(0,a.jsx)(t.admonition,{type:"tip",children:(0,a.jsxs)(t.p,{children:["WPILib's ",(0,a.jsx)(t.a,{href:"https://docs.wpilib.org/en/stable/docs/software/dashboards/glass/field2d-widget.html",children:(0,a.jsx)(t.code,{children:"Field2d"})})," class can also be used to log several sets of 2D pose data together."]})})]}),(0,a.jsx)(r.A,{value:"advantagekit",label:"AdvantageKit",children:(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-java",children:'Pose3d poseA = new Pose3d();\r\nPose3d poseB = new Pose3d();\r\n\r\nLogger.recordOutput("MyPose", poseA);\r\nLogger.recordOutput("MyPoseArray", poseA, poseB);\r\nLogger.recordOutput("MyPoseArray", new Pose3d[] {poseA, poseB});\n'})})}),(0,a.jsx)(r.A,{value:"ftcdashboard",label:"FTC Dashboard",children:(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-java",children:'// This protocol does not support the modern struct format, but pose\r\n// values can be published using separate fields that include the\r\n// suffixes "x", "y", and "heading" (as shown below):\r\nTelemetryPacket packet = new TelemetryPacket();\r\npacket.put("Pose x", 6.3); // Inches\r\npacket.put("Pose y", 2.8); // Inches\r\npacket.put("Pose heading", 3.14); // Radians\r\n\r\n// Alternatively, headings can be published in degrees\r\npacket.put("Pose heading (deg)", 180.0); // Degrees\n'})})})]}),"\n",(0,a.jsx)(t.h2,{id:"mechanisms--components",children:"Mechanisms & Components"}),"\n",(0,a.jsx)(t.p,{children:"Mechanism data can be visualized using 2D mechanisms or articulated 3D components."}),"\n",(0,a.jsx)(t.h3,{id:"2d-mechanisms",children:"2D Mechanisms"}),"\n",(0,a.jsxs)(t.p,{children:["To visualize mechanism data logged using a ",(0,a.jsx)(t.a,{href:"https://docs.wpilib.org/en/stable/docs/software/dashboards/glass/mech2d-widget.html",children:(0,a.jsx)(t.code,{children:"Mechanism2d"})}),", add the mechanism field to an existing robot or ghost object. The mechanism is projected onto the XZ or YZ plane of the robot using simple boxes, as shown below. Click the gear icon or right-click on the field name to switch between the XZ and YZ planes. The robot's origin is centered on the bottom edge of the mechanism."]}),"\n",(0,a.jsx)(t.p,{children:(0,a.jsx)(t.img,{alt:"2D mechanism",src:n(4223).A+"",width:"2138",height:"1368"})}),"\n",(0,a.jsx)(t.h3,{id:"3d-components",children:"3D Components"}),"\n",(0,a.jsx)(t.admonition,{type:"warning",children:(0,a.jsxs)(t.p,{children:["Setting up 3D components can be complex and time-consuming. Consider utilizing AdvantageScope's ",(0,a.jsx)(t.code,{children:"Mechanism2d"})," support as described above, which offers a more streamlined approach to visualize mechanisms on the 3D field."]})}),"\n",(0,a.jsx)(t.p,{children:'Mechanisms can be visualized with articulated components by logging a set of 3D poses that represent the robot-relative locations of each component. Add the poses to an existing robot or ghost object and set the object type to "Component".'}),"\n",(0,a.jsxs)(t.p,{children:["Each component can be moved independently (like an elevator carriage, arm, or end effector). AdvantageKit users should consider using the ",(0,a.jsx)(t.a,{href:"https://docs.advantagekit.org/data-flow/supported-types#mechanisms-output-only",children:(0,a.jsx)(t.code,{children:"generate3dMechanism()"})})," method to convert a Mechanism2d to an array of Pose3d objects. For more information on configuring robots with components, see ",(0,a.jsx)(t.a,{href:"/more-features/custom-assets",children:"Custom Assets"}),"."]}),"\n",(0,a.jsx)(t.p,{children:(0,a.jsx)(t.img,{alt:"3D mechanism",src:n(7286).A+"",width:"1200",height:"768"})}),"\n",(0,a.jsx)(t.h2,{id:"game-piece-objects",children:"Game Piece Objects"}),"\n",(0,a.jsx)(t.p,{children:"Each field includes a set of game piece object types, allowing game pieces to be rendered at any position on the field using data published by the robot code. This has a variety of applications, including:"}),"\n",(0,a.jsxs)(t.ul,{children:["\n",(0,a.jsx)(t.li,{children:"Visualizing the actions of simulated auto routines using simple animations"}),"\n",(0,a.jsx)(t.li,{children:"Showing the detected locations of game pieces on the field"}),"\n",(0,a.jsx)(t.li,{children:"Indicating where game pieces are located within a robot"}),"\n",(0,a.jsx)(t.li,{children:"Viewing shot trajectories based on physics calculations"}),"\n"]}),"\n",(0,a.jsx)(t.p,{children:"Another simple use case is showing the state of game pieces within the robot based on sensor data. For example, a beam break sensor within the note path for a 2024 robot could cause a note to appear (as shown below)."}),"\n",(0,a.jsxs)(i,{children:[(0,a.jsx)("summary",{children:"Code Example"}),(0,a.jsxs)(t.p,{children:["The AdvantageKit KitBot 2024 example project includes a simple example of a ",(0,a.jsx)(t.a,{href:"https://github.com/Mechanical-Advantage/AdvantageKit/blob/18a0219f60108e3dc1e8512d59fcba0e657770af/example_projects/kitbot_2024/src/main/java/frc/robot/util/NoteVisualizer.java",children:"command"})," that animates a note traveling from the robot to the speaker. This command is incorporated into the standard ",(0,a.jsx)(t.a,{href:"https://github.com/Mechanical-Advantage/AdvantageKit/blob/18a0219f60108e3dc1e8512d59fcba0e657770af/example_projects/kitbot_2024/src/main/java/frc/robot/subsystems/launcher/Launcher.java#L73",children:"launch sequence"}),", triggering the animation whenever a note is released. ",(0,a.jsx)(t.a,{href:"https://youtube.com/shorts/-HxfDo9f19U?feature=share",children:"This video"})," shows how game piece animations can be used to visualize auto routines for several different games."]})]}),"\n",(0,a.jsx)(t.p,{children:(0,a.jsx)(t.img,{alt:"2024 KitBot note visualization",src:n(7369).A+"",width:"1500",height:"925"})}),"\n",(0,a.jsx)(t.h2,{id:"camera-options",children:"Camera Options"}),"\n",(0,a.jsx)(t.p,{children:"To switch the selected camera mode, right-click on the rendered field view. The camera mode and position is controlled independently for every pop-up window, allowing for the easy creation of multi-camera views."}),"\n",(0,a.jsx)(t.admonition,{type:"info",children:(0,a.jsx)(t.p,{children:'Right-click the rendered field view and click "Set FOV..." to adjust the FOV of the orbiting and Driver Station cameras.'})}),"\n",(0,a.jsx)(t.h3,{id:"orbit-field",children:"Orbit Field"}),"\n",(0,a.jsxs)(t.p,{children:["This is the default camera mode, where the camera can be freely moved relative to the field. ",(0,a.jsx)(t.strong,{children:"Left-click + drag"})," rotates the camera, and ",(0,a.jsx)(t.strong,{children:"right-click + drag"})," pans the camera. ",(0,a.jsx)(t.strong,{children:"Scroll"})," to zoom in and out."]}),"\n",(0,a.jsx)(t.admonition,{type:"tip",children:(0,a.jsxs)(t.p,{children:["The camera can also be controlled using the keyboard. The ",(0,a.jsx)(t.strong,{children:"WASD"})," keys are used to translate, the ",(0,a.jsx)(t.strong,{children:"IJKL"})," keys are used to rotate, and the ",(0,a.jsx)(t.strong,{children:"E"})," and ",(0,a.jsx)(t.strong,{children:"Q"})," keys are used to translate vertically."]})}),"\n",(0,a.jsx)(t.h3,{id:"orbit-robot",children:"Orbit Robot"}),"\n",(0,a.jsx)(t.p,{children:'This mode has the same controls as the "Orbit Field" mode, but the camera\'s position is locked relative to the robot. This allows for "tracking" shots of the robot\'s movement.'}),"\n",(0,a.jsx)(t.h3,{id:"driver-station",children:"Driver Station"}),"\n",(0,a.jsx)(t.p,{children:'This mode locks the camera behind one of the driver stations at typical eye-height. Either manually choose the station to view or choose "Auto" to use the alliance and station number stored in the log data.'}),"\n",(0,a.jsx)(t.admonition,{type:"warning",children:(0,a.jsx)(t.p,{children:"Automatic selection of station number may be inaccurate when viewing log data produced by AdvantageKit 2023 or earlier."})}),"\n",(0,a.jsx)(t.h3,{id:"fixed-camera",children:"Fixed Camera"}),"\n",(0,a.jsx)(t.p,{children:"Each robot model is configured with a set of fixed cameras, like vision and driver cameras. These cameras have fixed positions, aspect ratios, and FOVs. These views are often useful to check vision data or to simulate a driver camera view. In the example below, a driver camera is shown."}),"\n",(0,a.jsx)(t.p,{children:(0,a.jsx)(t.img,{alt:"Fixed camera",src:n(9248).A+"",width:"1200",height:"900"})}),"\n",(0,a.jsx)(t.p,{children:'If a "Camera Override" pose is provided, it replaces the default poses of all fixed cameras while retaining their configured FOVs and aspect ratios. This allows the robot code to provide the position of a moving camera, like one mounted to a turret or shooter hood.'}),"\n",(0,a.jsx)(t.admonition,{type:"info",children:(0,a.jsxs)(t.p,{children:['Consistent with other pose data, the "Camera Override" pose must be ',(0,a.jsx)(t.em,{children:"field relative"}),", not robot relative."]})}),"\n",(0,a.jsx)(t.h2,{id:"configuration",children:"Configuration"}),"\n",(0,a.jsx)(t.p,{children:'The field model can be configured using the dropdown. All recent FRC and FTC games are supported. We recommend using the "Evergreen" fields for devices with limited graphical performance. The "Axes" fields display only XYZ axes at the origin with a field outline for scale.'}),"\n",(0,a.jsx)(t.admonition,{type:"info",children:(0,a.jsxs)(t.p,{children:["The coordinate system used on the this tab is customizable. See the ",(0,a.jsx)(t.a,{href:"/more-features/coordinate-systems",children:"coordinate system"})," page for details."]})}),"\n",(0,a.jsx)(t.h3,{id:"rendering-modes",children:"Rendering Modes"}),"\n",(0,a.jsx)(t.p,{children:"The 3D field supports three rendering modes:"}),"\n",(0,a.jsxs)(t.ul,{children:["\n",(0,a.jsxs)(t.li,{children:[(0,a.jsx)(t.strong,{children:"Cinematic:"})," Render using shadows, lighting, reflections, and high-detail 3D models for a more realistic look. Requires a decently powerful GPU."]}),"\n",(0,a.jsxs)(t.li,{children:[(0,a.jsx)(t.strong,{children:"Standard (Default):"})," Render with minimal lighting and simplified 3D models. Runs well on most devices."]}),"\n",(0,a.jsxs)(t.li,{children:[(0,a.jsx)(t.strong,{children:"Low Power:"})," Lower the framerate, resolution, and model detail to reduce battery consumption and provide more consistent performance on low-end devices."]}),"\n"]}),"\n",(0,a.jsx)(t.p,{children:(0,a.jsx)(t.img,{alt:"Comparion of rendering modes",src:n(1227).A+"",width:"2500",height:"576"})}),"\n",(0,a.jsxs)(t.p,{children:["To configure the rendering mode, open the preferences window by pressing clicking ",(0,a.jsx)(t.code,{children:"App"})," > ",(0,a.jsx)(t.code,{children:"Show Preferences..."})," (Windows/Linux) or ",(0,a.jsx)(t.code,{children:"AdvantageScope"})," > ",(0,a.jsx)(t.code,{children:"Settings..."}),' (macOS). The "3D Mode (Battery)" setting can be switched from the default to override the rendering mode used on a laptop when not charging. For example, this can be used to preserve battery while at competition.']}),"\n",(0,a.jsx)("img",{src:l.A,alt:"Diagram of preferences",height:"350"})]})}function m(e={}){const{wrapper:t}={...(0,s.R)(),...e.components};return t?(0,a.jsx)(t,{...e,children:(0,a.jsx)(p,{...e})}):p(e)}},9365:(e,t,n)=>{n.d(t,{A:()=>o});n(6540);var i=n(4164);const a={tabItem:"tabItem_Ymn6"};var s=n(4848);function o({children:e,hidden:t,className:n}){return(0,s.jsx)("div",{role:"tabpanel",className:(0,i.A)(a.tabItem,n),hidden:t,children:e})}},1470:(e,t,n)=>{n.d(t,{A:()=>A});var i=n(6540),a=n(4164),s=n(7559),o=n(3104),r=n(6347),l=n(205),d=n(7485),c=n(1682),h=n(679);function u(e){return i.Children.toArray(e).filter((e=>"\n"!==e)).map((e=>{if(!e||(0,i.isValidElement)(e)&&function(e){const{props:t}=e;return!!t&&"object"==typeof t&&"value"in t}(e))return e;throw new Error(`Docusaurus error: Bad <Tabs> child <${"string"==typeof e.type?e.type:e.type.name}>: all children of the <Tabs> component should be <TabItem>, and every <TabItem> should have a unique "value" prop.`)}))?.filter(Boolean)??[]}function p(e){const{values:t,children:n}=e;return(0,i.useMemo)((()=>{const e=t??function(e){return u(e).map((({props:{value:e,label:t,attributes:n,default:i}})=>({value:e,label:t,attributes:n,default:i})))}(n);return function(e){const t=(0,c.XI)(e,((e,t)=>e.value===t.value));if(t.length>0)throw new Error(`Docusaurus error: Duplicate values "${t.map((e=>e.value)).join(", ")}" found in <Tabs>. Every value needs to be unique.`)}(e),e}),[t,n])}function m({value:e,tabValues:t}){return t.some((t=>t.value===e))}function g({queryString:e=!1,groupId:t}){const n=(0,r.W6)(),a=function({queryString:e=!1,groupId:t}){if("string"==typeof e)return e;if(!1===e)return null;if(!0===e&&!t)throw new Error('Docusaurus error: The <Tabs> component groupId prop is required if queryString=true, because this value is used as the search param name. You can also provide an explicit value such as queryString="my-search-param".');return t??null}({queryString:e,groupId:t});return[(0,d.aZ)(a),(0,i.useCallback)((e=>{if(!a)return;const t=new URLSearchParams(n.location.search);t.set(a,e),n.replace({...n.location,search:t.toString()})}),[a,n])]}function b(e){const{defaultValue:t,queryString:n=!1,groupId:a}=e,s=p(e),[o,r]=(0,i.useState)((()=>function({defaultValue:e,tabValues:t}){if(0===t.length)throw new Error("Docusaurus error: the <Tabs> component requires at least one <TabItem> children component");if(e){if(!m({value:e,tabValues:t}))throw new Error(`Docusaurus error: The <Tabs> has a defaultValue "${e}" but none of its children has the corresponding value. Available values are: ${t.map((e=>e.value)).join(", ")}. If you intend to show no default tab, use defaultValue={null} instead.`);return e}const n=t.find((e=>e.default))??t[0];if(!n)throw new Error("Unexpected error: 0 tabValues");return n.value}({defaultValue:t,tabValues:s}))),[d,c]=g({queryString:n,groupId:a}),[u,b]=function({groupId:e}){const t=function(e){return e?`docusaurus.tab.${e}`:null}(e),[n,a]=(0,h.Dv)(t);return[n,(0,i.useCallback)((e=>{t&&a.set(e)}),[t,a])]}({groupId:a}),f=(()=>{const e=d??u;return m({value:e,tabValues:s})?e:null})();(0,l.A)((()=>{f&&r(f)}),[f]);return{selectedValue:o,selectValue:(0,i.useCallback)((e=>{if(!m({value:e,tabValues:s}))throw new Error(`Can't select invalid tab value=${e}`);r(e),c(e),b(e)}),[c,b,s]),tabValues:s}}var f=n(2303);const x={tabList:"tabList__CuJ",tabItem:"tabItem_LNqP"};var v=n(4848);function j({className:e,block:t,selectedValue:n,selectValue:i,tabValues:s}){const r=[],{blockElementScrollPositionUntilNextRender:l}=(0,o.a_)(),d=e=>{const t=e.currentTarget,a=r.indexOf(t),o=s[a].value;o!==n&&(l(t),i(o))},c=e=>{let t=null;switch(e.key){case"Enter":d(e);break;case"ArrowRight":{const n=r.indexOf(e.currentTarget)+1;t=r[n]??r[0];break}case"ArrowLeft":{const n=r.indexOf(e.currentTarget)-1;t=r[n]??r[r.length-1];break}}t?.focus()};return(0,v.jsx)("ul",{role:"tablist","aria-orientation":"horizontal",className:(0,a.A)("tabs",{"tabs--block":t},e),children:s.map((({value:e,label:t,attributes:i})=>(0,v.jsx)("li",{role:"tab",tabIndex:n===e?0:-1,"aria-selected":n===e,ref:e=>{r.push(e)},onKeyDown:c,onClick:d,...i,className:(0,a.A)("tabs__item",x.tabItem,i?.className,{"tabs__item--active":n===e}),children:t??e},e)))})}function w({lazy:e,children:t,selectedValue:n}){const s=(Array.isArray(t)?t:[t]).filter(Boolean);if(e){const e=s.find((e=>e.props.value===n));return e?(0,i.cloneElement)(e,{className:(0,a.A)("margin-top--md",e.props.className)}):null}return(0,v.jsx)("div",{className:"margin-top--md",children:s.map(((e,t)=>(0,i.cloneElement)(e,{key:t,hidden:e.props.value!==n})))})}function y(e){const t=b(e);return(0,v.jsxs)("div",{className:(0,a.A)(s.G.tabs.container,"tabs-container",x.tabList),children:[(0,v.jsx)(j,{...t,...e}),(0,v.jsx)(w,{...t,...e})]})}function A(e){const t=(0,f.A)();return(0,v.jsx)(y,{...e,children:u(e.children)},String(t))}},4511:(e,t,n)=>{n.d(t,{A:()=>i});const i=n.p+"assets/images/prefs-3a50cffe16fbbaeb73e7bc0e9fe66d38.png"},7364:(e,t,n)=>{n.d(t,{A:()=>i});const i=n.p+"assets/images/3d-field-1-5a9b65221b7a7b12c2c0ed8d5eb5b76e.png"},4223:(e,t,n)=>{n.d(t,{A:()=>i});const i=n.p+"assets/images/3d-field-2-de6375184e7270a9c4421361d3ba844b.png"},7286:(e,t,n)=>{n.d(t,{A:()=>i});const i=n.p+"assets/images/3d-field-3-23c69122e650c2d1a52e606abb1983df.png"},7369:(e,t,n)=>{n.d(t,{A:()=>i});const i=n.p+"assets/images/3d-field-4-d04e7a0a2abfe093e5380b0736db5e3f.png"},9248:(e,t,n)=>{n.d(t,{A:()=>i});const i=n.p+"assets/images/3d-field-5-262dac898cd0927f1b82bb9a1dc8aaed.png"},1227:(e,t,n)=>{n.d(t,{A:()=>i});const i=n.p+"assets/images/3d-field-6-2230f6615deb4c30031b0974583c9cf6.png"},1024:(e,t,n)=>{n.d(t,{A:()=>i});const i=n.p+"assets/images/timeline-49a7a2d7967ecebb06a54e460dffa7b3.png"},8453:(e,t,n)=>{n.d(t,{R:()=>o,x:()=>r});var i=n(6540);const a={},s=i.createContext(a);function o(e){const t=i.useContext(s);return i.useMemo((function(){return"function"==typeof e?e(t):{...t,...e}}),[t,e])}function r(e){let t;return t=e.disableParentContext?"function"==typeof e.components?e.components(a):e.components||a:o(e.components),i.createElement(s.Provider,{value:t},e.children)}}}]);