/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.device.detection;

import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBridgeCallback;
import com.revrobotics.device.detection.AllCanFrames;
import com.revrobotics.device.detection.detectors.DfuDetector;
import com.revrobotics.device.detection.detectors.FRCCanDetector;
import com.revrobotics.device.detection.detectors.GsUsbDetector;
import com.revrobotics.device.detection.device.DeviceTree;
import com.revrobotics.device.detection.device.DeviceType;
import com.revrobotics.device.detection.device.Manufacturer;
import com.revrobotics.device.detection.dfu.DfuDevice;
import com.revrobotics.device.detection.dfu.DfuManager;
import com.revrobotics.device.detection.gsusb.GSUsbManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Detector {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final List<StagedCallback> scanCallbacks = new ArrayList<StagedCallback>();
    private final List<DeviceTree> detectedDevices = new ArrayList<DeviceTree>();
    final CanBridge canBridge;
    private final DeviceDetector[] deviceDetectors;

    public Detector(CanBridge bridge, DfuManager dfuManager, GSUsbManager gsUsbManager) {
        this.canBridge = bridge;
        this.deviceDetectors = new DeviceDetector[]{new FRCCanDetector(this.canBridge).frcCanDeviceDetector(), new GsUsbDetector(gsUsbManager).gsUsbDeviceDetector(), new DfuDetector(dfuManager).dfuDeviceDetector()};
        this.addScanCallback(DetectorStage.DEVICES_DETECTED, (devices, newDevices, removedDevices, changedDevices) -> this.logger.log(Level.INFO, "Detected devices: " + String.valueOf(devices)));
    }

    public void iterate(AllCanFrames allFrames) {
        ArrayList<DeviceTree> addedDevices = new ArrayList<DeviceTree>();
        ArrayList<DeviceTree> changedDevices = new ArrayList<DeviceTree>();
        ArrayList<DeviceTree> removedDevices = new ArrayList<DeviceTree>();
        for (DeviceDetector detector : this.deviceDetectors) {
            detector.iterate(allFrames);
        }
        for (DeviceDetector detector : this.deviceDetectors) {
            List<DeviceTree> toRemove = detector.devicesToRemove(this.detectedDevices);
            removedDevices.addAll(toRemove);
            this.detectedDevices.removeAll(toRemove);
        }
        for (DeviceDetector detector : this.deviceDetectors) {
            List<DeviceTree> toChange = detector.updateDeviceTrees(this.detectedDevices);
            changedDevices.addAll(toChange);
            this.detectedDevices.removeIf(tree -> changedDevices.stream().anyMatch(other -> other.descriptor().equals(tree.descriptor())));
            this.detectedDevices.addAll(changedDevices);
        }
        for (DeviceDetector detector : this.deviceDetectors) {
            List<DeviceTree> toAdd = detector.devicesToAdd(this.detectedDevices);
            addedDevices.addAll(toAdd);
            this.detectedDevices.addAll(toAdd);
        }
        if (!(changedDevices.isEmpty() && addedDevices.isEmpty() && removedDevices.isEmpty())) {
            Thread t = this.createCallbackThread(addedDevices, removedDevices, changedDevices);
            t.start();
        }
    }

    private Thread createCallbackThread(List<DeviceTree> addedDevices, List<DeviceTree> removedDevices, List<DeviceTree> changedDevices) {
        ArrayList<StagedCallback> callbacks = new ArrayList<StagedCallback>(this.scanCallbacks);
        Thread t = new Thread(() -> {
            try {
                callbacks.forEach(stagedCallback -> stagedCallback.callback.onNewScanResult(List.copyOf(this.detectedDevices), List.copyOf(addedDevices), List.copyOf(removedDevices), List.copyOf(changedDevices)));
            }
            catch (Exception e) {
                this.logger.severe("Exception while processing callbacks: " + e.getMessage());
                e.printStackTrace();
            }
        });
        t.setName("Scan callback thread");
        t.setDaemon(true);
        return t;
    }

    public static UUID deviceUUID(int id, DeviceType type, Manufacturer manufacturer) {
        String text = Integer.toHexString(id) + type.name() + manufacturer.name();
        return UUID.nameUUIDFromBytes(text.getBytes());
    }

    public CanBridgeCallback addCanBridgeCallback(CanBridgeCallback callback) {
        return this.canBridge.addCallback(callback);
    }

    public void removeCanBridgeCallback(CanBridgeCallback callback) {
        this.canBridge.removeCallback(callback);
    }

    public ScanCallback addScanCallback(DetectorStage stage, ScanCallback scanCallback) {
        this.scanCallbacks.add(new StagedCallback(stage, scanCallback));
        this.scanCallbacks.sort(Comparator.comparingInt(stagedValue -> stagedValue.stage.index));
        scanCallback.onNewScanResult(List.copyOf(this.detectedDevices), List.copyOf(this.detectedDevices), Collections.emptyList(), Collections.emptyList());
        return scanCallback;
    }

    public void addDfuUpdatingDevice(DfuDevice device) {
        Arrays.stream(this.deviceDetectors).filter(d -> d instanceof DfuDetector).forEach(d -> ((DfuDetector)((Object)d)).addDfuUpdatingDevice(device));
    }

    public void removeDfuUpdatingDevice(DfuDevice device) {
        Arrays.stream(this.deviceDetectors).filter(d -> d instanceof DfuDetector).forEach(d -> ((DfuDetector)((Object)d)).removeDfuUpdatingDevice(device));
    }

    public void close() {
        this.scanCallbacks.clear();
        this.detectedDevices.clear();
    }

    public void removeCallback(ScanCallback callback) {
        this.scanCallbacks.removeIf(stagedCallback -> stagedCallback.callback == callback);
    }

    public static interface DeviceDetector {
        public void iterate(AllCanFrames var1);

        public List<DeviceTree> devicesToRemove(List<DeviceTree> var1);

        public List<DeviceTree> devicesToAdd(List<DeviceTree> var1);

        public List<DeviceTree> updateDeviceTrees(List<DeviceTree> var1);
    }

    public static enum DetectorStage {
        DEVICES_DETECTED(0),
        INITIALIZING(1),
        FULLY_INITIALIZED(2);

        final int index;

        private DetectorStage(int index) {
            this.index = index;
        }
    }

    public static interface ScanCallback {
        public void onNewScanResult(List<DeviceTree> var1, List<DeviceTree> var2, List<DeviceTree> var3, List<DeviceTree> var4);
    }

    private record StagedCallback(DetectorStage stage, ScanCallback callback) {
    }
}

