/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.device.detection.detectors;

import com.revrobotics.device.detection.AllCanFrames;
import com.revrobotics.device.detection.Detector;
import com.revrobotics.device.detection.device.DeviceTree;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.device.detection.device.RecognizedDevice;
import com.revrobotics.device.detection.dfu.DfuDevice;
import com.revrobotics.device.detection.dfu.DfuManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public class DfuDetector {
    private final DfuManager dfuManager;
    private final List<DfuDevice> dfuUpdatingDevices = new CopyOnWriteArrayList<DfuDevice>();

    public DfuDetector(DfuManager dfuManager) {
        this.dfuManager = dfuManager;
    }

    public Detector.DeviceDetector dfuDeviceDetector() {
        return new Detector.DeviceDetector(){
            List<DfuDevice> dfuDevices;

            @Override
            public void iterate(AllCanFrames allFrames) {
                this.dfuDevices = DfuDetector.this.dfuManager.listDevices();
                this.dfuDevices = this.dfuDevices.stream().filter(DfuDetector::isRelevantDfu).toList();
            }

            @Override
            public List<DeviceTree> devicesToRemove(List<DeviceTree> devices) {
                return devices.stream().filter(device -> DfuDetector.this.dfuDeviceCanBeRemoved(this.dfuDevices, (DeviceTree)device)).toList();
            }

            @Override
            public List<DeviceTree> devicesToAdd(List<DeviceTree> devices) {
                ArrayList<DeviceTree> addedDevices = new ArrayList<DeviceTree>();
                for (DfuDevice device : this.dfuDevices) {
                    Optional<DeviceTree> matchingDeviceTree = devices.stream().filter(tree -> Objects.equals(tree.descriptor(), device.serial())).findFirst();
                    if (!matchingDeviceTree.isEmpty()) continue;
                    FRCCanDevice dfuDevice = DfuDetector.createDfuDevice(device);
                    DeviceTree newTree = new DeviceTree(dfuDevice, device.serial(), Collections.emptyList());
                    addedDevices.add(newTree);
                }
                return addedDevices;
            }

            @Override
            public List<DeviceTree> updateDeviceTrees(List<DeviceTree> devices) {
                return List.of();
            }
        };
    }

    private static boolean isRelevantDfu(DfuDevice device) {
        return device.vid() == 1155 && device.pid() == 57105 && device.alt() == 0;
    }

    private static FRCCanDevice createDfuDevice(DfuDevice device) {
        return new FRCCanDevice(device.serial(), 0, true, RecognizedDevice.DFU, UUID.nameUUIDFromBytes("DFU".getBytes()));
    }

    private boolean dfuDeviceCanBeRemoved(List<DfuDevice> dfuDevices, DeviceTree device) {
        return this.isDfuDevice(device) && dfuDevices.stream().noneMatch(d -> d.serial().equals(device.descriptor())) && this.dfuUpdatingDevices.stream().noneMatch(d -> d.serial().equals(device.descriptor()));
    }

    private boolean isDfuDevice(DeviceTree device) {
        if (device.root() == null) {
            return false;
        }
        return device.root().type() == RecognizedDevice.DFU;
    }

    public void addDfuUpdatingDevice(DfuDevice device) {
        this.dfuUpdatingDevices.add(device);
    }

    public void removeDfuUpdatingDevice(DfuDevice device) {
        this.dfuUpdatingDevices.remove(device);
    }
}

